<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportMeansType StructType
 * @subpackage Structs
 */
class TransportMeansType extends AbstractStructBase
{
    /**
     * The JourneyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:JourneyID
     * @var \TurkkepEFatura\StructType\JourneyIDType
     */
    public $JourneyID;
    /**
     * The RegistrationNationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:RegistrationNationalityID
     * @var \TurkkepEFatura\StructType\RegistrationNationalityIDType
     */
    public $RegistrationNationalityID;
    /**
     * The RegistrationNationality
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:RegistrationNationality
     * @var \TurkkepEFatura\StructType\RegistrationNationalityType[]
     */
    public $RegistrationNationality;
    /**
     * The DirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DirectionCode
     * @var \TurkkepEFatura\StructType\DirectionCodeType
     */
    public $DirectionCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransportMeansTypeCode
     * @var \TurkkepEFatura\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TradeServiceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TradeServiceCode
     * @var \TurkkepEFatura\StructType\TradeServiceCodeType
     */
    public $TradeServiceCode;
    /**
     * The Stowage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\StowageType
     */
    public $Stowage;
    /**
     * The AirTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AirTransportType
     */
    public $AirTransport;
    /**
     * The RoadTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\RoadTransportType
     */
    public $RoadTransport;
    /**
     * The RailTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\RailTransportType
     */
    public $RailTransport;
    /**
     * The MaritimeTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public $MaritimeTransport;
    /**
     * The OwnerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $OwnerParty;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for TransportMeansType
     * @uses TransportMeansType::setJourneyID()
     * @uses TransportMeansType::setRegistrationNationalityID()
     * @uses TransportMeansType::setRegistrationNationality()
     * @uses TransportMeansType::setDirectionCode()
     * @uses TransportMeansType::setTransportMeansTypeCode()
     * @uses TransportMeansType::setTradeServiceCode()
     * @uses TransportMeansType::setStowage()
     * @uses TransportMeansType::setAirTransport()
     * @uses TransportMeansType::setRoadTransport()
     * @uses TransportMeansType::setRailTransport()
     * @uses TransportMeansType::setMaritimeTransport()
     * @uses TransportMeansType::setOwnerParty()
     * @uses TransportMeansType::setMeasurementDimension()
     * @param \TurkkepEFatura\StructType\JourneyIDType $journeyID
     * @param \TurkkepEFatura\StructType\RegistrationNationalityIDType $registrationNationalityID
     * @param \TurkkepEFatura\StructType\RegistrationNationalityType[] $registrationNationality
     * @param \TurkkepEFatura\StructType\DirectionCodeType $directionCode
     * @param \TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \TurkkepEFatura\StructType\TradeServiceCodeType $tradeServiceCode
     * @param \TurkkepEFatura\StructType\StowageType $stowage
     * @param \TurkkepEFatura\StructType\AirTransportType $airTransport
     * @param \TurkkepEFatura\StructType\RoadTransportType $roadTransport
     * @param \TurkkepEFatura\StructType\RailTransportType $railTransport
     * @param \TurkkepEFatura\StructType\MaritimeTransportType $maritimeTransport
     * @param \TurkkepEFatura\StructType\PartyType $ownerParty
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\TurkkepEFatura\StructType\JourneyIDType $journeyID = null, \TurkkepEFatura\StructType\RegistrationNationalityIDType $registrationNationalityID = null, array $registrationNationality = array(), \TurkkepEFatura\StructType\DirectionCodeType $directionCode = null, \TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \TurkkepEFatura\StructType\TradeServiceCodeType $tradeServiceCode = null, \TurkkepEFatura\StructType\StowageType $stowage = null, \TurkkepEFatura\StructType\AirTransportType $airTransport = null, \TurkkepEFatura\StructType\RoadTransportType $roadTransport = null, \TurkkepEFatura\StructType\RailTransportType $railTransport = null, \TurkkepEFatura\StructType\MaritimeTransportType $maritimeTransport = null, \TurkkepEFatura\StructType\PartyType $ownerParty = null, array $measurementDimension = array())
    {
        $this
            ->setJourneyID($journeyID)
            ->setRegistrationNationalityID($registrationNationalityID)
            ->setRegistrationNationality($registrationNationality)
            ->setDirectionCode($directionCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTradeServiceCode($tradeServiceCode)
            ->setStowage($stowage)
            ->setAirTransport($airTransport)
            ->setRoadTransport($roadTransport)
            ->setRailTransport($railTransport)
            ->setMaritimeTransport($maritimeTransport)
            ->setOwnerParty($ownerParty)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get JourneyID value
     * @return \TurkkepEFatura\StructType\JourneyIDType|null
     */
    public function getJourneyID()
    {
        return $this->JourneyID;
    }
    /**
     * Set JourneyID value
     * @param \TurkkepEFatura\StructType\JourneyIDType $journeyID
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setJourneyID(\TurkkepEFatura\StructType\JourneyIDType $journeyID = null)
    {
        $this->JourneyID = $journeyID;
        return $this;
    }
    /**
     * Get RegistrationNationalityID value
     * @return \TurkkepEFatura\StructType\RegistrationNationalityIDType|null
     */
    public function getRegistrationNationalityID()
    {
        return $this->RegistrationNationalityID;
    }
    /**
     * Set RegistrationNationalityID value
     * @param \TurkkepEFatura\StructType\RegistrationNationalityIDType $registrationNationalityID
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setRegistrationNationalityID(\TurkkepEFatura\StructType\RegistrationNationalityIDType $registrationNationalityID = null)
    {
        $this->RegistrationNationalityID = $registrationNationalityID;
        return $this;
    }
    /**
     * Get RegistrationNationality value
     * @return \TurkkepEFatura\StructType\RegistrationNationalityType[]|null
     */
    public function getRegistrationNationality()
    {
        return $this->RegistrationNationality;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistrationNationality method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistrationNationality method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationNationalityForArrayConstraintsFromSetRegistrationNationality(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportMeansTypeRegistrationNationalityItem) {
            // validation for constraint: itemType
            if (!$transportMeansTypeRegistrationNationalityItem instanceof \TurkkepEFatura\StructType\RegistrationNationalityType) {
                $invalidValues[] = is_object($transportMeansTypeRegistrationNationalityItem) ? get_class($transportMeansTypeRegistrationNationalityItem) : sprintf('%s(%s)', gettype($transportMeansTypeRegistrationNationalityItem), var_export($transportMeansTypeRegistrationNationalityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegistrationNationality property can only contain items of type \TurkkepEFatura\StructType\RegistrationNationalityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegistrationNationality value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\RegistrationNationalityType[] $registrationNationality
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setRegistrationNationality(array $registrationNationality = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationNationalityArrayErrorMessage = self::validateRegistrationNationalityForArrayConstraintsFromSetRegistrationNationality($registrationNationality))) {
            throw new \InvalidArgumentException($registrationNationalityArrayErrorMessage, __LINE__);
        }
        $this->RegistrationNationality = $registrationNationality;
        return $this;
    }
    /**
     * Add item to RegistrationNationality value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\RegistrationNationalityType $item
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function addToRegistrationNationality(\TurkkepEFatura\StructType\RegistrationNationalityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\RegistrationNationalityType) {
            throw new \InvalidArgumentException(sprintf('The RegistrationNationality property can only contain items of type \TurkkepEFatura\StructType\RegistrationNationalityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegistrationNationality[] = $item;
        return $this;
    }
    /**
     * Get DirectionCode value
     * @return \TurkkepEFatura\StructType\DirectionCodeType|null
     */
    public function getDirectionCode()
    {
        return $this->DirectionCode;
    }
    /**
     * Set DirectionCode value
     * @param \TurkkepEFatura\StructType\DirectionCodeType $directionCode
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setDirectionCode(\TurkkepEFatura\StructType\DirectionCodeType $directionCode = null)
    {
        $this->DirectionCode = $directionCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \TurkkepEFatura\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setTransportMeansTypeCode(\TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TradeServiceCode value
     * @return \TurkkepEFatura\StructType\TradeServiceCodeType|null
     */
    public function getTradeServiceCode()
    {
        return $this->TradeServiceCode;
    }
    /**
     * Set TradeServiceCode value
     * @param \TurkkepEFatura\StructType\TradeServiceCodeType $tradeServiceCode
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setTradeServiceCode(\TurkkepEFatura\StructType\TradeServiceCodeType $tradeServiceCode = null)
    {
        $this->TradeServiceCode = $tradeServiceCode;
        return $this;
    }
    /**
     * Get Stowage value
     * @return \TurkkepEFatura\StructType\StowageType|null
     */
    public function getStowage()
    {
        return $this->Stowage;
    }
    /**
     * Set Stowage value
     * @param \TurkkepEFatura\StructType\StowageType $stowage
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setStowage(\TurkkepEFatura\StructType\StowageType $stowage = null)
    {
        $this->Stowage = $stowage;
        return $this;
    }
    /**
     * Get AirTransport value
     * @return \TurkkepEFatura\StructType\AirTransportType|null
     */
    public function getAirTransport()
    {
        return $this->AirTransport;
    }
    /**
     * Set AirTransport value
     * @param \TurkkepEFatura\StructType\AirTransportType $airTransport
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setAirTransport(\TurkkepEFatura\StructType\AirTransportType $airTransport = null)
    {
        $this->AirTransport = $airTransport;
        return $this;
    }
    /**
     * Get RoadTransport value
     * @return \TurkkepEFatura\StructType\RoadTransportType|null
     */
    public function getRoadTransport()
    {
        return $this->RoadTransport;
    }
    /**
     * Set RoadTransport value
     * @param \TurkkepEFatura\StructType\RoadTransportType $roadTransport
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setRoadTransport(\TurkkepEFatura\StructType\RoadTransportType $roadTransport = null)
    {
        $this->RoadTransport = $roadTransport;
        return $this;
    }
    /**
     * Get RailTransport value
     * @return \TurkkepEFatura\StructType\RailTransportType|null
     */
    public function getRailTransport()
    {
        return $this->RailTransport;
    }
    /**
     * Set RailTransport value
     * @param \TurkkepEFatura\StructType\RailTransportType $railTransport
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setRailTransport(\TurkkepEFatura\StructType\RailTransportType $railTransport = null)
    {
        $this->RailTransport = $railTransport;
        return $this;
    }
    /**
     * Get MaritimeTransport value
     * @return \TurkkepEFatura\StructType\MaritimeTransportType|null
     */
    public function getMaritimeTransport()
    {
        return $this->MaritimeTransport;
    }
    /**
     * Set MaritimeTransport value
     * @param \TurkkepEFatura\StructType\MaritimeTransportType $maritimeTransport
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setMaritimeTransport(\TurkkepEFatura\StructType\MaritimeTransportType $maritimeTransport = null)
    {
        $this->MaritimeTransport = $maritimeTransport;
        return $this;
    }
    /**
     * Get OwnerParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getOwnerParty()
    {
        return $this->OwnerParty;
    }
    /**
     * Set OwnerParty value
     * @param \TurkkepEFatura\StructType\PartyType $ownerParty
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setOwnerParty(\TurkkepEFatura\StructType\PartyType $ownerParty = null)
    {
        $this->OwnerParty = $ownerParty;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \TurkkepEFatura\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportMeansTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportMeansTypeMeasurementDimensionItem instanceof \TurkkepEFatura\StructType\DimensionType) {
                $invalidValues[] = is_object($transportMeansTypeMeasurementDimensionItem) ? get_class($transportMeansTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportMeansTypeMeasurementDimensionItem), var_export($transportMeansTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType $item
     * @return \TurkkepEFatura\StructType\TransportMeansType
     */
    public function addToMeasurementDimension(\TurkkepEFatura\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
