<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSubtotal StructType
 * @subpackage Structs
 */
class TaxSubtotal extends AbstractStructBase
{
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxType;
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxAmount;
    /**
     * The CalculationSequenceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalculationSequenceNo;
    /**
     * The TaxPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxPercent;
    /**
     * The BaseUnitMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaseUnitMeasure;
    /**
     * The PerUnitMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PerUnitMeasure;
    /**
     * The TaxExemptionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxExemptionReason;
    /**
     * Constructor method for TaxSubtotal
     * @uses TaxSubtotal::setTaxType()
     * @uses TaxSubtotal::setTaxableAmount()
     * @uses TaxSubtotal::setTaxAmount()
     * @uses TaxSubtotal::setCalculationSequenceNo()
     * @uses TaxSubtotal::setTaxPercent()
     * @uses TaxSubtotal::setBaseUnitMeasure()
     * @uses TaxSubtotal::setPerUnitMeasure()
     * @uses TaxSubtotal::setTaxExemptionReason()
     * @param string $taxType
     * @param float $taxableAmount
     * @param float $taxAmount
     * @param int $calculationSequenceNo
     * @param float $taxPercent
     * @param string $baseUnitMeasure
     * @param string $perUnitMeasure
     * @param string $taxExemptionReason
     */
    public function __construct($taxType = null, $taxableAmount = null, $taxAmount = null, $calculationSequenceNo = null, $taxPercent = null, $baseUnitMeasure = null, $perUnitMeasure = null, $taxExemptionReason = null)
    {
        $this
            ->setTaxType($taxType)
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setCalculationSequenceNo($calculationSequenceNo)
            ->setTaxPercent($taxPercent)
            ->setBaseUnitMeasure($baseUnitMeasure)
            ->setPerUnitMeasure($perUnitMeasure)
            ->setTaxExemptionReason($taxExemptionReason);
    }
    /**
     * Get TaxType value
     * @return string
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @uses \TurkkepEFatura\EnumType\TaxType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\TaxType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxType
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\TaxType::valueIsValid($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\TaxType', is_array($taxType) ? implode(', ', $taxType) : var_export($taxType, true), implode(', ', \TurkkepEFatura\EnumType\TaxType::getValidValues())), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get TaxableAmount value
     * @return float
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param float $taxableAmount
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setTaxableAmount($taxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxableAmount) && !(is_float($taxableAmount) || is_numeric($taxableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxableAmount, true), gettype($taxableAmount)), __LINE__);
        }
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get CalculationSequenceNo value
     * @return int
     */
    public function getCalculationSequenceNo()
    {
        return $this->CalculationSequenceNo;
    }
    /**
     * Set CalculationSequenceNo value
     * @param int $calculationSequenceNo
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setCalculationSequenceNo($calculationSequenceNo = null)
    {
        // validation for constraint: int
        if (!is_null($calculationSequenceNo) && !(is_int($calculationSequenceNo) || ctype_digit($calculationSequenceNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($calculationSequenceNo, true), gettype($calculationSequenceNo)), __LINE__);
        }
        $this->CalculationSequenceNo = $calculationSequenceNo;
        return $this;
    }
    /**
     * Get TaxPercent value
     * @return float
     */
    public function getTaxPercent()
    {
        return $this->TaxPercent;
    }
    /**
     * Set TaxPercent value
     * @param float $taxPercent
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setTaxPercent($taxPercent = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercent) && !(is_float($taxPercent) || is_numeric($taxPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercent, true), gettype($taxPercent)), __LINE__);
        }
        $this->TaxPercent = $taxPercent;
        return $this;
    }
    /**
     * Get BaseUnitMeasure value
     * @return string|null
     */
    public function getBaseUnitMeasure()
    {
        return $this->BaseUnitMeasure;
    }
    /**
     * Set BaseUnitMeasure value
     * @param string $baseUnitMeasure
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setBaseUnitMeasure($baseUnitMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($baseUnitMeasure) && !is_string($baseUnitMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseUnitMeasure, true), gettype($baseUnitMeasure)), __LINE__);
        }
        $this->BaseUnitMeasure = $baseUnitMeasure;
        return $this;
    }
    /**
     * Get PerUnitMeasure value
     * @return string|null
     */
    public function getPerUnitMeasure()
    {
        return $this->PerUnitMeasure;
    }
    /**
     * Set PerUnitMeasure value
     * @param string $perUnitMeasure
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setPerUnitMeasure($perUnitMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($perUnitMeasure) && !is_string($perUnitMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perUnitMeasure, true), gettype($perUnitMeasure)), __LINE__);
        }
        $this->PerUnitMeasure = $perUnitMeasure;
        return $this;
    }
    /**
     * Get TaxExemptionReason value
     * @return string|null
     */
    public function getTaxExemptionReason()
    {
        return $this->TaxExemptionReason;
    }
    /**
     * Set TaxExemptionReason value
     * @param string $taxExemptionReason
     * @return \TurkkepEFatura\StructType\TaxSubtotal
     */
    public function setTaxExemptionReason($taxExemptionReason = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptionReason) && !is_string($taxExemptionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptionReason, true), gettype($taxExemptionReason)), __LINE__);
        }
        $this->TaxExemptionReason = $taxExemptionReason;
        return $this;
    }
}
