<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HandlingCode
     * @var \TurkkepEFatura\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HandlingInstructions
     * @var \TurkkepEFatura\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:GrossWeightMeasure
     * @var \TurkkepEFatura\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:NetWeightMeasure
     * @var \TurkkepEFatura\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:GrossVolumeMeasure
     * @var \TurkkepEFatura\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:NetVolumeMeasure
     * @var \TurkkepEFatura\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TotalGoodsItemQuantity
     * @var \TurkkepEFatura\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TotalTransportHandlingUnitQuantity
     * @var \TurkkepEFatura\StructType\TotalTransportHandlingUnitQuantityType
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:InsuranceValueAmount
     * @var \TurkkepEFatura\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DeclaredCustomsValueAmount
     * @var \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DeclaredForCarriageValueAmount
     * @var \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DeclaredStatisticsValueAmount
     * @var \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:FreeOnBoardValueAmount
     * @var \TurkkepEFatura\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:SpecialInstructions
     * @var \TurkkepEFatura\StructType\SpecialInstructionsType[]
     */
    public $SpecialInstructions;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The ShipmentStage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ShipmentStageType[]
     */
    public $ShipmentStage;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DeliveryType
     */
    public $Delivery;
    /**
     * The TransportHandlingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TransportHandlingUnitType[]
     */
    public $TransportHandlingUnit;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AddressType
     */
    public $ReturnAddress;
    /**
     * The FirstArrivalPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LocationType
     */
    public $FirstArrivalPortLocation;
    /**
     * The LastExitPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LocationType
     */
    public $LastExitPortLocation;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setID()
     * @uses ShipmentType::setHandlingCode()
     * @uses ShipmentType::setHandlingInstructions()
     * @uses ShipmentType::setGrossWeightMeasure()
     * @uses ShipmentType::setNetWeightMeasure()
     * @uses ShipmentType::setGrossVolumeMeasure()
     * @uses ShipmentType::setNetVolumeMeasure()
     * @uses ShipmentType::setTotalGoodsItemQuantity()
     * @uses ShipmentType::setTotalTransportHandlingUnitQuantity()
     * @uses ShipmentType::setInsuranceValueAmount()
     * @uses ShipmentType::setDeclaredCustomsValueAmount()
     * @uses ShipmentType::setDeclaredForCarriageValueAmount()
     * @uses ShipmentType::setDeclaredStatisticsValueAmount()
     * @uses ShipmentType::setFreeOnBoardValueAmount()
     * @uses ShipmentType::setSpecialInstructions()
     * @uses ShipmentType::setGoodsItem()
     * @uses ShipmentType::setShipmentStage()
     * @uses ShipmentType::setDelivery()
     * @uses ShipmentType::setTransportHandlingUnit()
     * @uses ShipmentType::setReturnAddress()
     * @uses ShipmentType::setFirstArrivalPortLocation()
     * @uses ShipmentType::setLastExitPortLocation()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\HandlingCodeType $handlingCode
     * @param \TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions
     * @param \TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \TurkkepEFatura\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @param \TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \TurkkepEFatura\StructType\SpecialInstructionsType[] $specialInstructions
     * @param \TurkkepEFatura\StructType\GoodsItemType[] $goodsItem
     * @param \TurkkepEFatura\StructType\ShipmentStageType[] $shipmentStage
     * @param \TurkkepEFatura\StructType\DeliveryType $delivery
     * @param \TurkkepEFatura\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @param \TurkkepEFatura\StructType\AddressType $returnAddress
     * @param \TurkkepEFatura\StructType\LocationType $firstArrivalPortLocation
     * @param \TurkkepEFatura\StructType\LocationType $lastExitPortLocation
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\HandlingCodeType $handlingCode = null, \TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions = null, \TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure = null, \TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \TurkkepEFatura\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null, \TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, array $specialInstructions = array(), array $goodsItem = array(), array $shipmentStage = array(), \TurkkepEFatura\StructType\DeliveryType $delivery = null, array $transportHandlingUnit = array(), \TurkkepEFatura\StructType\AddressType $returnAddress = null, \TurkkepEFatura\StructType\LocationType $firstArrivalPortLocation = null, \TurkkepEFatura\StructType\LocationType $lastExitPortLocation = null)
    {
        $this
            ->setID($iD)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setGoodsItem($goodsItem)
            ->setShipmentStage($shipmentStage)
            ->setDelivery($delivery)
            ->setTransportHandlingUnit($transportHandlingUnit)
            ->setReturnAddress($returnAddress)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setLastExitPortLocation($lastExitPortLocation);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \TurkkepEFatura\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \TurkkepEFatura\StructType\HandlingCodeType $handlingCode
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setHandlingCode(\TurkkepEFatura\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \TurkkepEFatura\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setHandlingInstructions(\TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \TurkkepEFatura\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setGrossWeightMeasure(\TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \TurkkepEFatura\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setNetWeightMeasure(\TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \TurkkepEFatura\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setGrossVolumeMeasure(\TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \TurkkepEFatura\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setNetVolumeMeasure(\TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \TurkkepEFatura\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setTotalGoodsItemQuantity(\TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return \TurkkepEFatura\StructType\TotalTransportHandlingUnitQuantityType|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }
    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param \TurkkepEFatura\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setTotalTransportHandlingUnitQuantity(\TurkkepEFatura\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null)
    {
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \TurkkepEFatura\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setInsuranceValueAmount(\TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setDeclaredCustomsValueAmount(\TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setDeclaredForCarriageValueAmount(\TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setDeclaredStatisticsValueAmount(\TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \TurkkepEFatura\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setFreeOnBoardValueAmount(\TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return \TurkkepEFatura\StructType\SpecialInstructionsType[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeSpecialInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeSpecialInstructionsItem instanceof \TurkkepEFatura\StructType\SpecialInstructionsType) {
                $invalidValues[] = is_object($shipmentTypeSpecialInstructionsItem) ? get_class($shipmentTypeSpecialInstructionsItem) : sprintf('%s(%s)', gettype($shipmentTypeSpecialInstructionsItem), var_export($shipmentTypeSpecialInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialInstructions property can only contain items of type \TurkkepEFatura\StructType\SpecialInstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\SpecialInstructionsType[] $specialInstructions
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionsArrayErrorMessage = self::validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions($specialInstructions))) {
            throw new \InvalidArgumentException($specialInstructionsArrayErrorMessage, __LINE__);
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\SpecialInstructionsType $item
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function addToSpecialInstructions(\TurkkepEFatura\StructType\SpecialInstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\SpecialInstructionsType) {
            throw new \InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of type \TurkkepEFatura\StructType\SpecialInstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \TurkkepEFatura\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeGoodsItemItem instanceof \TurkkepEFatura\StructType\GoodsItemType) {
                $invalidValues[] = is_object($shipmentTypeGoodsItemItem) ? get_class($shipmentTypeGoodsItemItem) : sprintf('%s(%s)', gettype($shipmentTypeGoodsItemItem), var_export($shipmentTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \TurkkepEFatura\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\GoodsItemType[] $goodsItem
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\GoodsItemType $item
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function addToGoodsItem(\TurkkepEFatura\StructType\GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\GoodsItemType) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \TurkkepEFatura\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get ShipmentStage value
     * @return \TurkkepEFatura\StructType\ShipmentStageType[]|null
     */
    public function getShipmentStage()
    {
        return $this->ShipmentStage;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentStage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentStage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentStageForArrayConstraintsFromSetShipmentStage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentStageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentStageItem instanceof \TurkkepEFatura\StructType\ShipmentStageType) {
                $invalidValues[] = is_object($shipmentTypeShipmentStageItem) ? get_class($shipmentTypeShipmentStageItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentStageItem), var_export($shipmentTypeShipmentStageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentStage property can only contain items of type \TurkkepEFatura\StructType\ShipmentStageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ShipmentStageType[] $shipmentStage
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setShipmentStage(array $shipmentStage = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentStageArrayErrorMessage = self::validateShipmentStageForArrayConstraintsFromSetShipmentStage($shipmentStage))) {
            throw new \InvalidArgumentException($shipmentStageArrayErrorMessage, __LINE__);
        }
        $this->ShipmentStage = $shipmentStage;
        return $this;
    }
    /**
     * Add item to ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ShipmentStageType $item
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function addToShipmentStage(\TurkkepEFatura\StructType\ShipmentStageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ShipmentStageType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentStage property can only contain items of type \TurkkepEFatura\StructType\ShipmentStageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentStage[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \TurkkepEFatura\StructType\DeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \TurkkepEFatura\StructType\DeliveryType $delivery
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setDelivery(\TurkkepEFatura\StructType\DeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get TransportHandlingUnit value
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType[]|null
     */
    public function getTransportHandlingUnit()
    {
        return $this->TransportHandlingUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportHandlingUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportHandlingUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeTransportHandlingUnitItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeTransportHandlingUnitItem instanceof \TurkkepEFatura\StructType\TransportHandlingUnitType) {
                $invalidValues[] = is_object($shipmentTypeTransportHandlingUnitItem) ? get_class($shipmentTypeTransportHandlingUnitItem) : sprintf('%s(%s)', gettype($shipmentTypeTransportHandlingUnitItem), var_export($shipmentTypeTransportHandlingUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportHandlingUnit property can only contain items of type \TurkkepEFatura\StructType\TransportHandlingUnitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setTransportHandlingUnit(array $transportHandlingUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($transportHandlingUnitArrayErrorMessage = self::validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit($transportHandlingUnit))) {
            throw new \InvalidArgumentException($transportHandlingUnitArrayErrorMessage, __LINE__);
        }
        $this->TransportHandlingUnit = $transportHandlingUnit;
        return $this;
    }
    /**
     * Add item to TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TransportHandlingUnitType $item
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function addToTransportHandlingUnit(\TurkkepEFatura\StructType\TransportHandlingUnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TransportHandlingUnitType) {
            throw new \InvalidArgumentException(sprintf('The TransportHandlingUnit property can only contain items of type \TurkkepEFatura\StructType\TransportHandlingUnitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportHandlingUnit[] = $item;
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \TurkkepEFatura\StructType\AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \TurkkepEFatura\StructType\AddressType $returnAddress
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setReturnAddress(\TurkkepEFatura\StructType\AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get FirstArrivalPortLocation value
     * @return \TurkkepEFatura\StructType\LocationType|null
     */
    public function getFirstArrivalPortLocation()
    {
        return $this->FirstArrivalPortLocation;
    }
    /**
     * Set FirstArrivalPortLocation value
     * @param \TurkkepEFatura\StructType\LocationType $firstArrivalPortLocation
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setFirstArrivalPortLocation(\TurkkepEFatura\StructType\LocationType $firstArrivalPortLocation = null)
    {
        $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        return $this;
    }
    /**
     * Get LastExitPortLocation value
     * @return \TurkkepEFatura\StructType\LocationType|null
     */
    public function getLastExitPortLocation()
    {
        return $this->LastExitPortLocation;
    }
    /**
     * Set LastExitPortLocation value
     * @param \TurkkepEFatura\StructType\LocationType $lastExitPortLocation
     * @return \TurkkepEFatura\StructType\ShipmentType
     */
    public function setLastExitPortLocation(\TurkkepEFatura\StructType\LocationType $lastExitPortLocation = null)
    {
        $this->LastExitPortLocation = $lastExitPortLocation;
        return $this;
    }
}
