<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentStageType StructType
 * @subpackage Structs
 */
class ShipmentStageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransportModeCode
     * @var \TurkkepEFatura\StructType\TransportModeCodeType
     */
    public $TransportModeCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransportMeansTypeCode
     * @var \TurkkepEFatura\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TransitDirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransitDirectionCode
     * @var \TurkkepEFatura\StructType\TransitDirectionCodeType
     */
    public $TransitDirectionCode;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Instructions
     * @var \TurkkepEFatura\StructType\InstructionsType[]
     */
    public $Instructions;
    /**
     * The TransitPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PeriodType
     */
    public $TransitPeriod;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TransportMeansType
     */
    public $TransportMeans;
    /**
     * The DriverPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PersonType[]
     */
    public $DriverPerson;
    /**
     * Constructor method for ShipmentStageType
     * @uses ShipmentStageType::setID()
     * @uses ShipmentStageType::setTransportModeCode()
     * @uses ShipmentStageType::setTransportMeansTypeCode()
     * @uses ShipmentStageType::setTransitDirectionCode()
     * @uses ShipmentStageType::setInstructions()
     * @uses ShipmentStageType::setTransitPeriod()
     * @uses ShipmentStageType::setTransportMeans()
     * @uses ShipmentStageType::setDriverPerson()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\TransportModeCodeType $transportModeCode
     * @param \TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \TurkkepEFatura\StructType\TransitDirectionCodeType $transitDirectionCode
     * @param \TurkkepEFatura\StructType\InstructionsType[] $instructions
     * @param \TurkkepEFatura\StructType\PeriodType $transitPeriod
     * @param \TurkkepEFatura\StructType\TransportMeansType $transportMeans
     * @param \TurkkepEFatura\StructType\PersonType[] $driverPerson
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\TransportModeCodeType $transportModeCode = null, \TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \TurkkepEFatura\StructType\TransitDirectionCodeType $transitDirectionCode = null, array $instructions = array(), \TurkkepEFatura\StructType\PeriodType $transitPeriod = null, \TurkkepEFatura\StructType\TransportMeansType $transportMeans = null, array $driverPerson = array())
    {
        $this
            ->setID($iD)
            ->setTransportModeCode($transportModeCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTransitDirectionCode($transitDirectionCode)
            ->setInstructions($instructions)
            ->setTransitPeriod($transitPeriod)
            ->setTransportMeans($transportMeans)
            ->setDriverPerson($driverPerson);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportModeCode value
     * @return \TurkkepEFatura\StructType\TransportModeCodeType|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }
    /**
     * Set TransportModeCode value
     * @param \TurkkepEFatura\StructType\TransportModeCodeType $transportModeCode
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setTransportModeCode(\TurkkepEFatura\StructType\TransportModeCodeType $transportModeCode = null)
    {
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \TurkkepEFatura\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setTransportMeansTypeCode(\TurkkepEFatura\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TransitDirectionCode value
     * @return \TurkkepEFatura\StructType\TransitDirectionCodeType|null
     */
    public function getTransitDirectionCode()
    {
        return $this->TransitDirectionCode;
    }
    /**
     * Set TransitDirectionCode value
     * @param \TurkkepEFatura\StructType\TransitDirectionCodeType $transitDirectionCode
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setTransitDirectionCode(\TurkkepEFatura\StructType\TransitDirectionCodeType $transitDirectionCode = null)
    {
        $this->TransitDirectionCode = $transitDirectionCode;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \TurkkepEFatura\StructType\InstructionsType[]|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * This method is responsible for validating the values passed to the setInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionsForArrayConstraintsFromSetInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeInstructionsItem instanceof \TurkkepEFatura\StructType\InstructionsType) {
                $invalidValues[] = is_object($shipmentStageTypeInstructionsItem) ? get_class($shipmentStageTypeInstructionsItem) : sprintf('%s(%s)', gettype($shipmentStageTypeInstructionsItem), var_export($shipmentStageTypeInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instructions property can only contain items of type \TurkkepEFatura\StructType\InstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Instructions value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\InstructionsType[] $instructions
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setInstructions(array $instructions = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionsArrayErrorMessage = self::validateInstructionsForArrayConstraintsFromSetInstructions($instructions))) {
            throw new \InvalidArgumentException($instructionsArrayErrorMessage, __LINE__);
        }
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Add item to Instructions value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\InstructionsType $item
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function addToInstructions(\TurkkepEFatura\StructType\InstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\InstructionsType) {
            throw new \InvalidArgumentException(sprintf('The Instructions property can only contain items of type \TurkkepEFatura\StructType\InstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instructions[] = $item;
        return $this;
    }
    /**
     * Get TransitPeriod value
     * @return \TurkkepEFatura\StructType\PeriodType|null
     */
    public function getTransitPeriod()
    {
        return $this->TransitPeriod;
    }
    /**
     * Set TransitPeriod value
     * @param \TurkkepEFatura\StructType\PeriodType $transitPeriod
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setTransitPeriod(\TurkkepEFatura\StructType\PeriodType $transitPeriod = null)
    {
        $this->TransitPeriod = $transitPeriod;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \TurkkepEFatura\StructType\TransportMeansType|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \TurkkepEFatura\StructType\TransportMeansType $transportMeans
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setTransportMeans(\TurkkepEFatura\StructType\TransportMeansType $transportMeans = null)
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Get DriverPerson value
     * @return \TurkkepEFatura\StructType\PersonType[]|null
     */
    public function getDriverPerson()
    {
        return $this->DriverPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverPersonForArrayConstraintsFromSetDriverPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeDriverPersonItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeDriverPersonItem instanceof \TurkkepEFatura\StructType\PersonType) {
                $invalidValues[] = is_object($shipmentStageTypeDriverPersonItem) ? get_class($shipmentStageTypeDriverPersonItem) : sprintf('%s(%s)', gettype($shipmentStageTypeDriverPersonItem), var_export($shipmentStageTypeDriverPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverPerson property can only contain items of type \TurkkepEFatura\StructType\PersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverPerson value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PersonType[] $driverPerson
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function setDriverPerson(array $driverPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($driverPersonArrayErrorMessage = self::validateDriverPersonForArrayConstraintsFromSetDriverPerson($driverPerson))) {
            throw new \InvalidArgumentException($driverPersonArrayErrorMessage, __LINE__);
        }
        $this->DriverPerson = $driverPerson;
        return $this;
    }
    /**
     * Add item to DriverPerson value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PersonType $item
     * @return \TurkkepEFatura\StructType\ShipmentStageType
     */
    public function addToDriverPerson(\TurkkepEFatura\StructType\PersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PersonType) {
            throw new \InvalidArgumentException(sprintf('The DriverPerson property can only contain items of type \TurkkepEFatura\StructType\PersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DriverPerson[] = $item;
        return $this;
    }
}
