<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceExtensionType StructType
 * @subpackage Structs
 */
class PriceExtensionType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Amount
     * @var \TurkkepEFatura\StructType\AmountType
     */
    public $Amount;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * Constructor method for PriceExtensionType
     * @uses PriceExtensionType::setAmount()
     * @uses PriceExtensionType::setTaxTotal()
     * @param \TurkkepEFatura\StructType\AmountType $amount
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $taxTotal
     */
    public function __construct(\TurkkepEFatura\StructType\AmountType $amount = null, array $taxTotal = array())
    {
        $this
            ->setAmount($amount)
            ->setTaxTotal($taxTotal);
    }
    /**
     * Get Amount value
     * @return \TurkkepEFatura\StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \TurkkepEFatura\StructType\AmountType $amount
     * @return \TurkkepEFatura\StructType\PriceExtensionType
     */
    public function setAmount(\TurkkepEFatura\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \TurkkepEFatura\StructType\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTotalForArrayConstraintsFromSetTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceExtensionTypeTaxTotalItem) {
            // validation for constraint: itemType
            if (!$priceExtensionTypeTaxTotalItem instanceof \TurkkepEFatura\StructType\TaxTotalType) {
                $invalidValues[] = is_object($priceExtensionTypeTaxTotalItem) ? get_class($priceExtensionTypeTaxTotalItem) : sprintf('%s(%s)', gettype($priceExtensionTypeTaxTotalItem), var_export($priceExtensionTypeTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $taxTotal
     * @return \TurkkepEFatura\StructType\PriceExtensionType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTotalArrayErrorMessage = self::validateTaxTotalForArrayConstraintsFromSetTaxTotal($taxTotal))) {
            throw new \InvalidArgumentException($taxTotalArrayErrorMessage, __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType $item
     * @return \TurkkepEFatura\StructType\PriceExtensionType
     */
    public function addToTaxTotal(\TurkkepEFatura\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The TaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTotal[] = $item;
        return $this;
    }
}
