<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passenger StructType
 * @subpackage Structs
 */
class Passenger extends AbstractStructBase
{
    /**
     * The PassportDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PassportDate;
    /**
     * The FinancialAccountCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FinancialAccountCurrency;
    /**
     * The PassportNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassportNumber;
    /**
     * The FinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FinancialAccount;
    /**
     * The FinancialAccountDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FinancialAccountDescription;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The PassportCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassportCountry;
    /**
     * Constructor method for Passenger
     * @uses Passenger::setPassportDate()
     * @uses Passenger::setFinancialAccountCurrency()
     * @uses Passenger::setPassportNumber()
     * @uses Passenger::setFinancialAccount()
     * @uses Passenger::setFinancialAccountDescription()
     * @uses Passenger::setBranchName()
     * @uses Passenger::setBankName()
     * @uses Passenger::setPassportCountry()
     * @param string $passportDate
     * @param string $financialAccountCurrency
     * @param string $passportNumber
     * @param string $financialAccount
     * @param string $financialAccountDescription
     * @param string $branchName
     * @param string $bankName
     * @param string $passportCountry
     */
    public function __construct($passportDate = null, $financialAccountCurrency = null, $passportNumber = null, $financialAccount = null, $financialAccountDescription = null, $branchName = null, $bankName = null, $passportCountry = null)
    {
        $this
            ->setPassportDate($passportDate)
            ->setFinancialAccountCurrency($financialAccountCurrency)
            ->setPassportNumber($passportNumber)
            ->setFinancialAccount($financialAccount)
            ->setFinancialAccountDescription($financialAccountDescription)
            ->setBranchName($branchName)
            ->setBankName($bankName)
            ->setPassportCountry($passportCountry);
    }
    /**
     * Get PassportDate value
     * @return string
     */
    public function getPassportDate()
    {
        return $this->PassportDate;
    }
    /**
     * Set PassportDate value
     * @param string $passportDate
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setPassportDate($passportDate = null)
    {
        // validation for constraint: string
        if (!is_null($passportDate) && !is_string($passportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportDate, true), gettype($passportDate)), __LINE__);
        }
        $this->PassportDate = $passportDate;
        return $this;
    }
    /**
     * Get FinancialAccountCurrency value
     * @return string
     */
    public function getFinancialAccountCurrency()
    {
        return $this->FinancialAccountCurrency;
    }
    /**
     * Set FinancialAccountCurrency value
     * @uses \TurkkepEFatura\EnumType\CurrencyType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $financialAccountCurrency
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setFinancialAccountCurrency($financialAccountCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\CurrencyType::valueIsValid($financialAccountCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\CurrencyType', is_array($financialAccountCurrency) ? implode(', ', $financialAccountCurrency) : var_export($financialAccountCurrency, true), implode(', ', \TurkkepEFatura\EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->FinancialAccountCurrency = $financialAccountCurrency;
        return $this;
    }
    /**
     * Get PassportNumber value
     * @return string|null
     */
    public function getPassportNumber()
    {
        return $this->PassportNumber;
    }
    /**
     * Set PassportNumber value
     * @param string $passportNumber
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportNumber, true), gettype($passportNumber)), __LINE__);
        }
        $this->PassportNumber = $passportNumber;
        return $this;
    }
    /**
     * Get FinancialAccount value
     * @return string|null
     */
    public function getFinancialAccount()
    {
        return $this->FinancialAccount;
    }
    /**
     * Set FinancialAccount value
     * @param string $financialAccount
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setFinancialAccount($financialAccount = null)
    {
        // validation for constraint: string
        if (!is_null($financialAccount) && !is_string($financialAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialAccount, true), gettype($financialAccount)), __LINE__);
        }
        $this->FinancialAccount = $financialAccount;
        return $this;
    }
    /**
     * Get FinancialAccountDescription value
     * @return string|null
     */
    public function getFinancialAccountDescription()
    {
        return $this->FinancialAccountDescription;
    }
    /**
     * Set FinancialAccountDescription value
     * @param string $financialAccountDescription
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setFinancialAccountDescription($financialAccountDescription = null)
    {
        // validation for constraint: string
        if (!is_null($financialAccountDescription) && !is_string($financialAccountDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialAccountDescription, true), gettype($financialAccountDescription)), __LINE__);
        }
        $this->FinancialAccountDescription = $financialAccountDescription;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get PassportCountry value
     * @return string|null
     */
    public function getPassportCountry()
    {
        return $this->PassportCountry;
    }
    /**
     * Set PassportCountry value
     * @param string $passportCountry
     * @return \TurkkepEFatura\StructType\Passenger
     */
    public function setPassportCountry($passportCountry = null)
    {
        // validation for constraint: string
        if (!is_null($passportCountry) && !is_string($passportCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportCountry, true), gettype($passportCountry)), __LINE__);
        }
        $this->PassportCountry = $passportCountry;
        return $this;
    }
}
