<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OkcReceipt StructType
 * @subpackage Structs
 */
class OkcReceipt extends AbstractStructBase
{
    /**
     * The ReceiptDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReceiptDate;
    /**
     * The ReceiptType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReceiptType;
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptNumber;
    /**
     * The ZReportNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZReportNumber;
    /**
     * The OkcSerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OkcSerialNumber;
    /**
     * Constructor method for OkcReceipt
     * @uses OkcReceipt::setReceiptDate()
     * @uses OkcReceipt::setReceiptType()
     * @uses OkcReceipt::setReceiptNumber()
     * @uses OkcReceipt::setZReportNumber()
     * @uses OkcReceipt::setOkcSerialNumber()
     * @param string $receiptDate
     * @param string $receiptType
     * @param string $receiptNumber
     * @param string $zReportNumber
     * @param string $okcSerialNumber
     */
    public function __construct($receiptDate = null, $receiptType = null, $receiptNumber = null, $zReportNumber = null, $okcSerialNumber = null)
    {
        $this
            ->setReceiptDate($receiptDate)
            ->setReceiptType($receiptType)
            ->setReceiptNumber($receiptNumber)
            ->setZReportNumber($zReportNumber)
            ->setOkcSerialNumber($okcSerialNumber);
    }
    /**
     * Get ReceiptDate value
     * @return string
     */
    public function getReceiptDate()
    {
        return $this->ReceiptDate;
    }
    /**
     * Set ReceiptDate value
     * @param string $receiptDate
     * @return \TurkkepEFatura\StructType\OkcReceipt
     */
    public function setReceiptDate($receiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($receiptDate) && !is_string($receiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptDate, true), gettype($receiptDate)), __LINE__);
        }
        $this->ReceiptDate = $receiptDate;
        return $this;
    }
    /**
     * Get ReceiptType value
     * @return string
     */
    public function getReceiptType()
    {
        return $this->ReceiptType;
    }
    /**
     * Set ReceiptType value
     * @uses \TurkkepEFatura\EnumType\ReceiptType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\ReceiptType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $receiptType
     * @return \TurkkepEFatura\StructType\OkcReceipt
     */
    public function setReceiptType($receiptType = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\ReceiptType::valueIsValid($receiptType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\ReceiptType', is_array($receiptType) ? implode(', ', $receiptType) : var_export($receiptType, true), implode(', ', \TurkkepEFatura\EnumType\ReceiptType::getValidValues())), __LINE__);
        }
        $this->ReceiptType = $receiptType;
        return $this;
    }
    /**
     * Get ReceiptNumber value
     * @return string|null
     */
    public function getReceiptNumber()
    {
        return $this->ReceiptNumber;
    }
    /**
     * Set ReceiptNumber value
     * @param string $receiptNumber
     * @return \TurkkepEFatura\StructType\OkcReceipt
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNumber) && !is_string($receiptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        $this->ReceiptNumber = $receiptNumber;
        return $this;
    }
    /**
     * Get ZReportNumber value
     * @return string|null
     */
    public function getZReportNumber()
    {
        return $this->ZReportNumber;
    }
    /**
     * Set ZReportNumber value
     * @param string $zReportNumber
     * @return \TurkkepEFatura\StructType\OkcReceipt
     */
    public function setZReportNumber($zReportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($zReportNumber) && !is_string($zReportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zReportNumber, true), gettype($zReportNumber)), __LINE__);
        }
        $this->ZReportNumber = $zReportNumber;
        return $this;
    }
    /**
     * Get OkcSerialNumber value
     * @return string|null
     */
    public function getOkcSerialNumber()
    {
        return $this->OkcSerialNumber;
    }
    /**
     * Set OkcSerialNumber value
     * @param string $okcSerialNumber
     * @return \TurkkepEFatura\StructType\OkcReceipt
     */
    public function setOkcSerialNumber($okcSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($okcSerialNumber) && !is_string($okcSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okcSerialNumber, true), gettype($okcSerialNumber)), __LINE__);
        }
        $this->OkcSerialNumber = $okcSerialNumber;
        return $this;
    }
}
