<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KontorList StructType
 * @subpackage Structs
 */
class KontorList extends AbstractStructBase
{
    /**
     * The TotalCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalCredit;
    /**
     * The UsedCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsedCredit;
    /**
     * The RemainingCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RemainingCredit;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The VknTckn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VknTckn;
    /**
     * The deliveryType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deliveryType;
    /**
     * Constructor method for KontorList
     * @uses KontorList::setTotalCredit()
     * @uses KontorList::setUsedCredit()
     * @uses KontorList::setRemainingCredit()
     * @uses KontorList::setCustomerName()
     * @uses KontorList::setVknTckn()
     * @uses KontorList::setDeliveryType()
     * @param int $totalCredit
     * @param int $usedCredit
     * @param int $remainingCredit
     * @param string $customerName
     * @param string $vknTckn
     * @param string $deliveryType
     */
    public function __construct($totalCredit = null, $usedCredit = null, $remainingCredit = null, $customerName = null, $vknTckn = null, $deliveryType = null)
    {
        $this
            ->setTotalCredit($totalCredit)
            ->setUsedCredit($usedCredit)
            ->setRemainingCredit($remainingCredit)
            ->setCustomerName($customerName)
            ->setVknTckn($vknTckn)
            ->setDeliveryType($deliveryType);
    }
    /**
     * Get TotalCredit value
     * @return int
     */
    public function getTotalCredit()
    {
        return $this->TotalCredit;
    }
    /**
     * Set TotalCredit value
     * @param int $totalCredit
     * @return \TurkkepEFatura\StructType\KontorList
     */
    public function setTotalCredit($totalCredit = null)
    {
        // validation for constraint: int
        if (!is_null($totalCredit) && !(is_int($totalCredit) || ctype_digit($totalCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCredit, true), gettype($totalCredit)), __LINE__);
        }
        $this->TotalCredit = $totalCredit;
        return $this;
    }
    /**
     * Get UsedCredit value
     * @return int
     */
    public function getUsedCredit()
    {
        return $this->UsedCredit;
    }
    /**
     * Set UsedCredit value
     * @param int $usedCredit
     * @return \TurkkepEFatura\StructType\KontorList
     */
    public function setUsedCredit($usedCredit = null)
    {
        // validation for constraint: int
        if (!is_null($usedCredit) && !(is_int($usedCredit) || ctype_digit($usedCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usedCredit, true), gettype($usedCredit)), __LINE__);
        }
        $this->UsedCredit = $usedCredit;
        return $this;
    }
    /**
     * Get RemainingCredit value
     * @return int
     */
    public function getRemainingCredit()
    {
        return $this->RemainingCredit;
    }
    /**
     * Set RemainingCredit value
     * @param int $remainingCredit
     * @return \TurkkepEFatura\StructType\KontorList
     */
    public function setRemainingCredit($remainingCredit = null)
    {
        // validation for constraint: int
        if (!is_null($remainingCredit) && !(is_int($remainingCredit) || ctype_digit($remainingCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainingCredit, true), gettype($remainingCredit)), __LINE__);
        }
        $this->RemainingCredit = $remainingCredit;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \TurkkepEFatura\StructType\KontorList
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get VknTckn value
     * @return string|null
     */
    public function getVknTckn()
    {
        return $this->VknTckn;
    }
    /**
     * Set VknTckn value
     * @param string $vknTckn
     * @return \TurkkepEFatura\StructType\KontorList
     */
    public function setVknTckn($vknTckn = null)
    {
        // validation for constraint: string
        if (!is_null($vknTckn) && !is_string($vknTckn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vknTckn, true), gettype($vknTckn)), __LINE__);
        }
        $this->VknTckn = $vknTckn;
        return $this;
    }
    /**
     * Get deliveryType value
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->deliveryType;
    }
    /**
     * Set deliveryType value
     * @param string $deliveryType
     * @return \TurkkepEFatura\StructType\KontorList
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryType) && !is_string($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryType, true), gettype($deliveryType)), __LINE__);
        }
        $this->deliveryType = $deliveryType;
        return $this;
    }
}
