<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLine StructType
 * @subpackage Structs
 */
class InvoiceLine extends AbstractStructBase
{
    /**
     * The LineOrderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineOrderNo;
    /**
     * The QuantityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \TurkkepEFatura\StructType\QuantityType|string
     */
    public $QuantityType;
    /**
     * The InvoicedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoicedQuantity;
    /**
     * The AllowanceChagreMultiplierFactor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceChagreMultiplierFactor;
    /**
     * The AllowanceChargeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceChargeAmount;
    /**
     * The ItemPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ItemPrice;
    /**
     * The ItemCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ItemCurrency;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The AllowanceChargeIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllowanceChargeIndicator;
    /**
     * The AllowanceChargeReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllowanceChargeReason;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemBrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemBrandName;
    /**
     * The ItemModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemModelName;
    /**
     * The BuyersItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuyersItemId;
    /**
     * The SellersItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellersItemId;
    /**
     * The ManufacturersItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturersItemId;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommodityClassification;
    /**
     * The TaxSubtotals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal
     */
    public $TaxSubtotals;
    /**
     * The WitholdingTaxSubtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxSubtotal
     */
    public $WitholdingTaxSubtotal;
    /**
     * The ExportLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ExportLine
     */
    public $ExportLine;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginCountry;
    /**
     * Constructor method for InvoiceLine
     * @uses InvoiceLine::setLineOrderNo()
     * @uses InvoiceLine::setQuantityType()
     * @uses InvoiceLine::setInvoicedQuantity()
     * @uses InvoiceLine::setAllowanceChagreMultiplierFactor()
     * @uses InvoiceLine::setAllowanceChargeAmount()
     * @uses InvoiceLine::setItemPrice()
     * @uses InvoiceLine::setItemCurrency()
     * @uses InvoiceLine::setNote()
     * @uses InvoiceLine::setAllowanceChargeIndicator()
     * @uses InvoiceLine::setAllowanceChargeReason()
     * @uses InvoiceLine::setItemName()
     * @uses InvoiceLine::setItemDescription()
     * @uses InvoiceLine::setItemBrandName()
     * @uses InvoiceLine::setItemModelName()
     * @uses InvoiceLine::setBuyersItemId()
     * @uses InvoiceLine::setSellersItemId()
     * @uses InvoiceLine::setManufacturersItemId()
     * @uses InvoiceLine::setCommodityClassification()
     * @uses InvoiceLine::setTaxSubtotals()
     * @uses InvoiceLine::setWitholdingTaxSubtotal()
     * @uses InvoiceLine::setExportLine()
     * @uses InvoiceLine::setOriginCountry()
     * @param int $lineOrderNo
     * @param \TurkkepEFatura\StructType\QuantityType $quantityType
     * @param float $invoicedQuantity
     * @param float $allowanceChagreMultiplierFactor
     * @param float $allowanceChargeAmount
     * @param float $itemPrice
     * @param string $itemCurrency
     * @param string $note
     * @param string $allowanceChargeIndicator
     * @param string $allowanceChargeReason
     * @param string $itemName
     * @param string $itemDescription
     * @param string $itemBrandName
     * @param string $itemModelName
     * @param string $buyersItemId
     * @param string $sellersItemId
     * @param string $manufacturersItemId
     * @param string $commodityClassification
     * @param \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals
     * @param \TurkkepEFatura\StructType\TaxSubtotal $witholdingTaxSubtotal
     * @param \TurkkepEFatura\StructType\ExportLine $exportLine
     * @param string $originCountry
     */
    public function __construct($lineOrderNo = null, \TurkkepEFatura\StructType\QuantityType $quantityType = null, $invoicedQuantity = null, $allowanceChagreMultiplierFactor = null, $allowanceChargeAmount = null, $itemPrice = null, $itemCurrency = null, $note = null, $allowanceChargeIndicator = null, $allowanceChargeReason = null, $itemName = null, $itemDescription = null, $itemBrandName = null, $itemModelName = null, $buyersItemId = null, $sellersItemId = null, $manufacturersItemId = null, $commodityClassification = null, \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals = null, \TurkkepEFatura\StructType\TaxSubtotal $witholdingTaxSubtotal = null, \TurkkepEFatura\StructType\ExportLine $exportLine = null, $originCountry = null)
    {
        $this
            ->setLineOrderNo($lineOrderNo)
            ->setQuantityType($quantityType)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setAllowanceChagreMultiplierFactor($allowanceChagreMultiplierFactor)
            ->setAllowanceChargeAmount($allowanceChargeAmount)
            ->setItemPrice($itemPrice)
            ->setItemCurrency($itemCurrency)
            ->setNote($note)
            ->setAllowanceChargeIndicator($allowanceChargeIndicator)
            ->setAllowanceChargeReason($allowanceChargeReason)
            ->setItemName($itemName)
            ->setItemDescription($itemDescription)
            ->setItemBrandName($itemBrandName)
            ->setItemModelName($itemModelName)
            ->setBuyersItemId($buyersItemId)
            ->setSellersItemId($sellersItemId)
            ->setManufacturersItemId($manufacturersItemId)
            ->setCommodityClassification($commodityClassification)
            ->setTaxSubtotals($taxSubtotals)
            ->setWitholdingTaxSubtotal($witholdingTaxSubtotal)
            ->setExportLine($exportLine)
            ->setOriginCountry($originCountry);
    }
    /**
     * Get LineOrderNo value
     * @return int
     */
    public function getLineOrderNo()
    {
        return $this->LineOrderNo;
    }
    /**
     * Set LineOrderNo value
     * @param int $lineOrderNo
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setLineOrderNo($lineOrderNo = null)
    {
        // validation for constraint: int
        if (!is_null($lineOrderNo) && !(is_int($lineOrderNo) || ctype_digit($lineOrderNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineOrderNo, true), gettype($lineOrderNo)), __LINE__);
        }
        $this->LineOrderNo = $lineOrderNo;
        return $this;
    }
    /**
     * Get QuantityType value
     * @return \TurkkepEFatura\StructType\QuantityType
     */
    public function getQuantityType()
    {
        return $this->QuantityType;
    }
    /**
     * Set QuantityType value
     * @param \TurkkepEFatura\StructType\QuantityType $quantityType
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setQuantityType(\TurkkepEFatura\StructType\QuantityType $quantityType = null)
    {
        $this->QuantityType = $quantityType;
        return $this;
    }
    /**
     * Get InvoicedQuantity value
     * @return float
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }
    /**
     * Set InvoicedQuantity value
     * @param float $invoicedQuantity
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setInvoicedQuantity($invoicedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($invoicedQuantity) && !(is_float($invoicedQuantity) || is_numeric($invoicedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoicedQuantity, true), gettype($invoicedQuantity)), __LINE__);
        }
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get AllowanceChagreMultiplierFactor value
     * @return float
     */
    public function getAllowanceChagreMultiplierFactor()
    {
        return $this->AllowanceChagreMultiplierFactor;
    }
    /**
     * Set AllowanceChagreMultiplierFactor value
     * @param float $allowanceChagreMultiplierFactor
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setAllowanceChagreMultiplierFactor($allowanceChagreMultiplierFactor = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceChagreMultiplierFactor) && !(is_float($allowanceChagreMultiplierFactor) || is_numeric($allowanceChagreMultiplierFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceChagreMultiplierFactor, true), gettype($allowanceChagreMultiplierFactor)), __LINE__);
        }
        $this->AllowanceChagreMultiplierFactor = $allowanceChagreMultiplierFactor;
        return $this;
    }
    /**
     * Get AllowanceChargeAmount value
     * @return float
     */
    public function getAllowanceChargeAmount()
    {
        return $this->AllowanceChargeAmount;
    }
    /**
     * Set AllowanceChargeAmount value
     * @param float $allowanceChargeAmount
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setAllowanceChargeAmount($allowanceChargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceChargeAmount) && !(is_float($allowanceChargeAmount) || is_numeric($allowanceChargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceChargeAmount, true), gettype($allowanceChargeAmount)), __LINE__);
        }
        $this->AllowanceChargeAmount = $allowanceChargeAmount;
        return $this;
    }
    /**
     * Get ItemPrice value
     * @return float
     */
    public function getItemPrice()
    {
        return $this->ItemPrice;
    }
    /**
     * Set ItemPrice value
     * @param float $itemPrice
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setItemPrice($itemPrice = null)
    {
        // validation for constraint: float
        if (!is_null($itemPrice) && !(is_float($itemPrice) || is_numeric($itemPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemPrice, true), gettype($itemPrice)), __LINE__);
        }
        $this->ItemPrice = $itemPrice;
        return $this;
    }
    /**
     * Get ItemCurrency value
     * @return string
     */
    public function getItemCurrency()
    {
        return $this->ItemCurrency;
    }
    /**
     * Set ItemCurrency value
     * @uses \TurkkepEFatura\EnumType\CurrencyType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemCurrency
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setItemCurrency($itemCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\CurrencyType::valueIsValid($itemCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\CurrencyType', is_array($itemCurrency) ? implode(', ', $itemCurrency) : var_export($itemCurrency, true), implode(', ', \TurkkepEFatura\EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->ItemCurrency = $itemCurrency;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get AllowanceChargeIndicator value
     * @return string|null
     */
    public function getAllowanceChargeIndicator()
    {
        return $this->AllowanceChargeIndicator;
    }
    /**
     * Set AllowanceChargeIndicator value
     * @param string $allowanceChargeIndicator
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setAllowanceChargeIndicator($allowanceChargeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($allowanceChargeIndicator) && !is_string($allowanceChargeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowanceChargeIndicator, true), gettype($allowanceChargeIndicator)), __LINE__);
        }
        $this->AllowanceChargeIndicator = $allowanceChargeIndicator;
        return $this;
    }
    /**
     * Get AllowanceChargeReason value
     * @return string|null
     */
    public function getAllowanceChargeReason()
    {
        return $this->AllowanceChargeReason;
    }
    /**
     * Set AllowanceChargeReason value
     * @param string $allowanceChargeReason
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setAllowanceChargeReason($allowanceChargeReason = null)
    {
        // validation for constraint: string
        if (!is_null($allowanceChargeReason) && !is_string($allowanceChargeReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowanceChargeReason, true), gettype($allowanceChargeReason)), __LINE__);
        }
        $this->AllowanceChargeReason = $allowanceChargeReason;
        return $this;
    }
    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }
    /**
     * Set ItemName value
     * @param string $itemName
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get ItemBrandName value
     * @return string|null
     */
    public function getItemBrandName()
    {
        return $this->ItemBrandName;
    }
    /**
     * Set ItemBrandName value
     * @param string $itemBrandName
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setItemBrandName($itemBrandName = null)
    {
        // validation for constraint: string
        if (!is_null($itemBrandName) && !is_string($itemBrandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemBrandName, true), gettype($itemBrandName)), __LINE__);
        }
        $this->ItemBrandName = $itemBrandName;
        return $this;
    }
    /**
     * Get ItemModelName value
     * @return string|null
     */
    public function getItemModelName()
    {
        return $this->ItemModelName;
    }
    /**
     * Set ItemModelName value
     * @param string $itemModelName
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setItemModelName($itemModelName = null)
    {
        // validation for constraint: string
        if (!is_null($itemModelName) && !is_string($itemModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemModelName, true), gettype($itemModelName)), __LINE__);
        }
        $this->ItemModelName = $itemModelName;
        return $this;
    }
    /**
     * Get BuyersItemId value
     * @return string|null
     */
    public function getBuyersItemId()
    {
        return $this->BuyersItemId;
    }
    /**
     * Set BuyersItemId value
     * @param string $buyersItemId
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setBuyersItemId($buyersItemId = null)
    {
        // validation for constraint: string
        if (!is_null($buyersItemId) && !is_string($buyersItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyersItemId, true), gettype($buyersItemId)), __LINE__);
        }
        $this->BuyersItemId = $buyersItemId;
        return $this;
    }
    /**
     * Get SellersItemId value
     * @return string|null
     */
    public function getSellersItemId()
    {
        return $this->SellersItemId;
    }
    /**
     * Set SellersItemId value
     * @param string $sellersItemId
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setSellersItemId($sellersItemId = null)
    {
        // validation for constraint: string
        if (!is_null($sellersItemId) && !is_string($sellersItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellersItemId, true), gettype($sellersItemId)), __LINE__);
        }
        $this->SellersItemId = $sellersItemId;
        return $this;
    }
    /**
     * Get ManufacturersItemId value
     * @return string|null
     */
    public function getManufacturersItemId()
    {
        return $this->ManufacturersItemId;
    }
    /**
     * Set ManufacturersItemId value
     * @param string $manufacturersItemId
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setManufacturersItemId($manufacturersItemId = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturersItemId) && !is_string($manufacturersItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturersItemId, true), gettype($manufacturersItemId)), __LINE__);
        }
        $this->ManufacturersItemId = $manufacturersItemId;
        return $this;
    }
    /**
     * Get CommodityClassification value
     * @return string|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }
    /**
     * Set CommodityClassification value
     * @param string $commodityClassification
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setCommodityClassification($commodityClassification = null)
    {
        // validation for constraint: string
        if (!is_null($commodityClassification) && !is_string($commodityClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityClassification, true), gettype($commodityClassification)), __LINE__);
        }
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }
    /**
     * Get TaxSubtotals value
     * @return \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal|null
     */
    public function getTaxSubtotals()
    {
        return $this->TaxSubtotals;
    }
    /**
     * Set TaxSubtotals value
     * @param \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setTaxSubtotals(\TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals = null)
    {
        $this->TaxSubtotals = $taxSubtotals;
        return $this;
    }
    /**
     * Get WitholdingTaxSubtotal value
     * @return \TurkkepEFatura\StructType\TaxSubtotal|null
     */
    public function getWitholdingTaxSubtotal()
    {
        return $this->WitholdingTaxSubtotal;
    }
    /**
     * Set WitholdingTaxSubtotal value
     * @param \TurkkepEFatura\StructType\TaxSubtotal $witholdingTaxSubtotal
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setWitholdingTaxSubtotal(\TurkkepEFatura\StructType\TaxSubtotal $witholdingTaxSubtotal = null)
    {
        $this->WitholdingTaxSubtotal = $witholdingTaxSubtotal;
        return $this;
    }
    /**
     * Get ExportLine value
     * @return \TurkkepEFatura\StructType\ExportLine|null
     */
    public function getExportLine()
    {
        return $this->ExportLine;
    }
    /**
     * Set ExportLine value
     * @param \TurkkepEFatura\StructType\ExportLine $exportLine
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setExportLine(\TurkkepEFatura\StructType\ExportLine $exportLine = null)
    {
        $this->ExportLine = $exportLine;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return string|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param string $originCountry
     * @return \TurkkepEFatura\StructType\InvoiceLine
     */
    public function setOriginCountry($originCountry = null)
    {
        // validation for constraint: string
        if (!is_null($originCountry) && !is_string($originCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountry, true), gettype($originCountry)), __LINE__);
        }
        $this->OriginCountry = $originCountry;
        return $this;
    }
}
