<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The SpecialTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpecialTaxTotal;
    /**
     * The SpecialTaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpecialTaxableAmount;
    /**
     * The SpecialTaxPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpecialTaxPercent;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceId;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CopyIndicator;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IssueTime;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceType;
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Profile;
    /**
     * The DocumentCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DocumentCurrency;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PricingExchangeRate;
    /**
     * The TotalTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTaxAmount;
    /**
     * The WitholdingTotalTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $WitholdingTotalTaxAmount;
    /**
     * The PeriodStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The PeriodDurationMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PeriodDurationMeasure;
    /**
     * The PeriodDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodDuration;
    /**
     * The OrderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OrderDate;
    /**
     * The ReceiptDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReceiptDate;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PenaltySurchargePercent;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PenaltyAmount;
    /**
     * The AllowanceChargeIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowanceChargeIndicator;
    /**
     * The AllowanceChargeMultiplierFactor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceChargeMultiplierFactor;
    /**
     * The TotalAllowanceChargeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAllowanceChargeAmount;
    /**
     * The AllowanceChargeBaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceChargeBaseAmount;
    /**
     * The TotalLineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalLineExtensionAmount;
    /**
     * The TotalTaxExlusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTaxExlusiveAmount;
    /**
     * The TotalTaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeTotalAmount;
    /**
     * The TotalPayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPayableRoundingAmount;
    /**
     * The TotalPayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPayableAmount;
    /**
     * The Archived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Archived;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The EnvelopeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EnvelopeDate;
    /**
     * The FiiliIhracatTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FiiliIhracatTarihi;
    /**
     * The InvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceCount;
    /**
     * The FreeExport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FreeExport;
    /**
     * The BeyannameTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BeyannameTarihi;
    /**
     * The IntacTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IntacTarihi;
    /**
     * The NotificationSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NotificationSend;
    /**
     * The NoteList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfString
     */
    public $NoteList;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfInvoiceLine
     */
    public $Lines;
    /**
     * The TaxSubtotals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal
     */
    public $TaxSubtotals;
    /**
     * The DespatchNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfDespatchNote
     */
    public $DespatchNotes;
    /**
     * The Attachments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfDocument
     */
    public $Attachments;
    /**
     * The InvoiceReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceReference;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ReceiptId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptId;
    /**
     * The CustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $CustomerParty;
    /**
     * The PaymentTermsNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTermsNote;
    /**
     * The AllowanceChargeReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllowanceChargeReason;
    /**
     * The ResponseStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseStatusCode;
    /**
     * The ResponseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseDescription;
    /**
     * The ApplicationResponseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationResponseDescription;
    /**
     * The SenderAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAlias;
    /**
     * The PostboxAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostboxAlias;
    /**
     * The XSLTName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XSLTName;
    /**
     * The ERPInvoiceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ERPInvoiceNo;
    /**
     * The ExemptionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExemptionReason;
    /**
     * The ExemptionReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExemptionReasonCode;
    /**
     * The XMLContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XMLContent;
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryType;
    /**
     * The SendMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendMethod;
    /**
     * The InternetDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\InternetDetail
     */
    public $InternetDetail;
    /**
     * The AdditionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo
     */
    public $AdditionalInfo;
    /**
     * The EnvelopeReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnvelopeReference;
    /**
     * The SupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Party
     */
    public $SupplierParty;
    /**
     * The OkcReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\OkcReceipt
     */
    public $OkcReceipt;
    /**
     * The Passenger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Passenger
     */
    public $Passenger;
    /**
     * The Representative
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Representative
     */
    public $Representative;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PaymentMeans
     */
    public $PaymentMeans;
    /**
     * The GtbReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GtbReference;
    /**
     * The GtbTescilNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GtbTescilNo;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\Shipment
     */
    public $Shipment;
    /**
     * The SgkInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\SgkInvoice
     */
    public $SgkInvoice;
    /**
     * The BeyannameNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BeyannameNo;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setSpecialTaxTotal()
     * @uses Invoice::setSpecialTaxableAmount()
     * @uses Invoice::setSpecialTaxPercent()
     * @uses Invoice::setInvoiceId()
     * @uses Invoice::setCopyIndicator()
     * @uses Invoice::setIssueDate()
     * @uses Invoice::setIssueTime()
     * @uses Invoice::setInvoiceType()
     * @uses Invoice::setProfile()
     * @uses Invoice::setDocumentCurrency()
     * @uses Invoice::setPricingExchangeRate()
     * @uses Invoice::setTotalTaxAmount()
     * @uses Invoice::setWitholdingTotalTaxAmount()
     * @uses Invoice::setPeriodStartDate()
     * @uses Invoice::setPeriodEndDate()
     * @uses Invoice::setPeriodDurationMeasure()
     * @uses Invoice::setPeriodDuration()
     * @uses Invoice::setOrderDate()
     * @uses Invoice::setReceiptDate()
     * @uses Invoice::setPenaltySurchargePercent()
     * @uses Invoice::setPenaltyAmount()
     * @uses Invoice::setAllowanceChargeIndicator()
     * @uses Invoice::setAllowanceChargeMultiplierFactor()
     * @uses Invoice::setTotalAllowanceChargeAmount()
     * @uses Invoice::setAllowanceChargeBaseAmount()
     * @uses Invoice::setTotalLineExtensionAmount()
     * @uses Invoice::setTotalTaxExlusiveAmount()
     * @uses Invoice::setTotalTaxInclusiveAmount()
     * @uses Invoice::setAllowanceTotalAmount()
     * @uses Invoice::setChargeTotalAmount()
     * @uses Invoice::setTotalPayableRoundingAmount()
     * @uses Invoice::setTotalPayableAmount()
     * @uses Invoice::setArchived()
     * @uses Invoice::setStatus()
     * @uses Invoice::setEnvelopeDate()
     * @uses Invoice::setFiiliIhracatTarihi()
     * @uses Invoice::setInvoiceCount()
     * @uses Invoice::setFreeExport()
     * @uses Invoice::setBeyannameTarihi()
     * @uses Invoice::setIntacTarihi()
     * @uses Invoice::setNotificationSend()
     * @uses Invoice::setNoteList()
     * @uses Invoice::setLines()
     * @uses Invoice::setTaxSubtotals()
     * @uses Invoice::setDespatchNotes()
     * @uses Invoice::setAttachments()
     * @uses Invoice::setInvoiceReference()
     * @uses Invoice::setUUID()
     * @uses Invoice::setOrderId()
     * @uses Invoice::setReceiptId()
     * @uses Invoice::setCustomerParty()
     * @uses Invoice::setPaymentTermsNote()
     * @uses Invoice::setAllowanceChargeReason()
     * @uses Invoice::setResponseStatusCode()
     * @uses Invoice::setResponseDescription()
     * @uses Invoice::setApplicationResponseDescription()
     * @uses Invoice::setSenderAlias()
     * @uses Invoice::setPostboxAlias()
     * @uses Invoice::setXSLTName()
     * @uses Invoice::setERPInvoiceNo()
     * @uses Invoice::setExemptionReason()
     * @uses Invoice::setExemptionReasonCode()
     * @uses Invoice::setXMLContent()
     * @uses Invoice::setDeliveryType()
     * @uses Invoice::setSendMethod()
     * @uses Invoice::setInternetDetail()
     * @uses Invoice::setAdditionalInfo()
     * @uses Invoice::setEnvelopeReference()
     * @uses Invoice::setSupplierParty()
     * @uses Invoice::setOkcReceipt()
     * @uses Invoice::setPassenger()
     * @uses Invoice::setRepresentative()
     * @uses Invoice::setPaymentMeans()
     * @uses Invoice::setGtbReference()
     * @uses Invoice::setGtbTescilNo()
     * @uses Invoice::setShipment()
     * @uses Invoice::setSgkInvoice()
     * @uses Invoice::setBeyannameNo()
     * @param float $specialTaxTotal
     * @param float $specialTaxableAmount
     * @param float $specialTaxPercent
     * @param int $invoiceId
     * @param bool $copyIndicator
     * @param string $issueDate
     * @param string $issueTime
     * @param string $invoiceType
     * @param string $profile
     * @param string $documentCurrency
     * @param float $pricingExchangeRate
     * @param float $totalTaxAmount
     * @param float $witholdingTotalTaxAmount
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param string $periodDurationMeasure
     * @param int $periodDuration
     * @param string $orderDate
     * @param string $receiptDate
     * @param float $penaltySurchargePercent
     * @param float $penaltyAmount
     * @param bool $allowanceChargeIndicator
     * @param float $allowanceChargeMultiplierFactor
     * @param float $totalAllowanceChargeAmount
     * @param float $allowanceChargeBaseAmount
     * @param float $totalLineExtensionAmount
     * @param float $totalTaxExlusiveAmount
     * @param float $totalTaxInclusiveAmount
     * @param float $allowanceTotalAmount
     * @param float $chargeTotalAmount
     * @param float $totalPayableRoundingAmount
     * @param float $totalPayableAmount
     * @param bool $archived
     * @param int $status
     * @param string $envelopeDate
     * @param string $fiiliIhracatTarihi
     * @param int $invoiceCount
     * @param bool $freeExport
     * @param string $beyannameTarihi
     * @param string $intacTarihi
     * @param bool $notificationSend
     * @param \TurkkepEFatura\ArrayType\ArrayOfString $noteList
     * @param \TurkkepEFatura\ArrayType\ArrayOfInvoiceLine $lines
     * @param \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals
     * @param \TurkkepEFatura\ArrayType\ArrayOfDespatchNote $despatchNotes
     * @param \TurkkepEFatura\ArrayType\ArrayOfDocument $attachments
     * @param string $invoiceReference
     * @param string $uUID
     * @param string $orderId
     * @param string $receiptId
     * @param \TurkkepEFatura\StructType\Party $customerParty
     * @param string $paymentTermsNote
     * @param string $allowanceChargeReason
     * @param string $responseStatusCode
     * @param string $responseDescription
     * @param string $applicationResponseDescription
     * @param string $senderAlias
     * @param string $postboxAlias
     * @param string $xSLTName
     * @param string $eRPInvoiceNo
     * @param string $exemptionReason
     * @param string $exemptionReasonCode
     * @param string $xMLContent
     * @param string $deliveryType
     * @param string $sendMethod
     * @param \TurkkepEFatura\StructType\InternetDetail $internetDetail
     * @param \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo $additionalInfo
     * @param string $envelopeReference
     * @param \TurkkepEFatura\StructType\Party $supplierParty
     * @param \TurkkepEFatura\StructType\OkcReceipt $okcReceipt
     * @param \TurkkepEFatura\StructType\Passenger $passenger
     * @param \TurkkepEFatura\StructType\Representative $representative
     * @param \TurkkepEFatura\StructType\PaymentMeans $paymentMeans
     * @param string $gtbReference
     * @param string $gtbTescilNo
     * @param \TurkkepEFatura\StructType\Shipment $shipment
     * @param \TurkkepEFatura\StructType\SgkInvoice $sgkInvoice
     * @param string $beyannameNo
     */
    public function __construct($specialTaxTotal = null, $specialTaxableAmount = null, $specialTaxPercent = null, $invoiceId = null, $copyIndicator = null, $issueDate = null, $issueTime = null, $invoiceType = null, $profile = null, $documentCurrency = null, $pricingExchangeRate = null, $totalTaxAmount = null, $witholdingTotalTaxAmount = null, $periodStartDate = null, $periodEndDate = null, $periodDurationMeasure = null, $periodDuration = null, $orderDate = null, $receiptDate = null, $penaltySurchargePercent = null, $penaltyAmount = null, $allowanceChargeIndicator = null, $allowanceChargeMultiplierFactor = null, $totalAllowanceChargeAmount = null, $allowanceChargeBaseAmount = null, $totalLineExtensionAmount = null, $totalTaxExlusiveAmount = null, $totalTaxInclusiveAmount = null, $allowanceTotalAmount = null, $chargeTotalAmount = null, $totalPayableRoundingAmount = null, $totalPayableAmount = null, $archived = null, $status = null, $envelopeDate = null, $fiiliIhracatTarihi = null, $invoiceCount = null, $freeExport = null, $beyannameTarihi = null, $intacTarihi = null, $notificationSend = null, \TurkkepEFatura\ArrayType\ArrayOfString $noteList = null, \TurkkepEFatura\ArrayType\ArrayOfInvoiceLine $lines = null, \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals = null, \TurkkepEFatura\ArrayType\ArrayOfDespatchNote $despatchNotes = null, \TurkkepEFatura\ArrayType\ArrayOfDocument $attachments = null, $invoiceReference = null, $uUID = null, $orderId = null, $receiptId = null, \TurkkepEFatura\StructType\Party $customerParty = null, $paymentTermsNote = null, $allowanceChargeReason = null, $responseStatusCode = null, $responseDescription = null, $applicationResponseDescription = null, $senderAlias = null, $postboxAlias = null, $xSLTName = null, $eRPInvoiceNo = null, $exemptionReason = null, $exemptionReasonCode = null, $xMLContent = null, $deliveryType = null, $sendMethod = null, \TurkkepEFatura\StructType\InternetDetail $internetDetail = null, \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo $additionalInfo = null, $envelopeReference = null, \TurkkepEFatura\StructType\Party $supplierParty = null, \TurkkepEFatura\StructType\OkcReceipt $okcReceipt = null, \TurkkepEFatura\StructType\Passenger $passenger = null, \TurkkepEFatura\StructType\Representative $representative = null, \TurkkepEFatura\StructType\PaymentMeans $paymentMeans = null, $gtbReference = null, $gtbTescilNo = null, \TurkkepEFatura\StructType\Shipment $shipment = null, \TurkkepEFatura\StructType\SgkInvoice $sgkInvoice = null, $beyannameNo = null)
    {
        $this
            ->setSpecialTaxTotal($specialTaxTotal)
            ->setSpecialTaxableAmount($specialTaxableAmount)
            ->setSpecialTaxPercent($specialTaxPercent)
            ->setInvoiceId($invoiceId)
            ->setCopyIndicator($copyIndicator)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setInvoiceType($invoiceType)
            ->setProfile($profile)
            ->setDocumentCurrency($documentCurrency)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setTotalTaxAmount($totalTaxAmount)
            ->setWitholdingTotalTaxAmount($witholdingTotalTaxAmount)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodDurationMeasure($periodDurationMeasure)
            ->setPeriodDuration($periodDuration)
            ->setOrderDate($orderDate)
            ->setReceiptDate($receiptDate)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setPenaltyAmount($penaltyAmount)
            ->setAllowanceChargeIndicator($allowanceChargeIndicator)
            ->setAllowanceChargeMultiplierFactor($allowanceChargeMultiplierFactor)
            ->setTotalAllowanceChargeAmount($totalAllowanceChargeAmount)
            ->setAllowanceChargeBaseAmount($allowanceChargeBaseAmount)
            ->setTotalLineExtensionAmount($totalLineExtensionAmount)
            ->setTotalTaxExlusiveAmount($totalTaxExlusiveAmount)
            ->setTotalTaxInclusiveAmount($totalTaxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setTotalPayableRoundingAmount($totalPayableRoundingAmount)
            ->setTotalPayableAmount($totalPayableAmount)
            ->setArchived($archived)
            ->setStatus($status)
            ->setEnvelopeDate($envelopeDate)
            ->setFiiliIhracatTarihi($fiiliIhracatTarihi)
            ->setInvoiceCount($invoiceCount)
            ->setFreeExport($freeExport)
            ->setBeyannameTarihi($beyannameTarihi)
            ->setIntacTarihi($intacTarihi)
            ->setNotificationSend($notificationSend)
            ->setNoteList($noteList)
            ->setLines($lines)
            ->setTaxSubtotals($taxSubtotals)
            ->setDespatchNotes($despatchNotes)
            ->setAttachments($attachments)
            ->setInvoiceReference($invoiceReference)
            ->setUUID($uUID)
            ->setOrderId($orderId)
            ->setReceiptId($receiptId)
            ->setCustomerParty($customerParty)
            ->setPaymentTermsNote($paymentTermsNote)
            ->setAllowanceChargeReason($allowanceChargeReason)
            ->setResponseStatusCode($responseStatusCode)
            ->setResponseDescription($responseDescription)
            ->setApplicationResponseDescription($applicationResponseDescription)
            ->setSenderAlias($senderAlias)
            ->setPostboxAlias($postboxAlias)
            ->setXSLTName($xSLTName)
            ->setERPInvoiceNo($eRPInvoiceNo)
            ->setExemptionReason($exemptionReason)
            ->setExemptionReasonCode($exemptionReasonCode)
            ->setXMLContent($xMLContent)
            ->setDeliveryType($deliveryType)
            ->setSendMethod($sendMethod)
            ->setInternetDetail($internetDetail)
            ->setAdditionalInfo($additionalInfo)
            ->setEnvelopeReference($envelopeReference)
            ->setSupplierParty($supplierParty)
            ->setOkcReceipt($okcReceipt)
            ->setPassenger($passenger)
            ->setRepresentative($representative)
            ->setPaymentMeans($paymentMeans)
            ->setGtbReference($gtbReference)
            ->setGtbTescilNo($gtbTescilNo)
            ->setShipment($shipment)
            ->setSgkInvoice($sgkInvoice)
            ->setBeyannameNo($beyannameNo);
    }
    /**
     * Get SpecialTaxTotal value
     * @return float
     */
    public function getSpecialTaxTotal()
    {
        return $this->SpecialTaxTotal;
    }
    /**
     * Set SpecialTaxTotal value
     * @param float $specialTaxTotal
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSpecialTaxTotal($specialTaxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($specialTaxTotal) && !(is_float($specialTaxTotal) || is_numeric($specialTaxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($specialTaxTotal, true), gettype($specialTaxTotal)), __LINE__);
        }
        $this->SpecialTaxTotal = $specialTaxTotal;
        return $this;
    }
    /**
     * Get SpecialTaxableAmount value
     * @return float
     */
    public function getSpecialTaxableAmount()
    {
        return $this->SpecialTaxableAmount;
    }
    /**
     * Set SpecialTaxableAmount value
     * @param float $specialTaxableAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSpecialTaxableAmount($specialTaxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($specialTaxableAmount) && !(is_float($specialTaxableAmount) || is_numeric($specialTaxableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($specialTaxableAmount, true), gettype($specialTaxableAmount)), __LINE__);
        }
        $this->SpecialTaxableAmount = $specialTaxableAmount;
        return $this;
    }
    /**
     * Get SpecialTaxPercent value
     * @return float
     */
    public function getSpecialTaxPercent()
    {
        return $this->SpecialTaxPercent;
    }
    /**
     * Set SpecialTaxPercent value
     * @param float $specialTaxPercent
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSpecialTaxPercent($specialTaxPercent = null)
    {
        // validation for constraint: float
        if (!is_null($specialTaxPercent) && !(is_float($specialTaxPercent) || is_numeric($specialTaxPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($specialTaxPercent, true), gettype($specialTaxPercent)), __LINE__);
        }
        $this->SpecialTaxPercent = $specialTaxPercent;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param int $invoiceId
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceId) && !(is_int($invoiceId) || ctype_digit($invoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return bool
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param bool $copyIndicator
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setCopyIndicator($copyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyIndicator) && !is_bool($copyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyIndicator, true), gettype($copyIndicator)), __LINE__);
        }
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return string
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param string $issueTime
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueTime, true), gettype($issueTime)), __LINE__);
        }
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return string
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @uses \TurkkepEFatura\EnumType\InvoiceType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\InvoiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceType
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\InvoiceType::valueIsValid($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\InvoiceType', is_array($invoiceType) ? implode(', ', $invoiceType) : var_export($invoiceType, true), implode(', ', \TurkkepEFatura\EnumType\InvoiceType::getValidValues())), __LINE__);
        }
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get Profile value
     * @return string
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @uses \TurkkepEFatura\EnumType\Profile::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\Profile::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profile
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\Profile::valueIsValid($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\Profile', is_array($profile) ? implode(', ', $profile) : var_export($profile, true), implode(', ', \TurkkepEFatura\EnumType\Profile::getValidValues())), __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Get DocumentCurrency value
     * @return string
     */
    public function getDocumentCurrency()
    {
        return $this->DocumentCurrency;
    }
    /**
     * Set DocumentCurrency value
     * @uses \TurkkepEFatura\EnumType\CurrencyType::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentCurrency
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setDocumentCurrency($documentCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\CurrencyType::valueIsValid($documentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\CurrencyType', is_array($documentCurrency) ? implode(', ', $documentCurrency) : var_export($documentCurrency, true), implode(', ', \TurkkepEFatura\EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->DocumentCurrency = $documentCurrency;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return float
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param float $pricingExchangeRate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPricingExchangeRate($pricingExchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($pricingExchangeRate) && !(is_float($pricingExchangeRate) || is_numeric($pricingExchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricingExchangeRate, true), gettype($pricingExchangeRate)), __LINE__);
        }
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get TotalTaxAmount value
     * @return float
     */
    public function getTotalTaxAmount()
    {
        return $this->TotalTaxAmount;
    }
    /**
     * Set TotalTaxAmount value
     * @param float $totalTaxAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalTaxAmount($totalTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxAmount) && !(is_float($totalTaxAmount) || is_numeric($totalTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxAmount, true), gettype($totalTaxAmount)), __LINE__);
        }
        $this->TotalTaxAmount = $totalTaxAmount;
        return $this;
    }
    /**
     * Get WitholdingTotalTaxAmount value
     * @return float
     */
    public function getWitholdingTotalTaxAmount()
    {
        return $this->WitholdingTotalTaxAmount;
    }
    /**
     * Set WitholdingTotalTaxAmount value
     * @param float $witholdingTotalTaxAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setWitholdingTotalTaxAmount($witholdingTotalTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($witholdingTotalTaxAmount) && !(is_float($witholdingTotalTaxAmount) || is_numeric($witholdingTotalTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($witholdingTotalTaxAmount, true), gettype($witholdingTotalTaxAmount)), __LINE__);
        }
        $this->WitholdingTotalTaxAmount = $witholdingTotalTaxAmount;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodStartDate, true), gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEndDate, true), gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get PeriodDurationMeasure value
     * @return string
     */
    public function getPeriodDurationMeasure()
    {
        return $this->PeriodDurationMeasure;
    }
    /**
     * Set PeriodDurationMeasure value
     * @uses \TurkkepEFatura\EnumType\DurationMeasure::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\DurationMeasure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodDurationMeasure
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPeriodDurationMeasure($periodDurationMeasure = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\DurationMeasure::valueIsValid($periodDurationMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\DurationMeasure', is_array($periodDurationMeasure) ? implode(', ', $periodDurationMeasure) : var_export($periodDurationMeasure, true), implode(', ', \TurkkepEFatura\EnumType\DurationMeasure::getValidValues())), __LINE__);
        }
        $this->PeriodDurationMeasure = $periodDurationMeasure;
        return $this;
    }
    /**
     * Get PeriodDuration value
     * @return int
     */
    public function getPeriodDuration()
    {
        return $this->PeriodDuration;
    }
    /**
     * Set PeriodDuration value
     * @param int $periodDuration
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPeriodDuration($periodDuration = null)
    {
        // validation for constraint: int
        if (!is_null($periodDuration) && !(is_int($periodDuration) || ctype_digit($periodDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodDuration, true), gettype($periodDuration)), __LINE__);
        }
        $this->PeriodDuration = $periodDuration;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get ReceiptDate value
     * @return string
     */
    public function getReceiptDate()
    {
        return $this->ReceiptDate;
    }
    /**
     * Set ReceiptDate value
     * @param string $receiptDate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setReceiptDate($receiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($receiptDate) && !is_string($receiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptDate, true), gettype($receiptDate)), __LINE__);
        }
        $this->ReceiptDate = $receiptDate;
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return float
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param float $penaltySurchargePercent
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPenaltySurchargePercent($penaltySurchargePercent = null)
    {
        // validation for constraint: float
        if (!is_null($penaltySurchargePercent) && !(is_float($penaltySurchargePercent) || is_numeric($penaltySurchargePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltySurchargePercent, true), gettype($penaltySurchargePercent)), __LINE__);
        }
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return float
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param float $penaltyAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPenaltyAmount($penaltyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($penaltyAmount) && !(is_float($penaltyAmount) || is_numeric($penaltyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltyAmount, true), gettype($penaltyAmount)), __LINE__);
        }
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get AllowanceChargeIndicator value
     * @return bool
     */
    public function getAllowanceChargeIndicator()
    {
        return $this->AllowanceChargeIndicator;
    }
    /**
     * Set AllowanceChargeIndicator value
     * @param bool $allowanceChargeIndicator
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAllowanceChargeIndicator($allowanceChargeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowanceChargeIndicator) && !is_bool($allowanceChargeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowanceChargeIndicator, true), gettype($allowanceChargeIndicator)), __LINE__);
        }
        $this->AllowanceChargeIndicator = $allowanceChargeIndicator;
        return $this;
    }
    /**
     * Get AllowanceChargeMultiplierFactor value
     * @return float
     */
    public function getAllowanceChargeMultiplierFactor()
    {
        return $this->AllowanceChargeMultiplierFactor;
    }
    /**
     * Set AllowanceChargeMultiplierFactor value
     * @param float $allowanceChargeMultiplierFactor
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAllowanceChargeMultiplierFactor($allowanceChargeMultiplierFactor = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceChargeMultiplierFactor) && !(is_float($allowanceChargeMultiplierFactor) || is_numeric($allowanceChargeMultiplierFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceChargeMultiplierFactor, true), gettype($allowanceChargeMultiplierFactor)), __LINE__);
        }
        $this->AllowanceChargeMultiplierFactor = $allowanceChargeMultiplierFactor;
        return $this;
    }
    /**
     * Get TotalAllowanceChargeAmount value
     * @return float
     */
    public function getTotalAllowanceChargeAmount()
    {
        return $this->TotalAllowanceChargeAmount;
    }
    /**
     * Set TotalAllowanceChargeAmount value
     * @param float $totalAllowanceChargeAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalAllowanceChargeAmount($totalAllowanceChargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAllowanceChargeAmount) && !(is_float($totalAllowanceChargeAmount) || is_numeric($totalAllowanceChargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAllowanceChargeAmount, true), gettype($totalAllowanceChargeAmount)), __LINE__);
        }
        $this->TotalAllowanceChargeAmount = $totalAllowanceChargeAmount;
        return $this;
    }
    /**
     * Get AllowanceChargeBaseAmount value
     * @return float
     */
    public function getAllowanceChargeBaseAmount()
    {
        return $this->AllowanceChargeBaseAmount;
    }
    /**
     * Set AllowanceChargeBaseAmount value
     * @param float $allowanceChargeBaseAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAllowanceChargeBaseAmount($allowanceChargeBaseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceChargeBaseAmount) && !(is_float($allowanceChargeBaseAmount) || is_numeric($allowanceChargeBaseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceChargeBaseAmount, true), gettype($allowanceChargeBaseAmount)), __LINE__);
        }
        $this->AllowanceChargeBaseAmount = $allowanceChargeBaseAmount;
        return $this;
    }
    /**
     * Get TotalLineExtensionAmount value
     * @return float
     */
    public function getTotalLineExtensionAmount()
    {
        return $this->TotalLineExtensionAmount;
    }
    /**
     * Set TotalLineExtensionAmount value
     * @param float $totalLineExtensionAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalLineExtensionAmount($totalLineExtensionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalLineExtensionAmount) && !(is_float($totalLineExtensionAmount) || is_numeric($totalLineExtensionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalLineExtensionAmount, true), gettype($totalLineExtensionAmount)), __LINE__);
        }
        $this->TotalLineExtensionAmount = $totalLineExtensionAmount;
        return $this;
    }
    /**
     * Get TotalTaxExlusiveAmount value
     * @return float
     */
    public function getTotalTaxExlusiveAmount()
    {
        return $this->TotalTaxExlusiveAmount;
    }
    /**
     * Set TotalTaxExlusiveAmount value
     * @param float $totalTaxExlusiveAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalTaxExlusiveAmount($totalTaxExlusiveAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxExlusiveAmount) && !(is_float($totalTaxExlusiveAmount) || is_numeric($totalTaxExlusiveAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxExlusiveAmount, true), gettype($totalTaxExlusiveAmount)), __LINE__);
        }
        $this->TotalTaxExlusiveAmount = $totalTaxExlusiveAmount;
        return $this;
    }
    /**
     * Get TotalTaxInclusiveAmount value
     * @return float
     */
    public function getTotalTaxInclusiveAmount()
    {
        return $this->TotalTaxInclusiveAmount;
    }
    /**
     * Set TotalTaxInclusiveAmount value
     * @param float $totalTaxInclusiveAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalTaxInclusiveAmount($totalTaxInclusiveAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalTaxInclusiveAmount) && !(is_float($totalTaxInclusiveAmount) || is_numeric($totalTaxInclusiveAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalTaxInclusiveAmount, true), gettype($totalTaxInclusiveAmount)), __LINE__);
        }
        $this->TotalTaxInclusiveAmount = $totalTaxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return float
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param float $allowanceTotalAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAllowanceTotalAmount($allowanceTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceTotalAmount) && !(is_float($allowanceTotalAmount) || is_numeric($allowanceTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceTotalAmount, true), gettype($allowanceTotalAmount)), __LINE__);
        }
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return float
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param float $chargeTotalAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setChargeTotalAmount($chargeTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($chargeTotalAmount) && !(is_float($chargeTotalAmount) || is_numeric($chargeTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeTotalAmount, true), gettype($chargeTotalAmount)), __LINE__);
        }
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get TotalPayableRoundingAmount value
     * @return float
     */
    public function getTotalPayableRoundingAmount()
    {
        return $this->TotalPayableRoundingAmount;
    }
    /**
     * Set TotalPayableRoundingAmount value
     * @param float $totalPayableRoundingAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalPayableRoundingAmount($totalPayableRoundingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalPayableRoundingAmount) && !(is_float($totalPayableRoundingAmount) || is_numeric($totalPayableRoundingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPayableRoundingAmount, true), gettype($totalPayableRoundingAmount)), __LINE__);
        }
        $this->TotalPayableRoundingAmount = $totalPayableRoundingAmount;
        return $this;
    }
    /**
     * Get TotalPayableAmount value
     * @return float
     */
    public function getTotalPayableAmount()
    {
        return $this->TotalPayableAmount;
    }
    /**
     * Set TotalPayableAmount value
     * @param float $totalPayableAmount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTotalPayableAmount($totalPayableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalPayableAmount) && !(is_float($totalPayableAmount) || is_numeric($totalPayableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPayableAmount, true), gettype($totalPayableAmount)), __LINE__);
        }
        $this->TotalPayableAmount = $totalPayableAmount;
        return $this;
    }
    /**
     * Get Archived value
     * @return bool
     */
    public function getArchived()
    {
        return $this->Archived;
    }
    /**
     * Set Archived value
     * @param bool $archived
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($archived, true), gettype($archived)), __LINE__);
        }
        $this->Archived = $archived;
        return $this;
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get EnvelopeDate value
     * @return string
     */
    public function getEnvelopeDate()
    {
        return $this->EnvelopeDate;
    }
    /**
     * Set EnvelopeDate value
     * @param string $envelopeDate
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setEnvelopeDate($envelopeDate = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeDate) && !is_string($envelopeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envelopeDate, true), gettype($envelopeDate)), __LINE__);
        }
        $this->EnvelopeDate = $envelopeDate;
        return $this;
    }
    /**
     * Get FiiliIhracatTarihi value
     * @return string
     */
    public function getFiiliIhracatTarihi()
    {
        return $this->FiiliIhracatTarihi;
    }
    /**
     * Set FiiliIhracatTarihi value
     * @param string $fiiliIhracatTarihi
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setFiiliIhracatTarihi($fiiliIhracatTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($fiiliIhracatTarihi) && !is_string($fiiliIhracatTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fiiliIhracatTarihi, true), gettype($fiiliIhracatTarihi)), __LINE__);
        }
        $this->FiiliIhracatTarihi = $fiiliIhracatTarihi;
        return $this;
    }
    /**
     * Get InvoiceCount value
     * @return int
     */
    public function getInvoiceCount()
    {
        return $this->InvoiceCount;
    }
    /**
     * Set InvoiceCount value
     * @param int $invoiceCount
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setInvoiceCount($invoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceCount) && !(is_int($invoiceCount) || ctype_digit($invoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceCount, true), gettype($invoiceCount)), __LINE__);
        }
        $this->InvoiceCount = $invoiceCount;
        return $this;
    }
    /**
     * Get FreeExport value
     * @return bool
     */
    public function getFreeExport()
    {
        return $this->FreeExport;
    }
    /**
     * Set FreeExport value
     * @param bool $freeExport
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setFreeExport($freeExport = null)
    {
        // validation for constraint: boolean
        if (!is_null($freeExport) && !is_bool($freeExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($freeExport, true), gettype($freeExport)), __LINE__);
        }
        $this->FreeExport = $freeExport;
        return $this;
    }
    /**
     * Get BeyannameTarihi value
     * @return string
     */
    public function getBeyannameTarihi()
    {
        return $this->BeyannameTarihi;
    }
    /**
     * Set BeyannameTarihi value
     * @param string $beyannameTarihi
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setBeyannameTarihi($beyannameTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($beyannameTarihi) && !is_string($beyannameTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beyannameTarihi, true), gettype($beyannameTarihi)), __LINE__);
        }
        $this->BeyannameTarihi = $beyannameTarihi;
        return $this;
    }
    /**
     * Get IntacTarihi value
     * @return string
     */
    public function getIntacTarihi()
    {
        return $this->IntacTarihi;
    }
    /**
     * Set IntacTarihi value
     * @param string $intacTarihi
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setIntacTarihi($intacTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($intacTarihi) && !is_string($intacTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intacTarihi, true), gettype($intacTarihi)), __LINE__);
        }
        $this->IntacTarihi = $intacTarihi;
        return $this;
    }
    /**
     * Get NotificationSend value
     * @return bool
     */
    public function getNotificationSend()
    {
        return $this->NotificationSend;
    }
    /**
     * Set NotificationSend value
     * @param bool $notificationSend
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setNotificationSend($notificationSend = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificationSend) && !is_bool($notificationSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificationSend, true), gettype($notificationSend)), __LINE__);
        }
        $this->NotificationSend = $notificationSend;
        return $this;
    }
    /**
     * Get NoteList value
     * @return \TurkkepEFatura\ArrayType\ArrayOfString|null
     */
    public function getNoteList()
    {
        return $this->NoteList;
    }
    /**
     * Set NoteList value
     * @param \TurkkepEFatura\ArrayType\ArrayOfString $noteList
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setNoteList(\TurkkepEFatura\ArrayType\ArrayOfString $noteList = null)
    {
        $this->NoteList = $noteList;
        return $this;
    }
    /**
     * Get Lines value
     * @return \TurkkepEFatura\ArrayType\ArrayOfInvoiceLine|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \TurkkepEFatura\ArrayType\ArrayOfInvoiceLine $lines
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setLines(\TurkkepEFatura\ArrayType\ArrayOfInvoiceLine $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get TaxSubtotals value
     * @return \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal|null
     */
    public function getTaxSubtotals()
    {
        return $this->TaxSubtotals;
    }
    /**
     * Set TaxSubtotals value
     * @param \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setTaxSubtotals(\TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal $taxSubtotals = null)
    {
        $this->TaxSubtotals = $taxSubtotals;
        return $this;
    }
    /**
     * Get DespatchNotes value
     * @return \TurkkepEFatura\ArrayType\ArrayOfDespatchNote|null
     */
    public function getDespatchNotes()
    {
        return $this->DespatchNotes;
    }
    /**
     * Set DespatchNotes value
     * @param \TurkkepEFatura\ArrayType\ArrayOfDespatchNote $despatchNotes
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setDespatchNotes(\TurkkepEFatura\ArrayType\ArrayOfDespatchNote $despatchNotes = null)
    {
        $this->DespatchNotes = $despatchNotes;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \TurkkepEFatura\ArrayType\ArrayOfDocument|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @param \TurkkepEFatura\ArrayType\ArrayOfDocument $attachments
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAttachments(\TurkkepEFatura\ArrayType\ArrayOfDocument $attachments = null)
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Get InvoiceReference value
     * @return string|null
     */
    public function getInvoiceReference()
    {
        return $this->InvoiceReference;
    }
    /**
     * Set InvoiceReference value
     * @param string $invoiceReference
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setInvoiceReference($invoiceReference = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceReference) && !is_string($invoiceReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceReference, true), gettype($invoiceReference)), __LINE__);
        }
        $this->InvoiceReference = $invoiceReference;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ReceiptId value
     * @return string|null
     */
    public function getReceiptId()
    {
        return $this->ReceiptId;
    }
    /**
     * Set ReceiptId value
     * @param string $receiptId
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setReceiptId($receiptId = null)
    {
        // validation for constraint: string
        if (!is_null($receiptId) && !is_string($receiptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptId, true), gettype($receiptId)), __LINE__);
        }
        $this->ReceiptId = $receiptId;
        return $this;
    }
    /**
     * Get CustomerParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getCustomerParty()
    {
        return $this->CustomerParty;
    }
    /**
     * Set CustomerParty value
     * @param \TurkkepEFatura\StructType\Party $customerParty
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setCustomerParty(\TurkkepEFatura\StructType\Party $customerParty = null)
    {
        $this->CustomerParty = $customerParty;
        return $this;
    }
    /**
     * Get PaymentTermsNote value
     * @return string|null
     */
    public function getPaymentTermsNote()
    {
        return $this->PaymentTermsNote;
    }
    /**
     * Set PaymentTermsNote value
     * @param string $paymentTermsNote
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPaymentTermsNote($paymentTermsNote = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsNote) && !is_string($paymentTermsNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsNote, true), gettype($paymentTermsNote)), __LINE__);
        }
        $this->PaymentTermsNote = $paymentTermsNote;
        return $this;
    }
    /**
     * Get AllowanceChargeReason value
     * @return string|null
     */
    public function getAllowanceChargeReason()
    {
        return $this->AllowanceChargeReason;
    }
    /**
     * Set AllowanceChargeReason value
     * @param string $allowanceChargeReason
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAllowanceChargeReason($allowanceChargeReason = null)
    {
        // validation for constraint: string
        if (!is_null($allowanceChargeReason) && !is_string($allowanceChargeReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowanceChargeReason, true), gettype($allowanceChargeReason)), __LINE__);
        }
        $this->AllowanceChargeReason = $allowanceChargeReason;
        return $this;
    }
    /**
     * Get ResponseStatusCode value
     * @return string|null
     */
    public function getResponseStatusCode()
    {
        return $this->ResponseStatusCode;
    }
    /**
     * Set ResponseStatusCode value
     * @param string $responseStatusCode
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setResponseStatusCode($responseStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseStatusCode) && !is_string($responseStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseStatusCode, true), gettype($responseStatusCode)), __LINE__);
        }
        $this->ResponseStatusCode = $responseStatusCode;
        return $this;
    }
    /**
     * Get ResponseDescription value
     * @return string|null
     */
    public function getResponseDescription()
    {
        return $this->ResponseDescription;
    }
    /**
     * Set ResponseDescription value
     * @param string $responseDescription
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setResponseDescription($responseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($responseDescription) && !is_string($responseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDescription, true), gettype($responseDescription)), __LINE__);
        }
        $this->ResponseDescription = $responseDescription;
        return $this;
    }
    /**
     * Get ApplicationResponseDescription value
     * @return string|null
     */
    public function getApplicationResponseDescription()
    {
        return $this->ApplicationResponseDescription;
    }
    /**
     * Set ApplicationResponseDescription value
     * @param string $applicationResponseDescription
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setApplicationResponseDescription($applicationResponseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($applicationResponseDescription) && !is_string($applicationResponseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationResponseDescription, true), gettype($applicationResponseDescription)), __LINE__);
        }
        $this->ApplicationResponseDescription = $applicationResponseDescription;
        return $this;
    }
    /**
     * Get SenderAlias value
     * @return string|null
     */
    public function getSenderAlias()
    {
        return $this->SenderAlias;
    }
    /**
     * Set SenderAlias value
     * @param string $senderAlias
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSenderAlias($senderAlias = null)
    {
        // validation for constraint: string
        if (!is_null($senderAlias) && !is_string($senderAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAlias, true), gettype($senderAlias)), __LINE__);
        }
        $this->SenderAlias = $senderAlias;
        return $this;
    }
    /**
     * Get PostboxAlias value
     * @return string|null
     */
    public function getPostboxAlias()
    {
        return $this->PostboxAlias;
    }
    /**
     * Set PostboxAlias value
     * @param string $postboxAlias
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPostboxAlias($postboxAlias = null)
    {
        // validation for constraint: string
        if (!is_null($postboxAlias) && !is_string($postboxAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postboxAlias, true), gettype($postboxAlias)), __LINE__);
        }
        $this->PostboxAlias = $postboxAlias;
        return $this;
    }
    /**
     * Get XSLTName value
     * @return string|null
     */
    public function getXSLTName()
    {
        return $this->XSLTName;
    }
    /**
     * Set XSLTName value
     * @param string $xSLTName
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setXSLTName($xSLTName = null)
    {
        // validation for constraint: string
        if (!is_null($xSLTName) && !is_string($xSLTName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xSLTName, true), gettype($xSLTName)), __LINE__);
        }
        $this->XSLTName = $xSLTName;
        return $this;
    }
    /**
     * Get ERPInvoiceNo value
     * @return string|null
     */
    public function getERPInvoiceNo()
    {
        return $this->ERPInvoiceNo;
    }
    /**
     * Set ERPInvoiceNo value
     * @param string $eRPInvoiceNo
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setERPInvoiceNo($eRPInvoiceNo = null)
    {
        // validation for constraint: string
        if (!is_null($eRPInvoiceNo) && !is_string($eRPInvoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRPInvoiceNo, true), gettype($eRPInvoiceNo)), __LINE__);
        }
        $this->ERPInvoiceNo = $eRPInvoiceNo;
        return $this;
    }
    /**
     * Get ExemptionReason value
     * @return string|null
     */
    public function getExemptionReason()
    {
        return $this->ExemptionReason;
    }
    /**
     * Set ExemptionReason value
     * @param string $exemptionReason
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setExemptionReason($exemptionReason = null)
    {
        // validation for constraint: string
        if (!is_null($exemptionReason) && !is_string($exemptionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exemptionReason, true), gettype($exemptionReason)), __LINE__);
        }
        $this->ExemptionReason = $exemptionReason;
        return $this;
    }
    /**
     * Get ExemptionReasonCode value
     * @return string|null
     */
    public function getExemptionReasonCode()
    {
        return $this->ExemptionReasonCode;
    }
    /**
     * Set ExemptionReasonCode value
     * @param string $exemptionReasonCode
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setExemptionReasonCode($exemptionReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($exemptionReasonCode) && !is_string($exemptionReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exemptionReasonCode, true), gettype($exemptionReasonCode)), __LINE__);
        }
        $this->ExemptionReasonCode = $exemptionReasonCode;
        return $this;
    }
    /**
     * Get XMLContent value
     * @return string|null
     */
    public function getXMLContent()
    {
        return $this->XMLContent;
    }
    /**
     * Set XMLContent value
     * @param string $xMLContent
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setXMLContent($xMLContent = null)
    {
        // validation for constraint: string
        if (!is_null($xMLContent) && !is_string($xMLContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xMLContent, true), gettype($xMLContent)), __LINE__);
        }
        $this->XMLContent = $xMLContent;
        return $this;
    }
    /**
     * Get DeliveryType value
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @param string $deliveryType
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryType) && !is_string($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryType, true), gettype($deliveryType)), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get SendMethod value
     * @return string|null
     */
    public function getSendMethod()
    {
        return $this->SendMethod;
    }
    /**
     * Set SendMethod value
     * @param string $sendMethod
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSendMethod($sendMethod = null)
    {
        // validation for constraint: string
        if (!is_null($sendMethod) && !is_string($sendMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendMethod, true), gettype($sendMethod)), __LINE__);
        }
        $this->SendMethod = $sendMethod;
        return $this;
    }
    /**
     * Get InternetDetail value
     * @return \TurkkepEFatura\StructType\InternetDetail|null
     */
    public function getInternetDetail()
    {
        return $this->InternetDetail;
    }
    /**
     * Set InternetDetail value
     * @param \TurkkepEFatura\StructType\InternetDetail $internetDetail
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setInternetDetail(\TurkkepEFatura\StructType\InternetDetail $internetDetail = null)
    {
        $this->InternetDetail = $internetDetail;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo $additionalInfo
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setAdditionalInfo(\TurkkepEFatura\ArrayType\ArrayOfAdditionalInfo $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get EnvelopeReference value
     * @return string|null
     */
    public function getEnvelopeReference()
    {
        return $this->EnvelopeReference;
    }
    /**
     * Set EnvelopeReference value
     * @param string $envelopeReference
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setEnvelopeReference($envelopeReference = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeReference) && !is_string($envelopeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envelopeReference, true), gettype($envelopeReference)), __LINE__);
        }
        $this->EnvelopeReference = $envelopeReference;
        return $this;
    }
    /**
     * Get SupplierParty value
     * @return \TurkkepEFatura\StructType\Party|null
     */
    public function getSupplierParty()
    {
        return $this->SupplierParty;
    }
    /**
     * Set SupplierParty value
     * @param \TurkkepEFatura\StructType\Party $supplierParty
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSupplierParty(\TurkkepEFatura\StructType\Party $supplierParty = null)
    {
        $this->SupplierParty = $supplierParty;
        return $this;
    }
    /**
     * Get OkcReceipt value
     * @return \TurkkepEFatura\StructType\OkcReceipt|null
     */
    public function getOkcReceipt()
    {
        return $this->OkcReceipt;
    }
    /**
     * Set OkcReceipt value
     * @param \TurkkepEFatura\StructType\OkcReceipt $okcReceipt
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setOkcReceipt(\TurkkepEFatura\StructType\OkcReceipt $okcReceipt = null)
    {
        $this->OkcReceipt = $okcReceipt;
        return $this;
    }
    /**
     * Get Passenger value
     * @return \TurkkepEFatura\StructType\Passenger|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @param \TurkkepEFatura\StructType\Passenger $passenger
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPassenger(\TurkkepEFatura\StructType\Passenger $passenger = null)
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Get Representative value
     * @return \TurkkepEFatura\StructType\Representative|null
     */
    public function getRepresentative()
    {
        return $this->Representative;
    }
    /**
     * Set Representative value
     * @param \TurkkepEFatura\StructType\Representative $representative
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setRepresentative(\TurkkepEFatura\StructType\Representative $representative = null)
    {
        $this->Representative = $representative;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \TurkkepEFatura\StructType\PaymentMeans|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * Set PaymentMeans value
     * @param \TurkkepEFatura\StructType\PaymentMeans $paymentMeans
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setPaymentMeans(\TurkkepEFatura\StructType\PaymentMeans $paymentMeans = null)
    {
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Get GtbReference value
     * @return string|null
     */
    public function getGtbReference()
    {
        return $this->GtbReference;
    }
    /**
     * Set GtbReference value
     * @param string $gtbReference
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setGtbReference($gtbReference = null)
    {
        // validation for constraint: string
        if (!is_null($gtbReference) && !is_string($gtbReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtbReference, true), gettype($gtbReference)), __LINE__);
        }
        $this->GtbReference = $gtbReference;
        return $this;
    }
    /**
     * Get GtbTescilNo value
     * @return string|null
     */
    public function getGtbTescilNo()
    {
        return $this->GtbTescilNo;
    }
    /**
     * Set GtbTescilNo value
     * @param string $gtbTescilNo
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setGtbTescilNo($gtbTescilNo = null)
    {
        // validation for constraint: string
        if (!is_null($gtbTescilNo) && !is_string($gtbTescilNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtbTescilNo, true), gettype($gtbTescilNo)), __LINE__);
        }
        $this->GtbTescilNo = $gtbTescilNo;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \TurkkepEFatura\StructType\Shipment|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \TurkkepEFatura\StructType\Shipment $shipment
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setShipment(\TurkkepEFatura\StructType\Shipment $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get SgkInvoice value
     * @return \TurkkepEFatura\StructType\SgkInvoice|null
     */
    public function getSgkInvoice()
    {
        return $this->SgkInvoice;
    }
    /**
     * Set SgkInvoice value
     * @param \TurkkepEFatura\StructType\SgkInvoice $sgkInvoice
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setSgkInvoice(\TurkkepEFatura\StructType\SgkInvoice $sgkInvoice = null)
    {
        $this->SgkInvoice = $sgkInvoice;
        return $this;
    }
    /**
     * Get BeyannameNo value
     * @return string|null
     */
    public function getBeyannameNo()
    {
        return $this->BeyannameNo;
    }
    /**
     * Set BeyannameNo value
     * @param string $beyannameNo
     * @return \TurkkepEFatura\StructType\Invoice
     */
    public function setBeyannameNo($beyannameNo = null)
    {
        // validation for constraint: string
        if (!is_null($beyannameNo) && !is_string($beyannameNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beyannameNo, true), gettype($beyannameNo)), __LINE__);
        }
        $this->BeyannameNo = $beyannameNo;
        return $this;
    }
}
