<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransitType StructType
 * @subpackage Structs
 */
class HazardousGoodsTransitType extends AbstractStructBase
{
    /**
     * The TransportEmergencyCardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransportEmergencyCardCode
     * @var \TurkkepEFatura\StructType\TransportEmergencyCardCodeType
     */
    public $TransportEmergencyCardCode;
    /**
     * The PackingCriteriaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PackingCriteriaCode
     * @var \TurkkepEFatura\StructType\PackingCriteriaCodeType
     */
    public $PackingCriteriaCode;
    /**
     * The HazardousRegulationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HazardousRegulationCode
     * @var \TurkkepEFatura\StructType\HazardousRegulationCodeType
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:InhalationToxicityZoneCode
     * @var \TurkkepEFatura\StructType\InhalationToxicityZoneCodeType
     */
    public $InhalationToxicityZoneCode;
    /**
     * The TransportAuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransportAuthorizationCode
     * @var \TurkkepEFatura\StructType\TransportAuthorizationCodeType
     */
    public $TransportAuthorizationCode;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * Constructor method for HazardousGoodsTransitType
     * @uses HazardousGoodsTransitType::setTransportEmergencyCardCode()
     * @uses HazardousGoodsTransitType::setPackingCriteriaCode()
     * @uses HazardousGoodsTransitType::setHazardousRegulationCode()
     * @uses HazardousGoodsTransitType::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransitType::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransitType::setMaximumTemperature()
     * @uses HazardousGoodsTransitType::setMinimumTemperature()
     * @param \TurkkepEFatura\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @param \TurkkepEFatura\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @param \TurkkepEFatura\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @param \TurkkepEFatura\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @param \TurkkepEFatura\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @param \TurkkepEFatura\StructType\TemperatureType $maximumTemperature
     * @param \TurkkepEFatura\StructType\TemperatureType $minimumTemperature
     */
    public function __construct(\TurkkepEFatura\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null, \TurkkepEFatura\StructType\PackingCriteriaCodeType $packingCriteriaCode = null, \TurkkepEFatura\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null, \TurkkepEFatura\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null, \TurkkepEFatura\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null, \TurkkepEFatura\StructType\TemperatureType $maximumTemperature = null, \TurkkepEFatura\StructType\TemperatureType $minimumTemperature = null)
    {
        $this
            ->setTransportEmergencyCardCode($transportEmergencyCardCode)
            ->setPackingCriteriaCode($packingCriteriaCode)
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature);
    }
    /**
     * Get TransportEmergencyCardCode value
     * @return \TurkkepEFatura\StructType\TransportEmergencyCardCodeType|null
     */
    public function getTransportEmergencyCardCode()
    {
        return $this->TransportEmergencyCardCode;
    }
    /**
     * Set TransportEmergencyCardCode value
     * @param \TurkkepEFatura\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setTransportEmergencyCardCode(\TurkkepEFatura\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null)
    {
        $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        return $this;
    }
    /**
     * Get PackingCriteriaCode value
     * @return \TurkkepEFatura\StructType\PackingCriteriaCodeType|null
     */
    public function getPackingCriteriaCode()
    {
        return $this->PackingCriteriaCode;
    }
    /**
     * Set PackingCriteriaCode value
     * @param \TurkkepEFatura\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setPackingCriteriaCode(\TurkkepEFatura\StructType\PackingCriteriaCodeType $packingCriteriaCode = null)
    {
        $this->PackingCriteriaCode = $packingCriteriaCode;
        return $this;
    }
    /**
     * Get HazardousRegulationCode value
     * @return \TurkkepEFatura\StructType\HazardousRegulationCodeType|null
     */
    public function getHazardousRegulationCode()
    {
        return $this->HazardousRegulationCode;
    }
    /**
     * Set HazardousRegulationCode value
     * @param \TurkkepEFatura\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setHazardousRegulationCode(\TurkkepEFatura\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null)
    {
        $this->HazardousRegulationCode = $hazardousRegulationCode;
        return $this;
    }
    /**
     * Get InhalationToxicityZoneCode value
     * @return \TurkkepEFatura\StructType\InhalationToxicityZoneCodeType|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return $this->InhalationToxicityZoneCode;
    }
    /**
     * Set InhalationToxicityZoneCode value
     * @param \TurkkepEFatura\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setInhalationToxicityZoneCode(\TurkkepEFatura\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null)
    {
        $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        return $this;
    }
    /**
     * Get TransportAuthorizationCode value
     * @return \TurkkepEFatura\StructType\TransportAuthorizationCodeType|null
     */
    public function getTransportAuthorizationCode()
    {
        return $this->TransportAuthorizationCode;
    }
    /**
     * Set TransportAuthorizationCode value
     * @param \TurkkepEFatura\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setTransportAuthorizationCode(\TurkkepEFatura\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null)
    {
        $this->TransportAuthorizationCode = $transportAuthorizationCode;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \TurkkepEFatura\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \TurkkepEFatura\StructType\TemperatureType $maximumTemperature
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setMaximumTemperature(\TurkkepEFatura\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \TurkkepEFatura\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \TurkkepEFatura\StructType\TemperatureType $minimumTemperature
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType
     */
    public function setMinimumTemperature(\TurkkepEFatura\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
}
