<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportLine StructType
 * @subpackage Structs
 */
class ExportLine extends AbstractStructBase
{
    /**
     * The PackagingQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PackagingQuantity;
    /**
     * The TransportMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransportMode;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryTerms;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The GrossWeightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GrossWeightAmount;
    /**
     * The NetWeightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetWeightAmount;
    /**
     * The CarriageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CarriageAmount;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackagingTypeCode;
    /**
     * The PackagingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackagingNumber;
    /**
     * The GTipNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GTipNo;
    /**
     * The GlobalCityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GlobalCityName;
    /**
     * The CitySubDivision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CitySubDivision;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The BuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingNo;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * Constructor method for ExportLine
     * @uses ExportLine::setPackagingQuantity()
     * @uses ExportLine::setTransportMode()
     * @uses ExportLine::setDeliveryTerms()
     * @uses ExportLine::setInsuranceAmount()
     * @uses ExportLine::setGrossWeightAmount()
     * @uses ExportLine::setNetWeightAmount()
     * @uses ExportLine::setCarriageAmount()
     * @uses ExportLine::setPackagingTypeCode()
     * @uses ExportLine::setPackagingNumber()
     * @uses ExportLine::setGTipNo()
     * @uses ExportLine::setGlobalCityName()
     * @uses ExportLine::setCitySubDivision()
     * @uses ExportLine::setStreet()
     * @uses ExportLine::setBuildingName()
     * @uses ExportLine::setBuildingNo()
     * @uses ExportLine::setZipCode()
     * @uses ExportLine::setCountry()
     * @param float $packagingQuantity
     * @param string $transportMode
     * @param string $deliveryTerms
     * @param float $insuranceAmount
     * @param float $grossWeightAmount
     * @param float $netWeightAmount
     * @param float $carriageAmount
     * @param string $packagingTypeCode
     * @param string $packagingNumber
     * @param string $gTipNo
     * @param string $globalCityName
     * @param string $citySubDivision
     * @param string $street
     * @param string $buildingName
     * @param string $buildingNo
     * @param string $zipCode
     * @param string $country
     */
    public function __construct($packagingQuantity = null, $transportMode = null, $deliveryTerms = null, $insuranceAmount = null, $grossWeightAmount = null, $netWeightAmount = null, $carriageAmount = null, $packagingTypeCode = null, $packagingNumber = null, $gTipNo = null, $globalCityName = null, $citySubDivision = null, $street = null, $buildingName = null, $buildingNo = null, $zipCode = null, $country = null)
    {
        $this
            ->setPackagingQuantity($packagingQuantity)
            ->setTransportMode($transportMode)
            ->setDeliveryTerms($deliveryTerms)
            ->setInsuranceAmount($insuranceAmount)
            ->setGrossWeightAmount($grossWeightAmount)
            ->setNetWeightAmount($netWeightAmount)
            ->setCarriageAmount($carriageAmount)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackagingNumber($packagingNumber)
            ->setGTipNo($gTipNo)
            ->setGlobalCityName($globalCityName)
            ->setCitySubDivision($citySubDivision)
            ->setStreet($street)
            ->setBuildingName($buildingName)
            ->setBuildingNo($buildingNo)
            ->setZipCode($zipCode)
            ->setCountry($country);
    }
    /**
     * Get PackagingQuantity value
     * @return float
     */
    public function getPackagingQuantity()
    {
        return $this->PackagingQuantity;
    }
    /**
     * Set PackagingQuantity value
     * @param float $packagingQuantity
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setPackagingQuantity($packagingQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($packagingQuantity) && !(is_float($packagingQuantity) || is_numeric($packagingQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($packagingQuantity, true), gettype($packagingQuantity)), __LINE__);
        }
        $this->PackagingQuantity = $packagingQuantity;
        return $this;
    }
    /**
     * Get TransportMode value
     * @return string
     */
    public function getTransportMode()
    {
        return $this->TransportMode;
    }
    /**
     * Set TransportMode value
     * @uses \TurkkepEFatura\EnumType\TransportMode::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\TransportMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportMode
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setTransportMode($transportMode = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\TransportMode::valueIsValid($transportMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\TransportMode', is_array($transportMode) ? implode(', ', $transportMode) : var_export($transportMode, true), implode(', ', \TurkkepEFatura\EnumType\TransportMode::getValidValues())), __LINE__);
        }
        $this->TransportMode = $transportMode;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return string
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * Set DeliveryTerms value
     * @uses \TurkkepEFatura\EnumType\DeliveryTerms::valueIsValid()
     * @uses \TurkkepEFatura\EnumType\DeliveryTerms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryTerms
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setDeliveryTerms($deliveryTerms = null)
    {
        // validation for constraint: enumeration
        if (!\TurkkepEFatura\EnumType\DeliveryTerms::valueIsValid($deliveryTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurkkepEFatura\EnumType\DeliveryTerms', is_array($deliveryTerms) ? implode(', ', $deliveryTerms) : var_export($deliveryTerms, true), implode(', ', \TurkkepEFatura\EnumType\DeliveryTerms::getValidValues())), __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get GrossWeightAmount value
     * @return float
     */
    public function getGrossWeightAmount()
    {
        return $this->GrossWeightAmount;
    }
    /**
     * Set GrossWeightAmount value
     * @param float $grossWeightAmount
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setGrossWeightAmount($grossWeightAmount = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeightAmount) && !(is_float($grossWeightAmount) || is_numeric($grossWeightAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeightAmount, true), gettype($grossWeightAmount)), __LINE__);
        }
        $this->GrossWeightAmount = $grossWeightAmount;
        return $this;
    }
    /**
     * Get NetWeightAmount value
     * @return float
     */
    public function getNetWeightAmount()
    {
        return $this->NetWeightAmount;
    }
    /**
     * Set NetWeightAmount value
     * @param float $netWeightAmount
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setNetWeightAmount($netWeightAmount = null)
    {
        // validation for constraint: float
        if (!is_null($netWeightAmount) && !(is_float($netWeightAmount) || is_numeric($netWeightAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeightAmount, true), gettype($netWeightAmount)), __LINE__);
        }
        $this->NetWeightAmount = $netWeightAmount;
        return $this;
    }
    /**
     * Get CarriageAmount value
     * @return float
     */
    public function getCarriageAmount()
    {
        return $this->CarriageAmount;
    }
    /**
     * Set CarriageAmount value
     * @param float $carriageAmount
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setCarriageAmount($carriageAmount = null)
    {
        // validation for constraint: float
        if (!is_null($carriageAmount) && !(is_float($carriageAmount) || is_numeric($carriageAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carriageAmount, true), gettype($carriageAmount)), __LINE__);
        }
        $this->CarriageAmount = $carriageAmount;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return string|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param string $packagingTypeCode
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setPackagingTypeCode($packagingTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packagingTypeCode) && !is_string($packagingTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagingTypeCode, true), gettype($packagingTypeCode)), __LINE__);
        }
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get PackagingNumber value
     * @return string|null
     */
    public function getPackagingNumber()
    {
        return $this->PackagingNumber;
    }
    /**
     * Set PackagingNumber value
     * @param string $packagingNumber
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setPackagingNumber($packagingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packagingNumber) && !is_string($packagingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagingNumber, true), gettype($packagingNumber)), __LINE__);
        }
        $this->PackagingNumber = $packagingNumber;
        return $this;
    }
    /**
     * Get GTipNo value
     * @return string|null
     */
    public function getGTipNo()
    {
        return $this->GTipNo;
    }
    /**
     * Set GTipNo value
     * @param string $gTipNo
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setGTipNo($gTipNo = null)
    {
        // validation for constraint: string
        if (!is_null($gTipNo) && !is_string($gTipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTipNo, true), gettype($gTipNo)), __LINE__);
        }
        $this->GTipNo = $gTipNo;
        return $this;
    }
    /**
     * Get GlobalCityName value
     * @return string|null
     */
    public function getGlobalCityName()
    {
        return $this->GlobalCityName;
    }
    /**
     * Set GlobalCityName value
     * @param string $globalCityName
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setGlobalCityName($globalCityName = null)
    {
        // validation for constraint: string
        if (!is_null($globalCityName) && !is_string($globalCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($globalCityName, true), gettype($globalCityName)), __LINE__);
        }
        $this->GlobalCityName = $globalCityName;
        return $this;
    }
    /**
     * Get CitySubDivision value
     * @return string|null
     */
    public function getCitySubDivision()
    {
        return $this->CitySubDivision;
    }
    /**
     * Set CitySubDivision value
     * @param string $citySubDivision
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setCitySubDivision($citySubDivision = null)
    {
        // validation for constraint: string
        if (!is_null($citySubDivision) && !is_string($citySubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citySubDivision, true), gettype($citySubDivision)), __LINE__);
        }
        $this->CitySubDivision = $citySubDivision;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get BuildingName value
     * @return string|null
     */
    public function getBuildingName()
    {
        return $this->BuildingName;
    }
    /**
     * Set BuildingName value
     * @param string $buildingName
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        $this->BuildingName = $buildingName;
        return $this;
    }
    /**
     * Get BuildingNo value
     * @return string|null
     */
    public function getBuildingNo()
    {
        return $this->BuildingNo;
    }
    /**
     * Set BuildingNo value
     * @param string $buildingNo
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setBuildingNo($buildingNo = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNo) && !is_string($buildingNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNo, true), gettype($buildingNo)), __LINE__);
        }
        $this->BuildingNo = $buildingNo;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \TurkkepEFatura\StructType\ExportLine
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
}
