<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for UBLF ServiceType
 * @subpackage Services
 */
class UBLF extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UBLFaturaGonder
     * Meta information extracted from the WSDL
     * - documentation: UBL-TR formatında hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\UBLFaturaGonder $parameters
     * @return \TurkkepEFatura\StructType\UBLFaturaGonderResponse|bool
     */
    public function UBLFaturaGonder(\TurkkepEFatura\StructType\UBLFaturaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UBLFaturaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UBLFaturaGonder2
     * Meta information extracted from the WSDL
     * - documentation: UBL-TR formatında hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\UBLFaturaGonder2 $parameters
     * @return \TurkkepEFatura\StructType\UBLFaturaGonder2Response|bool
     */
    public function UBLFaturaGonder2(\TurkkepEFatura\StructType\UBLFaturaGonder2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UBLFaturaGonder2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UBLFaturaGonderAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: UBL-TR formatında hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\UBLFaturaGonderAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\UBLFaturaGonderAnaOrganizasyonResponse|bool
     */
    public function UBLFaturaGonderAnaOrganizasyon(\TurkkepEFatura\StructType\UBLFaturaGonderAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UBLFaturaGonderAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UBLFaturaGonderGunKontrolu
     * Meta information extracted from the WSDL
     * - documentation: UBL-TR formatında hazırlanmış bir faturayı GİB merkez sistemine gönderir. İlk fatura kesim tarihi ile kayıt tarihi kontrolu mevcuttur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\UBLFaturaGonderGunKontrolu $parameters
     * @return \TurkkepEFatura\StructType\UBLFaturaGonderGunKontroluResponse|bool
     */
    public function UBLFaturaGonderGunKontrolu(\TurkkepEFatura\StructType\UBLFaturaGonderGunKontrolu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UBLFaturaGonderGunKontrolu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UBLFaturaGonder3
     * Meta information extracted from the WSDL
     * - documentation: UBL-TR formatında hazırlanmış bir faturayı GİB merkez sistemine gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\UBLFaturaGonder3 $parameters
     * @return \TurkkepEFatura\StructType\UBLFaturaGonder3Response|bool
     */
    public function UBLFaturaGonder3(\TurkkepEFatura\StructType\UBLFaturaGonder3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UBLFaturaGonder3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\UBLFaturaGonder2Response|\TurkkepEFatura\StructType\UBLFaturaGonder3Response|\TurkkepEFatura\StructType\UBLFaturaGonderAnaOrganizasyonResponse|\TurkkepEFatura\StructType\UBLFaturaGonderGunKontroluResponse|\TurkkepEFatura\StructType\UBLFaturaGonderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
