<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Onay ServiceType
 * @subpackage Services
 */
class Onay extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OnayBekleyenGelenIrsaliyeListele
     * Meta information extracted from the WSDL
     * - documentation: Onay bekleyen gelen irsaliyeleri listeler
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\OnayBekleyenGelenIrsaliyeListele $parameters
     * @return \TurkkepEFatura\StructType\OnayBekleyenGelenIrsaliyeListeleResponse|bool
     */
    public function OnayBekleyenGelenIrsaliyeListele(\TurkkepEFatura\StructType\OnayBekleyenGelenIrsaliyeListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OnayBekleyenGelenIrsaliyeListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OnayBekleyenGelenFaturaListele
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturaları listeler. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListele $parameters
     * @return \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleResponse|bool
     */
    public function OnayBekleyenGelenFaturaListele(\TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OnayBekleyenGelenFaturaListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * OnayBekleyenGelenFaturaListeleVknTckn
     * Meta information extracted from the WSDL
     * - documentation: Onay bekleyen faturaları vergi kimlik numarasına göre listeler. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleVknTckn $parameters
     * @return \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleVknTcknResponse|bool
     */
    public function OnayBekleyenGelenFaturaListeleVknTckn(\TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleVknTckn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OnayBekleyenGelenFaturaListeleVknTckn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * onayBekleyenGelenFaturaListeleByTarih
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturaları listeler. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleByTarih $parameters
     * @return \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleByTarihResponse|bool
     */
    public function onayBekleyenGelenFaturaListeleByTarih(\TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleByTarih $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->onayBekleyenGelenFaturaListeleByTarih($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleByTarihResponse|\TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleResponse|\TurkkepEFatura\StructType\OnayBekleyenGelenFaturaListeleVknTcknResponse|\TurkkepEFatura\StructType\OnayBekleyenGelenIrsaliyeListeleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
