<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Okc ServiceType
 * @subpackage Services
 */
class Okc extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OkcRaporHazirla
     * Meta information extracted from the WSDL
     * - documentation: Okc Raporu hazırlar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\OkcRaporHazirla $parameters
     * @return \TurkkepEFatura\StructType\OkcRaporHazirlaResponse|bool
     */
    public function OkcRaporHazirla(\TurkkepEFatura\StructType\OkcRaporHazirla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OkcRaporHazirla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\OkcRaporHazirlaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
