<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Makbuz ServiceType
 * @subpackage Services
 */
class Makbuz extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MakbuzGonder
     * Meta information extracted from the WSDL
     * - documentation: CreditNoteType sınıfını kullanarak UBL 2.1 formatında müstahsil makbuzu oluşturarak Türkkep E-Makbuz servisine göndermek için kullanılır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\MakbuzGonder $parameters
     * @return \TurkkepEFatura\StructType\MakbuzGonderResponse|bool
     */
    public function MakbuzGonder(\TurkkepEFatura\StructType\MakbuzGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MakbuzGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\MakbuzGonderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
