<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hatali ServiceType
 * @subpackage Services
 */
class Hatali extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HataliFaturaTekrarGonder
     * Meta information extracted from the WSDL
     * - documentation: GİB Statü durumu 1215 veya 1230 olan faturaları tekrar göndermenizi sağlar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\HataliFaturaTekrarGonder $parameters
     * @return \TurkkepEFatura\StructType\HataliFaturaTekrarGonderResponse|bool
     */
    public function HataliFaturaTekrarGonder(\TurkkepEFatura\StructType\HataliFaturaTekrarGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HataliFaturaTekrarGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\HataliFaturaTekrarGonderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
