<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Giden ServiceType
 * @subpackage Services
 */
class Giden extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GidenIrsaliyeArsiveGonder
     * Meta information extracted from the WSDL
     * - documentation: Giden Faturaları Arşive Gönderir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeArsiveGonder $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeArsiveGonderResponse|bool
     */
    public function GidenIrsaliyeArsiveGonder(\TurkkepEFatura\StructType\GidenIrsaliyeArsiveGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeArsiveGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyePdfAl
     * Meta information extracted from the WSDL
     * - documentation: Giden Irsaliye faturanın pdf'ini ve html'in döner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyePdfAl $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyePdfAlResponse|bool
     */
    public function GidenIrsaliyePdfAl(\TurkkepEFatura\StructType\GidenIrsaliyePdfAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyePdfAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyePdfAlAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Giden Irsaliye faturanın pdf'ini ve html'in döner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyePdfAlAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyePdfAlAnaOrganizasyonResponse|bool
     */
    public function GidenIrsaliyePdfAlAnaOrganizasyon(\TurkkepEFatura\StructType\GidenIrsaliyePdfAlAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyePdfAlAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GidenIrsaliyeninYanitiniGetirByIrsaliyeUuid
     * Meta information extracted from the WSDL
     * - documentation: Verilen Irsaliye Uuid değeri ile gönderilmiş irsaliyenin yanıtının detayını okur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeninYanitiniGetirByIrsaliyeUuid $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeninYanitiniGetirByIrsaliyeUuidResponse|bool
     */
    public function GidenIrsaliyeninYanitiniGetirByIrsaliyeUuid(\TurkkepEFatura\StructType\GidenIrsaliyeninYanitiniGetirByIrsaliyeUuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeninYanitiniGetirByIrsaliyeUuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GidenIrsaliyeFaturaAraAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş İrsaliye faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GidenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo'
     * verilmezse tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeFaturaAraAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeFaturaAraAnaOrganizasyonResponse|bool
     */
    public function GidenIrsaliyeFaturaAraAnaOrganizasyon(\TurkkepEFatura\StructType\GidenIrsaliyeFaturaAraAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeFaturaAraAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaBeyannameGuncelle
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen Faturaya Beyanname No & Tarihini günceller.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelle $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelleResponse|bool
     */
    public function GidenFaturaBeyannameGuncelle(\TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaBeyannameGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaBeyannameGuncelleByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen Faturaya Beyanname No & Tarihini günceller.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelleByUUID $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelleByUUIDResponse|bool
     */
    public function GidenFaturaBeyannameGuncelleByUUID(\TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelleByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaBeyannameGuncelleByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyeDurumSorgula
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş bir İrsaliyenin durumunu GİB merkez sisteminden sorgular. Dispatch nesnesinin DispatchId alanı doldurulmuş olmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeDurumSorgula $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeDurumSorgulaResponse|bool
     */
    public function GidenIrsaliyeDurumSorgula(\TurkkepEFatura\StructType\GidenIrsaliyeDurumSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeDurumSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaDurumSorgula
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş bir faturanın durumunu GİB merkez sisteminden sorgular. Invoice nesnesinin UUID alanı doldurulmuş olmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaDurumSorgula $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaDurumSorgulaResponse|bool
     */
    public function GidenFaturaDurumSorgula(\TurkkepEFatura\StructType\GidenFaturaDurumSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaDurumSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaDurumSorgula2
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş bir faturanın durumunu GİB merkez sisteminden sorgular. Invoice nesnesinin UUID alanı doldurulmuş olmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaDurumSorgula2 $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaDurumSorgula2Response|bool
     */
    public function GidenFaturaDurumSorgula2(\TurkkepEFatura\StructType\GidenFaturaDurumSorgula2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaDurumSorgula2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaDurumSorgulaUuid
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş bir faturanın durumunu GİB merkez sisteminden sorgular. Invoice nesnesinin UUID alanı doldurulmuş olmalıdır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaDurumSorgulaUuid $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaDurumSorgulaUuidResponse|bool
     */
    public function GidenFaturaDurumSorgulaUuid(\TurkkepEFatura\StructType\GidenFaturaDurumSorgulaUuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaDurumSorgulaUuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOku
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur. GidenFaturaListele veya GidenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOku $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuResponse|bool
     */
    public function GidenFaturaOku(\TurkkepEFatura\StructType\GidenFaturaOku $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOku($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOkuByConnector
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur. GidenFaturaListele veya GidenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOkuByConnector $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuByConnectorResponse|bool
     */
    public function GidenFaturaOkuByConnector(\TurkkepEFatura\StructType\GidenFaturaOkuByConnector $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOkuByConnector($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIhracatFaturaOkuByParent
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur. GidenFaturaListele veya GidenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIhracatFaturaOkuByParent $parameters
     * @return \TurkkepEFatura\StructType\GidenIhracatFaturaOkuByParentResponse|bool
     */
    public function GidenIhracatFaturaOkuByParent(\TurkkepEFatura\StructType\GidenIhracatFaturaOkuByParent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIhracatFaturaOkuByParent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOkuByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur. GidenFaturaListele veya GidenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOkuByUUID $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuByUUIDResponse|bool
     */
    public function GidenFaturaOkuByUUID(\TurkkepEFatura\StructType\GidenFaturaOkuByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOkuByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOkuNoContent
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur. GidenFaturaListele veya GidenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOkuNoContent $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuNoContentResponse|bool
     */
    public function GidenFaturaOkuNoContent(\TurkkepEFatura\StructType\GidenFaturaOkuNoContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOkuNoContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOkuByUUIDNoContent
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur. GidenFaturaListele veya GidenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOkuByUUIDNoContent $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuByUUIDNoContentResponse|bool
     */
    public function GidenFaturaOkuByUUIDNoContent(\TurkkepEFatura\StructType\GidenFaturaOkuByUUIDNoContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOkuByUUIDNoContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaUblGetirByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur verilen UUID değeri ile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaUblGetirByUUID $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaUblGetirByUUIDResponse|bool
     */
    public function GidenFaturaUblGetirByUUID(\TurkkepEFatura\StructType\GidenFaturaUblGetirByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaUblGetirByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyeUblGetirByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura detayını okur verilen UUID değeri ile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeUblGetirByUUID $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeUblGetirByUUIDResponse|bool
     */
    public function GidenIrsaliyeUblGetirByUUID(\TurkkepEFatura\StructType\GidenIrsaliyeUblGetirByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeUblGetirByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaXmlGetirByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş fatura xml bilgisini getirir UUID değeri ile sorgulanarak.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaXmlGetirByUUID $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaXmlGetirByUUIDResponse|bool
     */
    public function GidenFaturaXmlGetirByUUID(\TurkkepEFatura\StructType\GidenFaturaXmlGetirByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaXmlGetirByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaAra
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GidenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse
     * tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaAra $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaAraResponse|bool
     */
    public function GidenFaturaAra(\TurkkepEFatura\StructType\GidenFaturaAra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaAra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaAraAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GidenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse
     * tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaAraAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaAraAnaOrganizasyonResponse|bool
     */
    public function GidenFaturaAraAnaOrganizasyon(\TurkkepEFatura\StructType\GidenFaturaAraAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaAraAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaAraParentIhracat
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GidenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse
     * tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaAraParentIhracat $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaAraParentIhracatResponse|bool
     */
    public function GidenFaturaAraParentIhracat(\TurkkepEFatura\StructType\GidenFaturaAraParentIhracat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaAraParentIhracat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaPdfAl
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen Faturanın PDF'ini döner. FaturaGonder metodlarından dönen InvoiceId gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaPdfAl $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaPdfAlResponse|bool
     */
    public function GidenFaturaPdfAl(\TurkkepEFatura\StructType\GidenFaturaPdfAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaPdfAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaHtmlAl
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen Faturanın Html'ini döner. FaturaGonder metodlarından dönen InvoiceId gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaHtmlAl $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaHtmlAlResponse|bool
     */
    public function GidenFaturaHtmlAl(\TurkkepEFatura\StructType\GidenFaturaHtmlAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaHtmlAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaTumZarflar
     * Meta information extracted from the WSDL
     * - documentation: Giden Fatura Tüm Zarflar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaTumZarflar $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaTumZarflarResponse|bool
     */
    public function GidenFaturaTumZarflar(\TurkkepEFatura\StructType\GidenFaturaTumZarflar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaTumZarflar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOkuByInvoiceRef
     * Meta information extracted from the WSDL
     * - documentation: VKN veya TCKN ile belirtilen bir mükellefe ait etiket listesini döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOkuByInvoiceRef $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuByInvoiceRefResponse|bool
     */
    public function GidenFaturaOkuByInvoiceRef(\TurkkepEFatura\StructType\GidenFaturaOkuByInvoiceRef $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOkuByInvoiceRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaOkuByErpRef
     * Meta information extracted from the WSDL
     * - documentation: VKN veya TCKN ile belirtilen bir mükellefe ait etiket listesini döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaOkuByErpRef $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaOkuByErpRefResponse|bool
     */
    public function GidenFaturaOkuByErpRef(\TurkkepEFatura\StructType\GidenFaturaOkuByErpRef $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaOkuByErpRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaPdfAlByErpRefInvoiceRef
     * Meta information extracted from the WSDL
     * - documentation: Erp Numarası ve Fatura numarası alır ve faturanın pdf dosyasını sıkıştırılmış olarak verir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaPdfAlByErpRefInvoiceRef $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaPdfAlByErpRefInvoiceRefResponse|bool
     */
    public function GidenFaturaPdfAlByErpRefInvoiceRef(\TurkkepEFatura\StructType\GidenFaturaPdfAlByErpRefInvoiceRef $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaPdfAlByErpRefInvoiceRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaArsiveGonder
     * Meta information extracted from the WSDL
     * - documentation: Giden Faturaları Arşive Gönderir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaArsiveGonder $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaArsiveGonderResponse|bool
     */
    public function GidenFaturaArsiveGonder(\TurkkepEFatura\StructType\GidenFaturaArsiveGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaArsiveGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GidenFaturaArsiveGonderAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Giden Faturaları Arşive Gönderir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaArsiveGonderAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaArsiveGonderAnaOrganizasyonResponse|bool
     */
    public function GidenFaturaArsiveGonderAnaOrganizasyon(\TurkkepEFatura\StructType\GidenFaturaArsiveGonderAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaArsiveGonderAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenFaturaArsivdenGeriAl
     * Meta information extracted from the WSDL
     * - documentation: Giden Faturaları Arşivden Geri Alır
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAl $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAlResponse|bool
     */
    public function GidenFaturaArsivdenGeriAl(\TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaArsivdenGeriAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GidenFaturaArsivdenGeriAlAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Giden Faturaları Arşivden Geri Alır
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAlAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAlAnaOrganizasyonResponse|bool
     */
    public function GidenFaturaArsivdenGeriAlAnaOrganizasyon(\TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAlAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenFaturaArsivdenGeriAlAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyeFaturaOku
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş faturanın detayını okur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeFaturaOku $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeFaturaOkuResponse|bool
     */
    public function GidenIrsaliyeFaturaOku(\TurkkepEFatura\StructType\GidenIrsaliyeFaturaOku $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeFaturaOku($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyeFaturaAra
     * Meta information extracted from the WSDL
     * - documentation: Gönderilmiş İrsaliye faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GidenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo'
     * verilmezse tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeFaturaAra $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeFaturaAraResponse|bool
     */
    public function GidenIrsaliyeFaturaAra(\TurkkepEFatura\StructType\GidenIrsaliyeFaturaAra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeFaturaAra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyePdfHtmlAl
     * Meta information extracted from the WSDL
     * - documentation: Giden Irsaliye faturanın pdf'ini ve html'in döner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyePdfHtmlAl $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyePdfHtmlAlResponse|bool
     */
    public function GidenIrsaliyePdfHtmlAl(\TurkkepEFatura\StructType\GidenIrsaliyePdfHtmlAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyePdfHtmlAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GidenIrsaliyeArsivdenGeriAl
     * Meta information extracted from the WSDL
     * - documentation: Giden Faturaları Arşivden Geri Alır
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GidenIrsaliyeArsivdenGeriAl $parameters
     * @return \TurkkepEFatura\StructType\GidenIrsaliyeArsivdenGeriAlResponse|bool
     */
    public function GidenIrsaliyeArsivdenGeriAl(\TurkkepEFatura\StructType\GidenIrsaliyeArsivdenGeriAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GidenIrsaliyeArsivdenGeriAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\GidenFaturaAraAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GidenFaturaAraParentIhracatResponse|\TurkkepEFatura\StructType\GidenFaturaAraResponse|\TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAlAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GidenFaturaArsivdenGeriAlResponse|\TurkkepEFatura\StructType\GidenFaturaArsiveGonderAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GidenFaturaArsiveGonderResponse|\TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelleByUUIDResponse|\TurkkepEFatura\StructType\GidenFaturaBeyannameGuncelleResponse|\TurkkepEFatura\StructType\GidenFaturaDurumSorgula2Response|\TurkkepEFatura\StructType\GidenFaturaDurumSorgulaResponse|\TurkkepEFatura\StructType\GidenFaturaDurumSorgulaUuidResponse|\TurkkepEFatura\StructType\GidenFaturaHtmlAlResponse|\TurkkepEFatura\StructType\GidenFaturaOkuByConnectorResponse|\TurkkepEFatura\StructType\GidenFaturaOkuByErpRefResponse|\TurkkepEFatura\StructType\GidenFaturaOkuByInvoiceRefResponse|\TurkkepEFatura\StructType\GidenFaturaOkuByUUIDNoContentResponse|\TurkkepEFatura\StructType\GidenFaturaOkuByUUIDResponse|\TurkkepEFatura\StructType\GidenFaturaOkuNoContentResponse|\TurkkepEFatura\StructType\GidenFaturaOkuResponse|\TurkkepEFatura\StructType\GidenFaturaPdfAlByErpRefInvoiceRefResponse|\TurkkepEFatura\StructType\GidenFaturaPdfAlResponse|\TurkkepEFatura\StructType\GidenFaturaTumZarflarResponse|\TurkkepEFatura\StructType\GidenFaturaUblGetirByUUIDResponse|\TurkkepEFatura\StructType\GidenFaturaXmlGetirByUUIDResponse|\TurkkepEFatura\StructType\GidenIhracatFaturaOkuByParentResponse|\TurkkepEFatura\StructType\GidenIrsaliyeArsivdenGeriAlResponse|\TurkkepEFatura\StructType\GidenIrsaliyeArsiveGonderResponse|\TurkkepEFatura\StructType\GidenIrsaliyeDurumSorgulaResponse|\TurkkepEFatura\StructType\GidenIrsaliyeFaturaAraAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GidenIrsaliyeFaturaAraResponse|\TurkkepEFatura\StructType\GidenIrsaliyeFaturaOkuResponse|\TurkkepEFatura\StructType\GidenIrsaliyeninYanitiniGetirByIrsaliyeUuidResponse|\TurkkepEFatura\StructType\GidenIrsaliyePdfAlAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GidenIrsaliyePdfAlResponse|\TurkkepEFatura\StructType\GidenIrsaliyePdfHtmlAlResponse|\TurkkepEFatura\StructType\GidenIrsaliyeUblGetirByUUIDResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
