<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetXsltNameWithWs
     * Meta information extracted from the WSDL
     * - documentation: Kayıtlı Müşterilerin Xslt isimlerini getirir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GetXsltNameWithWs $parameters
     * @return \TurkkepEFatura\StructType\GetXsltNameWithWsResponse|bool
     */
    public function GetXsltNameWithWs(\TurkkepEFatura\StructType\GetXsltNameWithWs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetXsltNameWithWs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCreditInvoiceTotal
     * Meta information extracted from the WSDL
     * - documentation: VKN veya TCKN ile belirtilen bir mükellefe ait Fatura Adetlerini gösterir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GetCreditInvoiceTotal $parameters
     * @return \TurkkepEFatura\StructType\GetCreditInvoiceTotalResponse|bool
     */
    public function GetCreditInvoiceTotal(\TurkkepEFatura\StructType\GetCreditInvoiceTotal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCreditInvoiceTotal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\GetCreditInvoiceTotalResponse|\TurkkepEFatura\StructType\GetXsltNameWithWsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
