<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for EA ServiceType
 * @subpackage Services
 */
class EA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named eAarsivRaporHazirla
     * Meta information extracted from the WSDL
     * - documentation: Tarih aralıkları arasındaki faturalardan eArşiv raporu hazırlar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EAarsivRaporHazirla $parameters
     * @return \TurkkepEFatura\StructType\EAarsivRaporHazirlaResponse|bool
     */
    public function eAarsivRaporHazirla(\TurkkepEFatura\StructType\EAarsivRaporHazirla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->eAarsivRaporHazirla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EArsivKalanKontorSorgula
     * Meta information extracted from the WSDL
     * - documentation: E-Arşiv Fatura üzerinden kalan kontör sayısını gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EArsivKalanKontorSorgula $parameters
     * @return \TurkkepEFatura\StructType\EArsivKalanKontorSorgulaResponse|bool
     */
    public function EArsivKalanKontorSorgula(\TurkkepEFatura\StructType\EArsivKalanKontorSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EArsivKalanKontorSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\EAarsivRaporHazirlaResponse|\TurkkepEFatura\StructType\EArsivKalanKontorSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
