<?php

namespace TurkkepEFatura\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransportMode EnumType
 * @subpackage Enumerations
 */
class TransportMode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'TransportModeNotSpecified'
     * @return string 'TransportModeNotSpecified'
     */
    const VALUE_TRANSPORT_MODE_NOT_SPECIFIED = 'TransportModeNotSpecified';
    /**
     * Constant for value 'MaritimeTransport'
     * @return string 'MaritimeTransport'
     */
    const VALUE_MARITIME_TRANSPORT = 'MaritimeTransport';
    /**
     * Constant for value 'RailTransport'
     * @return string 'RailTransport'
     */
    const VALUE_RAIL_TRANSPORT = 'RailTransport';
    /**
     * Constant for value 'RoadTransport'
     * @return string 'RoadTransport'
     */
    const VALUE_ROAD_TRANSPORT = 'RoadTransport';
    /**
     * Constant for value 'AirTransport'
     * @return string 'AirTransport'
     */
    const VALUE_AIR_TRANSPORT = 'AirTransport';
    /**
     * Constant for value 'Mail'
     * @return string 'Mail'
     */
    const VALUE_MAIL = 'Mail';
    /**
     * Constant for value 'MultimodalTransport'
     * @return string 'MultimodalTransport'
     */
    const VALUE_MULTIMODAL_TRANSPORT = 'MultimodalTransport';
    /**
     * Constant for value 'FixedtransportInstallations'
     * @return string 'FixedtransportInstallations'
     */
    const VALUE_FIXEDTRANSPORT_INSTALLATIONS = 'FixedtransportInstallations';
    /**
     * Constant for value 'InlandWaterTransport'
     * @return string 'InlandWaterTransport'
     */
    const VALUE_INLAND_WATER_TRANSPORT = 'InlandWaterTransport';
    /**
     * Constant for value 'TransportModeNotApplicable'
     * @return string 'TransportModeNotApplicable'
     */
    const VALUE_TRANSPORT_MODE_NOT_APPLICABLE = 'TransportModeNotApplicable';
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSPORT_MODE_NOT_SPECIFIED
     * @uses self::VALUE_MARITIME_TRANSPORT
     * @uses self::VALUE_RAIL_TRANSPORT
     * @uses self::VALUE_ROAD_TRANSPORT
     * @uses self::VALUE_AIR_TRANSPORT
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_MULTIMODAL_TRANSPORT
     * @uses self::VALUE_FIXEDTRANSPORT_INSTALLATIONS
     * @uses self::VALUE_INLAND_WATER_TRANSPORT
     * @uses self::VALUE_TRANSPORT_MODE_NOT_APPLICABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSPORT_MODE_NOT_SPECIFIED,
            self::VALUE_MARITIME_TRANSPORT,
            self::VALUE_RAIL_TRANSPORT,
            self::VALUE_ROAD_TRANSPORT,
            self::VALUE_AIR_TRANSPORT,
            self::VALUE_MAIL,
            self::VALUE_MULTIMODAL_TRANSPORT,
            self::VALUE_FIXEDTRANSPORT_INSTALLATIONS,
            self::VALUE_INLAND_WATER_TRANSPORT,
            self::VALUE_TRANSPORT_MODE_NOT_APPLICABLE,
        );
    }
}
