<?php

namespace TurkkepEFatura\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegisteredParty ArrayType
 * @subpackage Arrays
 */
class ArrayOfRegisteredParty extends AbstractStructArrayBase
{
    /**
     * The RegisteredParty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurkkepEFatura\StructType\RegisteredParty[]
     */
    public $RegisteredParty;
    /**
     * Constructor method for ArrayOfRegisteredParty
     * @uses ArrayOfRegisteredParty::setRegisteredParty()
     * @param \TurkkepEFatura\StructType\RegisteredParty[] $registeredParty
     */
    public function __construct(array $registeredParty = array())
    {
        $this
            ->setRegisteredParty($registeredParty);
    }
    /**
     * Get RegisteredParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurkkepEFatura\StructType\RegisteredParty[]|null
     */
    public function getRegisteredParty()
    {
        return isset($this->RegisteredParty) ? $this->RegisteredParty : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRegisteredParty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegisteredParty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegisteredPartyForArrayConstraintsFromSetRegisteredParty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRegisteredPartyRegisteredPartyItem) {
            // validation for constraint: itemType
            if (!$arrayOfRegisteredPartyRegisteredPartyItem instanceof \TurkkepEFatura\StructType\RegisteredParty) {
                $invalidValues[] = is_object($arrayOfRegisteredPartyRegisteredPartyItem) ? get_class($arrayOfRegisteredPartyRegisteredPartyItem) : sprintf('%s(%s)', gettype($arrayOfRegisteredPartyRegisteredPartyItem), var_export($arrayOfRegisteredPartyRegisteredPartyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegisteredParty property can only contain items of type \TurkkepEFatura\StructType\RegisteredParty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegisteredParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\RegisteredParty[] $registeredParty
     * @return \TurkkepEFatura\ArrayType\ArrayOfRegisteredParty
     */
    public function setRegisteredParty(array $registeredParty = array())
    {
        // validation for constraint: array
        if ('' !== ($registeredPartyArrayErrorMessage = self::validateRegisteredPartyForArrayConstraintsFromSetRegisteredParty($registeredParty))) {
            throw new \InvalidArgumentException($registeredPartyArrayErrorMessage, __LINE__);
        }
        if (is_null($registeredParty) || (is_array($registeredParty) && empty($registeredParty))) {
            unset($this->RegisteredParty);
        } else {
            $this->RegisteredParty = $registeredParty;
        }
        return $this;
    }
    /**
     * Add item to RegisteredParty value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\RegisteredParty $item
     * @return \TurkkepEFatura\ArrayType\ArrayOfRegisteredParty
     */
    public function addToRegisteredParty(\TurkkepEFatura\StructType\RegisteredParty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\RegisteredParty) {
            throw new \InvalidArgumentException(sprintf('The RegisteredParty property can only contain items of type \TurkkepEFatura\StructType\RegisteredParty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegisteredParty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurkkepEFatura\StructType\RegisteredParty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurkkepEFatura\StructType\RegisteredParty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurkkepEFatura\StructType\RegisteredParty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurkkepEFatura\StructType\RegisteredParty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurkkepEFatura\StructType\RegisteredParty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RegisteredParty
     */
    public function getAttributeName()
    {
        return 'RegisteredParty';
    }
}
