<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnitType StructType
 * @subpackage Structs
 */
class TransportHandlingUnitType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TransportHandlingUnitTypeCode
     * @var \TurkkepEFatura\StructType\TransportHandlingUnitTypeCodeType
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HandlingCode
     * @var \TurkkepEFatura\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HandlingInstructions
     * @var \TurkkepEFatura\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HazardousRiskIndicator
     * @var \TurkkepEFatura\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TotalGoodsItemQuantity
     * @var \TurkkepEFatura\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TotalPackageQuantity
     * @var \TurkkepEFatura\StructType\TotalPackageQuantityType
     */
    public $TotalPackageQuantity;
    /**
     * The DamageRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:DamageRemarks
     * @var \TurkkepEFatura\StructType\DamageRemarksType[]
     */
    public $DamageRemarks;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TraceID
     * @var \TurkkepEFatura\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The ActualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PackageType[]
     */
    public $ActualPackage;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TransportEquipmentType[]
     */
    public $TransportEquipment;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TransportMeansType[]
     */
    public $TransportMeans;
    /**
     * The HazardousGoodsTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\HazardousGoodsTransitType[]
     */
    public $HazardousGoodsTransit;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DocumentReferenceType[]
     */
    public $ShipmentDocumentReference;
    /**
     * The CustomsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\CustomsDeclarationType[]
     */
    public $CustomsDeclaration;
    /**
     * Constructor method for TransportHandlingUnitType
     * @uses TransportHandlingUnitType::setID()
     * @uses TransportHandlingUnitType::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnitType::setHandlingCode()
     * @uses TransportHandlingUnitType::setHandlingInstructions()
     * @uses TransportHandlingUnitType::setHazardousRiskIndicator()
     * @uses TransportHandlingUnitType::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnitType::setTotalPackageQuantity()
     * @uses TransportHandlingUnitType::setDamageRemarks()
     * @uses TransportHandlingUnitType::setTraceID()
     * @uses TransportHandlingUnitType::setActualPackage()
     * @uses TransportHandlingUnitType::setTransportEquipment()
     * @uses TransportHandlingUnitType::setTransportMeans()
     * @uses TransportHandlingUnitType::setHazardousGoodsTransit()
     * @uses TransportHandlingUnitType::setMeasurementDimension()
     * @uses TransportHandlingUnitType::setMinimumTemperature()
     * @uses TransportHandlingUnitType::setMaximumTemperature()
     * @uses TransportHandlingUnitType::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setShipmentDocumentReference()
     * @uses TransportHandlingUnitType::setCustomsDeclaration()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @param \TurkkepEFatura\StructType\HandlingCodeType $handlingCode
     * @param \TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \TurkkepEFatura\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @param \TurkkepEFatura\StructType\DamageRemarksType[] $damageRemarks
     * @param \TurkkepEFatura\StructType\TraceIDType $traceID
     * @param \TurkkepEFatura\StructType\PackageType[] $actualPackage
     * @param \TurkkepEFatura\StructType\TransportEquipmentType[] $transportEquipment
     * @param \TurkkepEFatura\StructType\TransportMeansType[] $transportMeans
     * @param \TurkkepEFatura\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     * @param \TurkkepEFatura\StructType\TemperatureType $minimumTemperature
     * @param \TurkkepEFatura\StructType\TemperatureType $maximumTemperature
     * @param \TurkkepEFatura\StructType\DimensionType $floorSpaceMeasurementDimension
     * @param \TurkkepEFatura\StructType\DimensionType $palletSpaceMeasurementDimension
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @param \TurkkepEFatura\StructType\CustomsDeclarationType[] $customsDeclaration
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null, \TurkkepEFatura\StructType\HandlingCodeType $handlingCode = null, \TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions = null, \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \TurkkepEFatura\StructType\TotalPackageQuantityType $totalPackageQuantity = null, array $damageRemarks = array(), \TurkkepEFatura\StructType\TraceIDType $traceID = null, array $actualPackage = array(), array $transportEquipment = array(), array $transportMeans = array(), array $hazardousGoodsTransit = array(), array $measurementDimension = array(), \TurkkepEFatura\StructType\TemperatureType $minimumTemperature = null, \TurkkepEFatura\StructType\TemperatureType $maximumTemperature = null, \TurkkepEFatura\StructType\DimensionType $floorSpaceMeasurementDimension = null, \TurkkepEFatura\StructType\DimensionType $palletSpaceMeasurementDimension = null, array $shipmentDocumentReference = array(), array $customsDeclaration = array())
    {
        $this
            ->setID($iD)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setDamageRemarks($damageRemarks)
            ->setTraceID($traceID)
            ->setActualPackage($actualPackage)
            ->setTransportEquipment($transportEquipment)
            ->setTransportMeans($transportMeans)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setCustomsDeclaration($customsDeclaration);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportHandlingUnitTypeCode value
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitTypeCodeType|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return $this->TransportHandlingUnitTypeCode;
    }
    /**
     * Set TransportHandlingUnitTypeCode value
     * @param \TurkkepEFatura\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setTransportHandlingUnitTypeCode(\TurkkepEFatura\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null)
    {
        $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \TurkkepEFatura\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \TurkkepEFatura\StructType\HandlingCodeType $handlingCode
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setHandlingCode(\TurkkepEFatura\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \TurkkepEFatura\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setHandlingInstructions(\TurkkepEFatura\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \TurkkepEFatura\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setHazardousRiskIndicator(\TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \TurkkepEFatura\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setTotalGoodsItemQuantity(\TurkkepEFatura\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalPackageQuantity value
     * @return \TurkkepEFatura\StructType\TotalPackageQuantityType|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }
    /**
     * Set TotalPackageQuantity value
     * @param \TurkkepEFatura\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setTotalPackageQuantity(\TurkkepEFatura\StructType\TotalPackageQuantityType $totalPackageQuantity = null)
    {
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }
    /**
     * Get DamageRemarks value
     * @return \TurkkepEFatura\StructType\DamageRemarksType[]|null
     */
    public function getDamageRemarks()
    {
        return $this->DamageRemarks;
    }
    /**
     * This method is responsible for validating the values passed to the setDamageRemarks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDamageRemarks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDamageRemarksForArrayConstraintsFromSetDamageRemarks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeDamageRemarksItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeDamageRemarksItem instanceof \TurkkepEFatura\StructType\DamageRemarksType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeDamageRemarksItem) ? get_class($transportHandlingUnitTypeDamageRemarksItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeDamageRemarksItem), var_export($transportHandlingUnitTypeDamageRemarksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DamageRemarks property can only contain items of type \TurkkepEFatura\StructType\DamageRemarksType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DamageRemarksType[] $damageRemarks
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setDamageRemarks(array $damageRemarks = array())
    {
        // validation for constraint: array
        if ('' !== ($damageRemarksArrayErrorMessage = self::validateDamageRemarksForArrayConstraintsFromSetDamageRemarks($damageRemarks))) {
            throw new \InvalidArgumentException($damageRemarksArrayErrorMessage, __LINE__);
        }
        $this->DamageRemarks = $damageRemarks;
        return $this;
    }
    /**
     * Add item to DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DamageRemarksType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToDamageRemarks(\TurkkepEFatura\StructType\DamageRemarksType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DamageRemarksType) {
            throw new \InvalidArgumentException(sprintf('The DamageRemarks property can only contain items of type \TurkkepEFatura\StructType\DamageRemarksType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DamageRemarks[] = $item;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \TurkkepEFatura\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \TurkkepEFatura\StructType\TraceIDType $traceID
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setTraceID(\TurkkepEFatura\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get ActualPackage value
     * @return \TurkkepEFatura\StructType\PackageType[]|null
     */
    public function getActualPackage()
    {
        return $this->ActualPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setActualPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualPackageForArrayConstraintsFromSetActualPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeActualPackageItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeActualPackageItem instanceof \TurkkepEFatura\StructType\PackageType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeActualPackageItem) ? get_class($transportHandlingUnitTypeActualPackageItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeActualPackageItem), var_export($transportHandlingUnitTypeActualPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActualPackage property can only contain items of type \TurkkepEFatura\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActualPackage value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PackageType[] $actualPackage
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setActualPackage(array $actualPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($actualPackageArrayErrorMessage = self::validateActualPackageForArrayConstraintsFromSetActualPackage($actualPackage))) {
            throw new \InvalidArgumentException($actualPackageArrayErrorMessage, __LINE__);
        }
        $this->ActualPackage = $actualPackage;
        return $this;
    }
    /**
     * Add item to ActualPackage value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PackageType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToActualPackage(\TurkkepEFatura\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The ActualPackage property can only contain items of type \TurkkepEFatura\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActualPackage[] = $item;
        return $this;
    }
    /**
     * Get TransportEquipment value
     * @return \TurkkepEFatura\StructType\TransportEquipmentType[]|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportEquipmentItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportEquipmentItem instanceof \TurkkepEFatura\StructType\TransportEquipmentType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportEquipmentItem) ? get_class($transportHandlingUnitTypeTransportEquipmentItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportEquipmentItem), var_export($transportHandlingUnitTypeTransportEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportEquipment property can only contain items of type \TurkkepEFatura\StructType\TransportEquipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TransportEquipmentType[] $transportEquipment
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setTransportEquipment(array $transportEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($transportEquipmentArrayErrorMessage = self::validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment($transportEquipment))) {
            throw new \InvalidArgumentException($transportEquipmentArrayErrorMessage, __LINE__);
        }
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }
    /**
     * Add item to TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TransportEquipmentType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToTransportEquipment(\TurkkepEFatura\StructType\TransportEquipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TransportEquipmentType) {
            throw new \InvalidArgumentException(sprintf('The TransportEquipment property can only contain items of type \TurkkepEFatura\StructType\TransportEquipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportEquipment[] = $item;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \TurkkepEFatura\StructType\TransportMeansType[]|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportMeansForArrayConstraintsFromSetTransportMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportMeansItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportMeansItem instanceof \TurkkepEFatura\StructType\TransportMeansType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportMeansItem) ? get_class($transportHandlingUnitTypeTransportMeansItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportMeansItem), var_export($transportHandlingUnitTypeTransportMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportMeans property can only contain items of type \TurkkepEFatura\StructType\TransportMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportMeans value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TransportMeansType[] $transportMeans
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setTransportMeans(array $transportMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($transportMeansArrayErrorMessage = self::validateTransportMeansForArrayConstraintsFromSetTransportMeans($transportMeans))) {
            throw new \InvalidArgumentException($transportMeansArrayErrorMessage, __LINE__);
        }
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Add item to TransportMeans value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TransportMeansType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToTransportMeans(\TurkkepEFatura\StructType\TransportMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TransportMeansType) {
            throw new \InvalidArgumentException(sprintf('The TransportMeans property can only contain items of type \TurkkepEFatura\StructType\TransportMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportMeans[] = $item;
        return $this;
    }
    /**
     * Get HazardousGoodsTransit value
     * @return \TurkkepEFatura\StructType\HazardousGoodsTransitType[]|null
     */
    public function getHazardousGoodsTransit()
    {
        return $this->HazardousGoodsTransit;
    }
    /**
     * This method is responsible for validating the values passed to the setHazardousGoodsTransit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazardousGoodsTransit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeHazardousGoodsTransitItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeHazardousGoodsTransitItem instanceof \TurkkepEFatura\StructType\HazardousGoodsTransitType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeHazardousGoodsTransitItem) ? get_class($transportHandlingUnitTypeHazardousGoodsTransitItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeHazardousGoodsTransitItem), var_export($transportHandlingUnitTypeHazardousGoodsTransitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazardousGoodsTransit property can only contain items of type \TurkkepEFatura\StructType\HazardousGoodsTransitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setHazardousGoodsTransit(array $hazardousGoodsTransit = array())
    {
        // validation for constraint: array
        if ('' !== ($hazardousGoodsTransitArrayErrorMessage = self::validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit($hazardousGoodsTransit))) {
            throw new \InvalidArgumentException($hazardousGoodsTransitArrayErrorMessage, __LINE__);
        }
        $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        return $this;
    }
    /**
     * Add item to HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\HazardousGoodsTransitType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToHazardousGoodsTransit(\TurkkepEFatura\StructType\HazardousGoodsTransitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\HazardousGoodsTransitType) {
            throw new \InvalidArgumentException(sprintf('The HazardousGoodsTransit property can only contain items of type \TurkkepEFatura\StructType\HazardousGoodsTransitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HazardousGoodsTransit[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \TurkkepEFatura\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeMeasurementDimensionItem instanceof \TurkkepEFatura\StructType\DimensionType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeMeasurementDimensionItem) ? get_class($transportHandlingUnitTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeMeasurementDimensionItem), var_export($transportHandlingUnitTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToMeasurementDimension(\TurkkepEFatura\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \TurkkepEFatura\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \TurkkepEFatura\StructType\TemperatureType $minimumTemperature
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setMinimumTemperature(\TurkkepEFatura\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \TurkkepEFatura\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \TurkkepEFatura\StructType\TemperatureType $maximumTemperature
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setMaximumTemperature(\TurkkepEFatura\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get FloorSpaceMeasurementDimension value
     * @return \TurkkepEFatura\StructType\DimensionType|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return $this->FloorSpaceMeasurementDimension;
    }
    /**
     * Set FloorSpaceMeasurementDimension value
     * @param \TurkkepEFatura\StructType\DimensionType $floorSpaceMeasurementDimension
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setFloorSpaceMeasurementDimension(\TurkkepEFatura\StructType\DimensionType $floorSpaceMeasurementDimension = null)
    {
        $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get PalletSpaceMeasurementDimension value
     * @return \TurkkepEFatura\StructType\DimensionType|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return $this->PalletSpaceMeasurementDimension;
    }
    /**
     * Set PalletSpaceMeasurementDimension value
     * @param \TurkkepEFatura\StructType\DimensionType $palletSpaceMeasurementDimension
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setPalletSpaceMeasurementDimension(\TurkkepEFatura\StructType\DimensionType $palletSpaceMeasurementDimension = null)
    {
        $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get ShipmentDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType[]|null
     */
    public function getShipmentDocumentReference()
    {
        return $this->ShipmentDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeShipmentDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeShipmentDocumentReferenceItem instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeShipmentDocumentReferenceItem) ? get_class($transportHandlingUnitTypeShipmentDocumentReferenceItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeShipmentDocumentReferenceItem), var_export($transportHandlingUnitTypeShipmentDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setShipmentDocumentReference(array $shipmentDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDocumentReferenceArrayErrorMessage = self::validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference($shipmentDocumentReference))) {
            throw new \InvalidArgumentException($shipmentDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ShipmentDocumentReference = $shipmentDocumentReference;
        return $this;
    }
    /**
     * Add item to ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToShipmentDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDocumentReference property can only contain items of type \TurkkepEFatura\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get CustomsDeclaration value
     * @return \TurkkepEFatura\StructType\CustomsDeclarationType[]|null
     */
    public function getCustomsDeclaration()
    {
        return $this->CustomsDeclaration;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsDeclaration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsDeclaration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeCustomsDeclarationItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeCustomsDeclarationItem instanceof \TurkkepEFatura\StructType\CustomsDeclarationType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeCustomsDeclarationItem) ? get_class($transportHandlingUnitTypeCustomsDeclarationItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeCustomsDeclarationItem), var_export($transportHandlingUnitTypeCustomsDeclarationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsDeclaration property can only contain items of type \TurkkepEFatura\StructType\CustomsDeclarationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CustomsDeclarationType[] $customsDeclaration
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function setCustomsDeclaration(array $customsDeclaration = array())
    {
        // validation for constraint: array
        if ('' !== ($customsDeclarationArrayErrorMessage = self::validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration($customsDeclaration))) {
            throw new \InvalidArgumentException($customsDeclarationArrayErrorMessage, __LINE__);
        }
        $this->CustomsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Add item to CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\CustomsDeclarationType $item
     * @return \TurkkepEFatura\StructType\TransportHandlingUnitType
     */
    public function addToCustomsDeclaration(\TurkkepEFatura\StructType\CustomsDeclarationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\CustomsDeclarationType) {
            throw new \InvalidArgumentException(sprintf('The CustomsDeclaration property can only contain items of type \TurkkepEFatura\StructType\CustomsDeclarationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsDeclaration[] = $item;
        return $this;
    }
}
