<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisteredParty StructType
 * @subpackage Structs
 */
class RegisteredParty extends DataModelObject
{
    /**
     * The RegisteredPartyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegisteredPartyId;
    /**
     * The FirstCreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FirstCreationDate;
    /**
     * The AliasCreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AliasCreationDate;
    /**
     * The AliasDeletionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AliasDeletionDate;
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Identifier;
    /**
     * The Alias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alias;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Role;
    /**
     * Constructor method for RegisteredParty
     * @uses RegisteredParty::setRegisteredPartyId()
     * @uses RegisteredParty::setFirstCreationDate()
     * @uses RegisteredParty::setAliasCreationDate()
     * @uses RegisteredParty::setAliasDeletionDate()
     * @uses RegisteredParty::setIdentifier()
     * @uses RegisteredParty::setAlias()
     * @uses RegisteredParty::setTitle()
     * @uses RegisteredParty::setType()
     * @uses RegisteredParty::setDocumentType()
     * @uses RegisteredParty::setAccountType()
     * @uses RegisteredParty::setRole()
     * @param int $registeredPartyId
     * @param string $firstCreationDate
     * @param string $aliasCreationDate
     * @param string $aliasDeletionDate
     * @param string $identifier
     * @param string $alias
     * @param string $title
     * @param string $type
     * @param string $documentType
     * @param string $accountType
     * @param string $role
     */
    public function __construct($registeredPartyId = null, $firstCreationDate = null, $aliasCreationDate = null, $aliasDeletionDate = null, $identifier = null, $alias = null, $title = null, $type = null, $documentType = null, $accountType = null, $role = null)
    {
        $this
            ->setRegisteredPartyId($registeredPartyId)
            ->setFirstCreationDate($firstCreationDate)
            ->setAliasCreationDate($aliasCreationDate)
            ->setAliasDeletionDate($aliasDeletionDate)
            ->setIdentifier($identifier)
            ->setAlias($alias)
            ->setTitle($title)
            ->setType($type)
            ->setDocumentType($documentType)
            ->setAccountType($accountType)
            ->setRole($role);
    }
    /**
     * Get RegisteredPartyId value
     * @return int
     */
    public function getRegisteredPartyId()
    {
        return $this->RegisteredPartyId;
    }
    /**
     * Set RegisteredPartyId value
     * @param int $registeredPartyId
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setRegisteredPartyId($registeredPartyId = null)
    {
        // validation for constraint: int
        if (!is_null($registeredPartyId) && !(is_int($registeredPartyId) || ctype_digit($registeredPartyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registeredPartyId, true), gettype($registeredPartyId)), __LINE__);
        }
        $this->RegisteredPartyId = $registeredPartyId;
        return $this;
    }
    /**
     * Get FirstCreationDate value
     * @return string
     */
    public function getFirstCreationDate()
    {
        return $this->FirstCreationDate;
    }
    /**
     * Set FirstCreationDate value
     * @param string $firstCreationDate
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setFirstCreationDate($firstCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstCreationDate) && !is_string($firstCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstCreationDate, true), gettype($firstCreationDate)), __LINE__);
        }
        $this->FirstCreationDate = $firstCreationDate;
        return $this;
    }
    /**
     * Get AliasCreationDate value
     * @return string
     */
    public function getAliasCreationDate()
    {
        return $this->AliasCreationDate;
    }
    /**
     * Set AliasCreationDate value
     * @param string $aliasCreationDate
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setAliasCreationDate($aliasCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($aliasCreationDate) && !is_string($aliasCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasCreationDate, true), gettype($aliasCreationDate)), __LINE__);
        }
        $this->AliasCreationDate = $aliasCreationDate;
        return $this;
    }
    /**
     * Get AliasDeletionDate value
     * @return string
     */
    public function getAliasDeletionDate()
    {
        return $this->AliasDeletionDate;
    }
    /**
     * Set AliasDeletionDate value
     * @param string $aliasDeletionDate
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setAliasDeletionDate($aliasDeletionDate = null)
    {
        // validation for constraint: string
        if (!is_null($aliasDeletionDate) && !is_string($aliasDeletionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasDeletionDate, true), gettype($aliasDeletionDate)), __LINE__);
        }
        $this->AliasDeletionDate = $aliasDeletionDate;
        return $this;
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get Alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->Alias;
    }
    /**
     * Set Alias value
     * @param string $alias
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        $this->Alias = $alias;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \TurkkepEFatura\StructType\RegisteredParty
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->Role = $role;
        return $this;
    }
}
