<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The WebsiteURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:WebsiteURI
     * @var \TurkkepEFatura\StructType\WebsiteURIType
     */
    public $WebsiteURI;
    /**
     * The EndpointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:EndpointID
     * @var \TurkkepEFatura\StructType\EndpointIDType
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:IndustryClassificationCode
     * @var \TurkkepEFatura\StructType\IndustryClassificationCodeType
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyIdentificationType[]
     */
    public $PartyIdentification;
    /**
     * The PartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyNameType
     */
    public $PartyName;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AddressType
     */
    public $PostalAddress;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LocationType
     */
    public $PhysicalLocation;
    /**
     * The PartyTaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyTaxSchemeType
     */
    public $PartyTaxScheme;
    /**
     * The PartyLegalEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyLegalEntityType[]
     */
    public $PartyLegalEntity;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ContactType
     */
    public $Contact;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PersonType
     */
    public $Person;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $AgentParty;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setWebsiteURI()
     * @uses PartyType::setEndpointID()
     * @uses PartyType::setIndustryClassificationCode()
     * @uses PartyType::setPartyIdentification()
     * @uses PartyType::setPartyName()
     * @uses PartyType::setPostalAddress()
     * @uses PartyType::setPhysicalLocation()
     * @uses PartyType::setPartyTaxScheme()
     * @uses PartyType::setPartyLegalEntity()
     * @uses PartyType::setContact()
     * @uses PartyType::setPerson()
     * @uses PartyType::setAgentParty()
     * @param \TurkkepEFatura\StructType\WebsiteURIType $websiteURI
     * @param \TurkkepEFatura\StructType\EndpointIDType $endpointID
     * @param \TurkkepEFatura\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @param \TurkkepEFatura\StructType\PartyIdentificationType[] $partyIdentification
     * @param \TurkkepEFatura\StructType\PartyNameType $partyName
     * @param \TurkkepEFatura\StructType\AddressType $postalAddress
     * @param \TurkkepEFatura\StructType\LocationType $physicalLocation
     * @param \TurkkepEFatura\StructType\PartyTaxSchemeType $partyTaxScheme
     * @param \TurkkepEFatura\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @param \TurkkepEFatura\StructType\ContactType $contact
     * @param \TurkkepEFatura\StructType\PersonType $person
     * @param \TurkkepEFatura\StructType\PartyType $agentParty
     */
    public function __construct(\TurkkepEFatura\StructType\WebsiteURIType $websiteURI = null, \TurkkepEFatura\StructType\EndpointIDType $endpointID = null, \TurkkepEFatura\StructType\IndustryClassificationCodeType $industryClassificationCode = null, array $partyIdentification = array(), \TurkkepEFatura\StructType\PartyNameType $partyName = null, \TurkkepEFatura\StructType\AddressType $postalAddress = null, \TurkkepEFatura\StructType\LocationType $physicalLocation = null, \TurkkepEFatura\StructType\PartyTaxSchemeType $partyTaxScheme = null, array $partyLegalEntity = array(), \TurkkepEFatura\StructType\ContactType $contact = null, \TurkkepEFatura\StructType\PersonType $person = null, \TurkkepEFatura\StructType\PartyType $agentParty = null)
    {
        $this
            ->setWebsiteURI($websiteURI)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentification($partyIdentification)
            ->setPartyName($partyName)
            ->setPostalAddress($postalAddress)
            ->setPhysicalLocation($physicalLocation)
            ->setPartyTaxScheme($partyTaxScheme)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setContact($contact)
            ->setPerson($person)
            ->setAgentParty($agentParty);
    }
    /**
     * Get WebsiteURI value
     * @return \TurkkepEFatura\StructType\WebsiteURIType|null
     */
    public function getWebsiteURI()
    {
        return $this->WebsiteURI;
    }
    /**
     * Set WebsiteURI value
     * @param \TurkkepEFatura\StructType\WebsiteURIType $websiteURI
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setWebsiteURI(\TurkkepEFatura\StructType\WebsiteURIType $websiteURI = null)
    {
        $this->WebsiteURI = $websiteURI;
        return $this;
    }
    /**
     * Get EndpointID value
     * @return \TurkkepEFatura\StructType\EndpointIDType|null
     */
    public function getEndpointID()
    {
        return $this->EndpointID;
    }
    /**
     * Set EndpointID value
     * @param \TurkkepEFatura\StructType\EndpointIDType $endpointID
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setEndpointID(\TurkkepEFatura\StructType\EndpointIDType $endpointID = null)
    {
        $this->EndpointID = $endpointID;
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * @return \TurkkepEFatura\StructType\IndustryClassificationCodeType|null
     */
    public function getIndustryClassificationCode()
    {
        return $this->IndustryClassificationCode;
    }
    /**
     * Set IndustryClassificationCode value
     * @param \TurkkepEFatura\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setIndustryClassificationCode(\TurkkepEFatura\StructType\IndustryClassificationCodeType $industryClassificationCode = null)
    {
        $this->IndustryClassificationCode = $industryClassificationCode;
        return $this;
    }
    /**
     * Get PartyIdentification value
     * @return \TurkkepEFatura\StructType\PartyIdentificationType[]|null
     */
    public function getPartyIdentification()
    {
        return $this->PartyIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyIdentificationItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyIdentificationItem instanceof \TurkkepEFatura\StructType\PartyIdentificationType) {
                $invalidValues[] = is_object($partyTypePartyIdentificationItem) ? get_class($partyTypePartyIdentificationItem) : sprintf('%s(%s)', gettype($partyTypePartyIdentificationItem), var_export($partyTypePartyIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyIdentification property can only contain items of type \TurkkepEFatura\StructType\PartyIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PartyIdentificationType[] $partyIdentification
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPartyIdentification(array $partyIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($partyIdentificationArrayErrorMessage = self::validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification($partyIdentification))) {
            throw new \InvalidArgumentException($partyIdentificationArrayErrorMessage, __LINE__);
        }
        $this->PartyIdentification = $partyIdentification;
        return $this;
    }
    /**
     * Add item to PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PartyIdentificationType $item
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function addToPartyIdentification(\TurkkepEFatura\StructType\PartyIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PartyIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The PartyIdentification property can only contain items of type \TurkkepEFatura\StructType\PartyIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyIdentification[] = $item;
        return $this;
    }
    /**
     * Get PartyName value
     * @return \TurkkepEFatura\StructType\PartyNameType|null
     */
    public function getPartyName()
    {
        return $this->PartyName;
    }
    /**
     * Set PartyName value
     * @param \TurkkepEFatura\StructType\PartyNameType $partyName
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPartyName(\TurkkepEFatura\StructType\PartyNameType $partyName = null)
    {
        $this->PartyName = $partyName;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \TurkkepEFatura\StructType\AddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \TurkkepEFatura\StructType\AddressType $postalAddress
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPostalAddress(\TurkkepEFatura\StructType\AddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * @return \TurkkepEFatura\StructType\LocationType|null
     */
    public function getPhysicalLocation()
    {
        return $this->PhysicalLocation;
    }
    /**
     * Set PhysicalLocation value
     * @param \TurkkepEFatura\StructType\LocationType $physicalLocation
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPhysicalLocation(\TurkkepEFatura\StructType\LocationType $physicalLocation = null)
    {
        $this->PhysicalLocation = $physicalLocation;
        return $this;
    }
    /**
     * Get PartyTaxScheme value
     * @return \TurkkepEFatura\StructType\PartyTaxSchemeType|null
     */
    public function getPartyTaxScheme()
    {
        return $this->PartyTaxScheme;
    }
    /**
     * Set PartyTaxScheme value
     * @param \TurkkepEFatura\StructType\PartyTaxSchemeType $partyTaxScheme
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPartyTaxScheme(\TurkkepEFatura\StructType\PartyTaxSchemeType $partyTaxScheme = null)
    {
        $this->PartyTaxScheme = $partyTaxScheme;
        return $this;
    }
    /**
     * Get PartyLegalEntity value
     * @return \TurkkepEFatura\StructType\PartyLegalEntityType[]|null
     */
    public function getPartyLegalEntity()
    {
        return $this->PartyLegalEntity;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyLegalEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyLegalEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyLegalEntityItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyLegalEntityItem instanceof \TurkkepEFatura\StructType\PartyLegalEntityType) {
                $invalidValues[] = is_object($partyTypePartyLegalEntityItem) ? get_class($partyTypePartyLegalEntityItem) : sprintf('%s(%s)', gettype($partyTypePartyLegalEntityItem), var_export($partyTypePartyLegalEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyLegalEntity property can only contain items of type \TurkkepEFatura\StructType\PartyLegalEntityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($partyLegalEntityArrayErrorMessage = self::validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity($partyLegalEntity))) {
            throw new \InvalidArgumentException($partyLegalEntityArrayErrorMessage, __LINE__);
        }
        $this->PartyLegalEntity = $partyLegalEntity;
        return $this;
    }
    /**
     * Add item to PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\PartyLegalEntityType $item
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function addToPartyLegalEntity(\TurkkepEFatura\StructType\PartyLegalEntityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\PartyLegalEntityType) {
            throw new \InvalidArgumentException(sprintf('The PartyLegalEntity property can only contain items of type \TurkkepEFatura\StructType\PartyLegalEntityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyLegalEntity[] = $item;
        return $this;
    }
    /**
     * Get Contact value
     * @return \TurkkepEFatura\StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \TurkkepEFatura\StructType\ContactType $contact
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setContact(\TurkkepEFatura\StructType\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Person value
     * @return \TurkkepEFatura\StructType\PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \TurkkepEFatura\StructType\PersonType $person
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setPerson(\TurkkepEFatura\StructType\PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get AgentParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }
    /**
     * Set AgentParty value
     * @param \TurkkepEFatura\StructType\PartyType $agentParty
     * @return \TurkkepEFatura\StructType\PartyType
     */
    public function setAgentParty(\TurkkepEFatura\StructType\PartyType $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
}
