<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OkcRapor StructType
 * @subpackage Structs
 */
class OkcRapor extends AbstractStructBase
{
    /**
     * The ToplamTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamTutar;
    /**
     * The ToplamKdv
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToplamKdv;
    /**
     * The BolumNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BolumNo;
    /**
     * The DonemBaslangicDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DonemBaslangicDate;
    /**
     * The DonemBitisDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DonemBitisDate;
    /**
     * The BolumBaslangicDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BolumBaslangicDate;
    /**
     * The BolumBitisDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BolumBitisDate;
    /**
     * The OkcSicilNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OkcSicilNo;
    /**
     * Constructor method for OkcRapor
     * @uses OkcRapor::setToplamTutar()
     * @uses OkcRapor::setToplamKdv()
     * @uses OkcRapor::setBolumNo()
     * @uses OkcRapor::setDonemBaslangicDate()
     * @uses OkcRapor::setDonemBitisDate()
     * @uses OkcRapor::setBolumBaslangicDate()
     * @uses OkcRapor::setBolumBitisDate()
     * @uses OkcRapor::setOkcSicilNo()
     * @param float $toplamTutar
     * @param float $toplamKdv
     * @param int $bolumNo
     * @param string $donemBaslangicDate
     * @param string $donemBitisDate
     * @param string $bolumBaslangicDate
     * @param string $bolumBitisDate
     * @param string $okcSicilNo
     */
    public function __construct($toplamTutar = null, $toplamKdv = null, $bolumNo = null, $donemBaslangicDate = null, $donemBitisDate = null, $bolumBaslangicDate = null, $bolumBitisDate = null, $okcSicilNo = null)
    {
        $this
            ->setToplamTutar($toplamTutar)
            ->setToplamKdv($toplamKdv)
            ->setBolumNo($bolumNo)
            ->setDonemBaslangicDate($donemBaslangicDate)
            ->setDonemBitisDate($donemBitisDate)
            ->setBolumBaslangicDate($bolumBaslangicDate)
            ->setBolumBitisDate($bolumBitisDate)
            ->setOkcSicilNo($okcSicilNo);
    }
    /**
     * Get ToplamTutar value
     * @return float
     */
    public function getToplamTutar()
    {
        return $this->ToplamTutar;
    }
    /**
     * Set ToplamTutar value
     * @param float $toplamTutar
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setToplamTutar($toplamTutar = null)
    {
        // validation for constraint: float
        if (!is_null($toplamTutar) && !(is_float($toplamTutar) || is_numeric($toplamTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamTutar, true), gettype($toplamTutar)), __LINE__);
        }
        $this->ToplamTutar = $toplamTutar;
        return $this;
    }
    /**
     * Get ToplamKdv value
     * @return float
     */
    public function getToplamKdv()
    {
        return $this->ToplamKdv;
    }
    /**
     * Set ToplamKdv value
     * @param float $toplamKdv
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setToplamKdv($toplamKdv = null)
    {
        // validation for constraint: float
        if (!is_null($toplamKdv) && !(is_float($toplamKdv) || is_numeric($toplamKdv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamKdv, true), gettype($toplamKdv)), __LINE__);
        }
        $this->ToplamKdv = $toplamKdv;
        return $this;
    }
    /**
     * Get BolumNo value
     * @return int
     */
    public function getBolumNo()
    {
        return $this->BolumNo;
    }
    /**
     * Set BolumNo value
     * @param int $bolumNo
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setBolumNo($bolumNo = null)
    {
        // validation for constraint: int
        if (!is_null($bolumNo) && !(is_int($bolumNo) || ctype_digit($bolumNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bolumNo, true), gettype($bolumNo)), __LINE__);
        }
        $this->BolumNo = $bolumNo;
        return $this;
    }
    /**
     * Get DonemBaslangicDate value
     * @return string
     */
    public function getDonemBaslangicDate()
    {
        return $this->DonemBaslangicDate;
    }
    /**
     * Set DonemBaslangicDate value
     * @param string $donemBaslangicDate
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setDonemBaslangicDate($donemBaslangicDate = null)
    {
        // validation for constraint: string
        if (!is_null($donemBaslangicDate) && !is_string($donemBaslangicDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donemBaslangicDate, true), gettype($donemBaslangicDate)), __LINE__);
        }
        $this->DonemBaslangicDate = $donemBaslangicDate;
        return $this;
    }
    /**
     * Get DonemBitisDate value
     * @return string
     */
    public function getDonemBitisDate()
    {
        return $this->DonemBitisDate;
    }
    /**
     * Set DonemBitisDate value
     * @param string $donemBitisDate
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setDonemBitisDate($donemBitisDate = null)
    {
        // validation for constraint: string
        if (!is_null($donemBitisDate) && !is_string($donemBitisDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donemBitisDate, true), gettype($donemBitisDate)), __LINE__);
        }
        $this->DonemBitisDate = $donemBitisDate;
        return $this;
    }
    /**
     * Get BolumBaslangicDate value
     * @return string
     */
    public function getBolumBaslangicDate()
    {
        return $this->BolumBaslangicDate;
    }
    /**
     * Set BolumBaslangicDate value
     * @param string $bolumBaslangicDate
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setBolumBaslangicDate($bolumBaslangicDate = null)
    {
        // validation for constraint: string
        if (!is_null($bolumBaslangicDate) && !is_string($bolumBaslangicDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bolumBaslangicDate, true), gettype($bolumBaslangicDate)), __LINE__);
        }
        $this->BolumBaslangicDate = $bolumBaslangicDate;
        return $this;
    }
    /**
     * Get BolumBitisDate value
     * @return string
     */
    public function getBolumBitisDate()
    {
        return $this->BolumBitisDate;
    }
    /**
     * Set BolumBitisDate value
     * @param string $bolumBitisDate
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setBolumBitisDate($bolumBitisDate = null)
    {
        // validation for constraint: string
        if (!is_null($bolumBitisDate) && !is_string($bolumBitisDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bolumBitisDate, true), gettype($bolumBitisDate)), __LINE__);
        }
        $this->BolumBitisDate = $bolumBitisDate;
        return $this;
    }
    /**
     * Get OkcSicilNo value
     * @return string|null
     */
    public function getOkcSicilNo()
    {
        return $this->OkcSicilNo;
    }
    /**
     * Set OkcSicilNo value
     * @param string $okcSicilNo
     * @return \TurkkepEFatura\StructType\OkcRapor
     */
    public function setOkcSicilNo($okcSicilNo = null)
    {
        // validation for constraint: string
        if (!is_null($okcSicilNo) && !is_string($okcSicilNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okcSicilNo, true), gettype($okcSicilNo)), __LINE__);
        }
        $this->OkcSicilNo = $okcSicilNo;
        return $this;
    }
}
