<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryTotalType StructType
 * @subpackage Structs
 */
class MonetaryTotalType extends AbstractStructBase
{
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LineExtensionAmount
     * @var \TurkkepEFatura\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxExclusiveAmount
     * @var \TurkkepEFatura\StructType\TaxExclusiveAmountType
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TaxInclusiveAmount
     * @var \TurkkepEFatura\StructType\TaxInclusiveAmountType
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:AllowanceTotalAmount
     * @var \TurkkepEFatura\StructType\AllowanceTotalAmountType
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ChargeTotalAmount
     * @var \TurkkepEFatura\StructType\ChargeTotalAmountType
     */
    public $ChargeTotalAmount;
    /**
     * The PayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PayableRoundingAmount
     * @var \TurkkepEFatura\StructType\PayableRoundingAmountType
     */
    public $PayableRoundingAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:PayableAmount
     * @var \TurkkepEFatura\StructType\PayableAmountType
     */
    public $PayableAmount;
    /**
     * Constructor method for MonetaryTotalType
     * @uses MonetaryTotalType::setLineExtensionAmount()
     * @uses MonetaryTotalType::setTaxExclusiveAmount()
     * @uses MonetaryTotalType::setTaxInclusiveAmount()
     * @uses MonetaryTotalType::setAllowanceTotalAmount()
     * @uses MonetaryTotalType::setChargeTotalAmount()
     * @uses MonetaryTotalType::setPayableRoundingAmount()
     * @uses MonetaryTotalType::setPayableAmount()
     * @param \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \TurkkepEFatura\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @param \TurkkepEFatura\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @param \TurkkepEFatura\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @param \TurkkepEFatura\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @param \TurkkepEFatura\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @param \TurkkepEFatura\StructType\PayableAmountType $payableAmount
     */
    public function __construct(\TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount = null, \TurkkepEFatura\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null, \TurkkepEFatura\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null, \TurkkepEFatura\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null, \TurkkepEFatura\StructType\ChargeTotalAmountType $chargeTotalAmount = null, \TurkkepEFatura\StructType\PayableRoundingAmountType $payableRoundingAmount = null, \TurkkepEFatura\StructType\PayableAmountType $payableAmount = null)
    {
        $this
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setPayableRoundingAmount($payableRoundingAmount)
            ->setPayableAmount($payableAmount);
    }
    /**
     * Get LineExtensionAmount value
     * @return \TurkkepEFatura\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setLineExtensionAmount(\TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return \TurkkepEFatura\StructType\TaxExclusiveAmountType|null
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param \TurkkepEFatura\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setTaxExclusiveAmount(\TurkkepEFatura\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get TaxInclusiveAmount value
     * @return \TurkkepEFatura\StructType\TaxInclusiveAmountType|null
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }
    /**
     * Set TaxInclusiveAmount value
     * @param \TurkkepEFatura\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setTaxInclusiveAmount(\TurkkepEFatura\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null)
    {
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return \TurkkepEFatura\StructType\AllowanceTotalAmountType|null
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param \TurkkepEFatura\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setAllowanceTotalAmount(\TurkkepEFatura\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null)
    {
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return \TurkkepEFatura\StructType\ChargeTotalAmountType|null
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param \TurkkepEFatura\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setChargeTotalAmount(\TurkkepEFatura\StructType\ChargeTotalAmountType $chargeTotalAmount = null)
    {
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get PayableRoundingAmount value
     * @return \TurkkepEFatura\StructType\PayableRoundingAmountType|null
     */
    public function getPayableRoundingAmount()
    {
        return $this->PayableRoundingAmount;
    }
    /**
     * Set PayableRoundingAmount value
     * @param \TurkkepEFatura\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setPayableRoundingAmount(\TurkkepEFatura\StructType\PayableRoundingAmountType $payableRoundingAmount = null)
    {
        $this->PayableRoundingAmount = $payableRoundingAmount;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return \TurkkepEFatura\StructType\PayableAmountType|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param \TurkkepEFatura\StructType\PayableAmountType $payableAmount
     * @return \TurkkepEFatura\StructType\MonetaryTotalType
     */
    public function setPayableAmount(\TurkkepEFatura\StructType\PayableAmountType $payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
}
