<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransportType StructType
 * @subpackage Structs
 */
class MaritimeTransportType extends AbstractStructBase
{
    /**
     * The VesselID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:VesselID
     * @var \TurkkepEFatura\StructType\VesselIDType
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:VesselName
     * @var \TurkkepEFatura\StructType\VesselNameType
     */
    public $VesselName;
    /**
     * The RadioCallSignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:RadioCallSignID
     * @var \TurkkepEFatura\StructType\RadioCallSignIDType
     */
    public $RadioCallSignID;
    /**
     * The ShipsRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:ShipsRequirements
     * @var \TurkkepEFatura\StructType\ShipsRequirementsType[]
     */
    public $ShipsRequirements;
    /**
     * The GrossTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:GrossTonnageMeasure
     * @var \TurkkepEFatura\StructType\GrossTonnageMeasureType
     */
    public $GrossTonnageMeasure;
    /**
     * The NetTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:NetTonnageMeasure
     * @var \TurkkepEFatura\StructType\NetTonnageMeasureType
     */
    public $NetTonnageMeasure;
    /**
     * The RegistryCertificateDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public $RegistryCertificateDocumentReference;
    /**
     * The RegistryPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LocationType
     */
    public $RegistryPortLocation;
    /**
     * Constructor method for MaritimeTransportType
     * @uses MaritimeTransportType::setVesselID()
     * @uses MaritimeTransportType::setVesselName()
     * @uses MaritimeTransportType::setRadioCallSignID()
     * @uses MaritimeTransportType::setShipsRequirements()
     * @uses MaritimeTransportType::setGrossTonnageMeasure()
     * @uses MaritimeTransportType::setNetTonnageMeasure()
     * @uses MaritimeTransportType::setRegistryCertificateDocumentReference()
     * @uses MaritimeTransportType::setRegistryPortLocation()
     * @param \TurkkepEFatura\StructType\VesselIDType $vesselID
     * @param \TurkkepEFatura\StructType\VesselNameType $vesselName
     * @param \TurkkepEFatura\StructType\RadioCallSignIDType $radioCallSignID
     * @param \TurkkepEFatura\StructType\ShipsRequirementsType[] $shipsRequirements
     * @param \TurkkepEFatura\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @param \TurkkepEFatura\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @param \TurkkepEFatura\StructType\LocationType $registryPortLocation
     */
    public function __construct(\TurkkepEFatura\StructType\VesselIDType $vesselID = null, \TurkkepEFatura\StructType\VesselNameType $vesselName = null, \TurkkepEFatura\StructType\RadioCallSignIDType $radioCallSignID = null, array $shipsRequirements = array(), \TurkkepEFatura\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null, \TurkkepEFatura\StructType\NetTonnageMeasureType $netTonnageMeasure = null, \TurkkepEFatura\StructType\DocumentReferenceType $registryCertificateDocumentReference = null, \TurkkepEFatura\StructType\LocationType $registryPortLocation = null)
    {
        $this
            ->setVesselID($vesselID)
            ->setVesselName($vesselName)
            ->setRadioCallSignID($radioCallSignID)
            ->setShipsRequirements($shipsRequirements)
            ->setGrossTonnageMeasure($grossTonnageMeasure)
            ->setNetTonnageMeasure($netTonnageMeasure)
            ->setRegistryCertificateDocumentReference($registryCertificateDocumentReference)
            ->setRegistryPortLocation($registryPortLocation);
    }
    /**
     * Get VesselID value
     * @return \TurkkepEFatura\StructType\VesselIDType|null
     */
    public function getVesselID()
    {
        return $this->VesselID;
    }
    /**
     * Set VesselID value
     * @param \TurkkepEFatura\StructType\VesselIDType $vesselID
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setVesselID(\TurkkepEFatura\StructType\VesselIDType $vesselID = null)
    {
        $this->VesselID = $vesselID;
        return $this;
    }
    /**
     * Get VesselName value
     * @return \TurkkepEFatura\StructType\VesselNameType|null
     */
    public function getVesselName()
    {
        return $this->VesselName;
    }
    /**
     * Set VesselName value
     * @param \TurkkepEFatura\StructType\VesselNameType $vesselName
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setVesselName(\TurkkepEFatura\StructType\VesselNameType $vesselName = null)
    {
        $this->VesselName = $vesselName;
        return $this;
    }
    /**
     * Get RadioCallSignID value
     * @return \TurkkepEFatura\StructType\RadioCallSignIDType|null
     */
    public function getRadioCallSignID()
    {
        return $this->RadioCallSignID;
    }
    /**
     * Set RadioCallSignID value
     * @param \TurkkepEFatura\StructType\RadioCallSignIDType $radioCallSignID
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setRadioCallSignID(\TurkkepEFatura\StructType\RadioCallSignIDType $radioCallSignID = null)
    {
        $this->RadioCallSignID = $radioCallSignID;
        return $this;
    }
    /**
     * Get ShipsRequirements value
     * @return \TurkkepEFatura\StructType\ShipsRequirementsType[]|null
     */
    public function getShipsRequirements()
    {
        return $this->ShipsRequirements;
    }
    /**
     * This method is responsible for validating the values passed to the setShipsRequirements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipsRequirements method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maritimeTransportTypeShipsRequirementsItem) {
            // validation for constraint: itemType
            if (!$maritimeTransportTypeShipsRequirementsItem instanceof \TurkkepEFatura\StructType\ShipsRequirementsType) {
                $invalidValues[] = is_object($maritimeTransportTypeShipsRequirementsItem) ? get_class($maritimeTransportTypeShipsRequirementsItem) : sprintf('%s(%s)', gettype($maritimeTransportTypeShipsRequirementsItem), var_export($maritimeTransportTypeShipsRequirementsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipsRequirements property can only contain items of type \TurkkepEFatura\StructType\ShipsRequirementsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ShipsRequirementsType[] $shipsRequirements
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setShipsRequirements(array $shipsRequirements = array())
    {
        // validation for constraint: array
        if ('' !== ($shipsRequirementsArrayErrorMessage = self::validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements($shipsRequirements))) {
            throw new \InvalidArgumentException($shipsRequirementsArrayErrorMessage, __LINE__);
        }
        $this->ShipsRequirements = $shipsRequirements;
        return $this;
    }
    /**
     * Add item to ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ShipsRequirementsType $item
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function addToShipsRequirements(\TurkkepEFatura\StructType\ShipsRequirementsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ShipsRequirementsType) {
            throw new \InvalidArgumentException(sprintf('The ShipsRequirements property can only contain items of type \TurkkepEFatura\StructType\ShipsRequirementsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipsRequirements[] = $item;
        return $this;
    }
    /**
     * Get GrossTonnageMeasure value
     * @return \TurkkepEFatura\StructType\GrossTonnageMeasureType|null
     */
    public function getGrossTonnageMeasure()
    {
        return $this->GrossTonnageMeasure;
    }
    /**
     * Set GrossTonnageMeasure value
     * @param \TurkkepEFatura\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setGrossTonnageMeasure(\TurkkepEFatura\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null)
    {
        $this->GrossTonnageMeasure = $grossTonnageMeasure;
        return $this;
    }
    /**
     * Get NetTonnageMeasure value
     * @return \TurkkepEFatura\StructType\NetTonnageMeasureType|null
     */
    public function getNetTonnageMeasure()
    {
        return $this->NetTonnageMeasure;
    }
    /**
     * Set NetTonnageMeasure value
     * @param \TurkkepEFatura\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setNetTonnageMeasure(\TurkkepEFatura\StructType\NetTonnageMeasureType $netTonnageMeasure = null)
    {
        $this->NetTonnageMeasure = $netTonnageMeasure;
        return $this;
    }
    /**
     * Get RegistryCertificateDocumentReference value
     * @return \TurkkepEFatura\StructType\DocumentReferenceType|null
     */
    public function getRegistryCertificateDocumentReference()
    {
        return $this->RegistryCertificateDocumentReference;
    }
    /**
     * Set RegistryCertificateDocumentReference value
     * @param \TurkkepEFatura\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setRegistryCertificateDocumentReference(\TurkkepEFatura\StructType\DocumentReferenceType $registryCertificateDocumentReference = null)
    {
        $this->RegistryCertificateDocumentReference = $registryCertificateDocumentReference;
        return $this;
    }
    /**
     * Get RegistryPortLocation value
     * @return \TurkkepEFatura\StructType\LocationType|null
     */
    public function getRegistryPortLocation()
    {
        return $this->RegistryPortLocation;
    }
    /**
     * Set RegistryPortLocation value
     * @param \TurkkepEFatura\StructType\LocationType $registryPortLocation
     * @return \TurkkepEFatura\StructType\MaritimeTransportType
     */
    public function setRegistryPortLocation(\TurkkepEFatura\StructType\LocationType $registryPortLocation = null)
    {
        $this->RegistryPortLocation = $registryPortLocation;
        return $this;
    }
}
