<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LotIdentificationType StructType
 * @subpackage Structs
 */
class LotIdentificationType extends AbstractStructBase
{
    /**
     * The LotNumberID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LotNumberID
     * @var \TurkkepEFatura\StructType\LotNumberIDType
     */
    public $LotNumberID;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ExpiryDate
     * @var \TurkkepEFatura\StructType\ExpiryDateType
     */
    public $ExpiryDate;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * Constructor method for LotIdentificationType
     * @uses LotIdentificationType::setLotNumberID()
     * @uses LotIdentificationType::setExpiryDate()
     * @uses LotIdentificationType::setAdditionalItemProperty()
     * @param \TurkkepEFatura\StructType\LotNumberIDType $lotNumberID
     * @param \TurkkepEFatura\StructType\ExpiryDateType $expiryDate
     * @param \TurkkepEFatura\StructType\ItemPropertyType[] $additionalItemProperty
     */
    public function __construct(\TurkkepEFatura\StructType\LotNumberIDType $lotNumberID = null, \TurkkepEFatura\StructType\ExpiryDateType $expiryDate = null, array $additionalItemProperty = array())
    {
        $this
            ->setLotNumberID($lotNumberID)
            ->setExpiryDate($expiryDate)
            ->setAdditionalItemProperty($additionalItemProperty);
    }
    /**
     * Get LotNumberID value
     * @return \TurkkepEFatura\StructType\LotNumberIDType|null
     */
    public function getLotNumberID()
    {
        return $this->LotNumberID;
    }
    /**
     * Set LotNumberID value
     * @param \TurkkepEFatura\StructType\LotNumberIDType $lotNumberID
     * @return \TurkkepEFatura\StructType\LotIdentificationType
     */
    public function setLotNumberID(\TurkkepEFatura\StructType\LotNumberIDType $lotNumberID = null)
    {
        $this->LotNumberID = $lotNumberID;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return \TurkkepEFatura\StructType\ExpiryDateType|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param \TurkkepEFatura\StructType\ExpiryDateType $expiryDate
     * @return \TurkkepEFatura\StructType\LotIdentificationType
     */
    public function setExpiryDate(\TurkkepEFatura\StructType\ExpiryDateType $expiryDate = null)
    {
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \TurkkepEFatura\StructType\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lotIdentificationTypeAdditionalItemPropertyItem) {
            // validation for constraint: itemType
            if (!$lotIdentificationTypeAdditionalItemPropertyItem instanceof \TurkkepEFatura\StructType\ItemPropertyType) {
                $invalidValues[] = is_object($lotIdentificationTypeAdditionalItemPropertyItem) ? get_class($lotIdentificationTypeAdditionalItemPropertyItem) : sprintf('%s(%s)', gettype($lotIdentificationTypeAdditionalItemPropertyItem), var_export($lotIdentificationTypeAdditionalItemPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemProperty property can only contain items of type \TurkkepEFatura\StructType\ItemPropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemPropertyType[] $additionalItemProperty
     * @return \TurkkepEFatura\StructType\LotIdentificationType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemPropertyArrayErrorMessage = self::validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty($additionalItemProperty))) {
            throw new \InvalidArgumentException($additionalItemPropertyArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemPropertyType $item
     * @return \TurkkepEFatura\StructType\LotIdentificationType
     */
    public function addToAdditionalItemProperty(\TurkkepEFatura\StructType\ItemPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ItemPropertyType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemProperty property can only contain items of type \TurkkepEFatura\StructType\ItemPropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
}
