<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPropertyType StructType
 * @subpackage Structs
 */
class ItemPropertyType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Name
     * @var \TurkkepEFatura\StructType\NameType
     */
    public $Name;
    /**
     * The NameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:NameCode
     * @var \TurkkepEFatura\StructType\NameCodeType
     */
    public $NameCode;
    /**
     * The TestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TestMethod
     * @var \TurkkepEFatura\StructType\TestMethodType
     */
    public $TestMethod;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Value
     * @var \TurkkepEFatura\StructType\ValueType
     */
    public $Value;
    /**
     * The ValueQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ValueQuantity
     * @var \TurkkepEFatura\StructType\ValueQuantityType
     */
    public $ValueQuantity;
    /**
     * The ValueQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:ValueQualifier
     * @var \TurkkepEFatura\StructType\ValueQualifierType[]
     */
    public $ValueQualifier;
    /**
     * The ImportanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ImportanceCode
     * @var \TurkkepEFatura\StructType\ImportanceCodeType
     */
    public $ImportanceCode;
    /**
     * The ListValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:ListValue
     * @var \TurkkepEFatura\StructType\ListValueType[]
     */
    public $ListValue;
    /**
     * The UsabilityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PeriodType
     */
    public $UsabilityPeriod;
    /**
     * The ItemPropertyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemPropertyGroupType[]
     */
    public $ItemPropertyGroup;
    /**
     * The RangeDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType
     */
    public $RangeDimension;
    /**
     * The ItemPropertyRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemPropertyRangeType
     */
    public $ItemPropertyRange;
    /**
     * Constructor method for ItemPropertyType
     * @uses ItemPropertyType::setID()
     * @uses ItemPropertyType::setName()
     * @uses ItemPropertyType::setNameCode()
     * @uses ItemPropertyType::setTestMethod()
     * @uses ItemPropertyType::setValue()
     * @uses ItemPropertyType::setValueQuantity()
     * @uses ItemPropertyType::setValueQualifier()
     * @uses ItemPropertyType::setImportanceCode()
     * @uses ItemPropertyType::setListValue()
     * @uses ItemPropertyType::setUsabilityPeriod()
     * @uses ItemPropertyType::setItemPropertyGroup()
     * @uses ItemPropertyType::setRangeDimension()
     * @uses ItemPropertyType::setItemPropertyRange()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\NameType $name
     * @param \TurkkepEFatura\StructType\NameCodeType $nameCode
     * @param \TurkkepEFatura\StructType\TestMethodType $testMethod
     * @param \TurkkepEFatura\StructType\ValueType $value
     * @param \TurkkepEFatura\StructType\ValueQuantityType $valueQuantity
     * @param \TurkkepEFatura\StructType\ValueQualifierType[] $valueQualifier
     * @param \TurkkepEFatura\StructType\ImportanceCodeType $importanceCode
     * @param \TurkkepEFatura\StructType\ListValueType[] $listValue
     * @param \TurkkepEFatura\StructType\PeriodType $usabilityPeriod
     * @param \TurkkepEFatura\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @param \TurkkepEFatura\StructType\DimensionType $rangeDimension
     * @param \TurkkepEFatura\StructType\ItemPropertyRangeType $itemPropertyRange
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\NameType $name = null, \TurkkepEFatura\StructType\NameCodeType $nameCode = null, \TurkkepEFatura\StructType\TestMethodType $testMethod = null, \TurkkepEFatura\StructType\ValueType $value = null, \TurkkepEFatura\StructType\ValueQuantityType $valueQuantity = null, array $valueQualifier = array(), \TurkkepEFatura\StructType\ImportanceCodeType $importanceCode = null, array $listValue = array(), \TurkkepEFatura\StructType\PeriodType $usabilityPeriod = null, array $itemPropertyGroup = array(), \TurkkepEFatura\StructType\DimensionType $rangeDimension = null, \TurkkepEFatura\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setNameCode($nameCode)
            ->setTestMethod($testMethod)
            ->setValue($value)
            ->setValueQuantity($valueQuantity)
            ->setValueQualifier($valueQualifier)
            ->setImportanceCode($importanceCode)
            ->setListValue($listValue)
            ->setUsabilityPeriod($usabilityPeriod)
            ->setItemPropertyGroup($itemPropertyGroup)
            ->setRangeDimension($rangeDimension)
            ->setItemPropertyRange($itemPropertyRange);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return \TurkkepEFatura\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \TurkkepEFatura\StructType\NameType $name
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setName(\TurkkepEFatura\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameCode value
     * @return \TurkkepEFatura\StructType\NameCodeType|null
     */
    public function getNameCode()
    {
        return $this->NameCode;
    }
    /**
     * Set NameCode value
     * @param \TurkkepEFatura\StructType\NameCodeType $nameCode
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setNameCode(\TurkkepEFatura\StructType\NameCodeType $nameCode = null)
    {
        $this->NameCode = $nameCode;
        return $this;
    }
    /**
     * Get TestMethod value
     * @return \TurkkepEFatura\StructType\TestMethodType|null
     */
    public function getTestMethod()
    {
        return $this->TestMethod;
    }
    /**
     * Set TestMethod value
     * @param \TurkkepEFatura\StructType\TestMethodType $testMethod
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setTestMethod(\TurkkepEFatura\StructType\TestMethodType $testMethod = null)
    {
        $this->TestMethod = $testMethod;
        return $this;
    }
    /**
     * Get Value value
     * @return \TurkkepEFatura\StructType\ValueType|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \TurkkepEFatura\StructType\ValueType $value
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setValue(\TurkkepEFatura\StructType\ValueType $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueQuantity value
     * @return \TurkkepEFatura\StructType\ValueQuantityType|null
     */
    public function getValueQuantity()
    {
        return $this->ValueQuantity;
    }
    /**
     * Set ValueQuantity value
     * @param \TurkkepEFatura\StructType\ValueQuantityType $valueQuantity
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setValueQuantity(\TurkkepEFatura\StructType\ValueQuantityType $valueQuantity = null)
    {
        $this->ValueQuantity = $valueQuantity;
        return $this;
    }
    /**
     * Get ValueQualifier value
     * @return \TurkkepEFatura\StructType\ValueQualifierType[]|null
     */
    public function getValueQualifier()
    {
        return $this->ValueQualifier;
    }
    /**
     * This method is responsible for validating the values passed to the setValueQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValueQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueQualifierForArrayConstraintsFromSetValueQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeValueQualifierItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeValueQualifierItem instanceof \TurkkepEFatura\StructType\ValueQualifierType) {
                $invalidValues[] = is_object($itemPropertyTypeValueQualifierItem) ? get_class($itemPropertyTypeValueQualifierItem) : sprintf('%s(%s)', gettype($itemPropertyTypeValueQualifierItem), var_export($itemPropertyTypeValueQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValueQualifier property can only contain items of type \TurkkepEFatura\StructType\ValueQualifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ValueQualifierType[] $valueQualifier
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setValueQualifier(array $valueQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($valueQualifierArrayErrorMessage = self::validateValueQualifierForArrayConstraintsFromSetValueQualifier($valueQualifier))) {
            throw new \InvalidArgumentException($valueQualifierArrayErrorMessage, __LINE__);
        }
        $this->ValueQualifier = $valueQualifier;
        return $this;
    }
    /**
     * Add item to ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ValueQualifierType $item
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function addToValueQualifier(\TurkkepEFatura\StructType\ValueQualifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ValueQualifierType) {
            throw new \InvalidArgumentException(sprintf('The ValueQualifier property can only contain items of type \TurkkepEFatura\StructType\ValueQualifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValueQualifier[] = $item;
        return $this;
    }
    /**
     * Get ImportanceCode value
     * @return \TurkkepEFatura\StructType\ImportanceCodeType|null
     */
    public function getImportanceCode()
    {
        return $this->ImportanceCode;
    }
    /**
     * Set ImportanceCode value
     * @param \TurkkepEFatura\StructType\ImportanceCodeType $importanceCode
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setImportanceCode(\TurkkepEFatura\StructType\ImportanceCodeType $importanceCode = null)
    {
        $this->ImportanceCode = $importanceCode;
        return $this;
    }
    /**
     * Get ListValue value
     * @return \TurkkepEFatura\StructType\ListValueType[]|null
     */
    public function getListValue()
    {
        return $this->ListValue;
    }
    /**
     * This method is responsible for validating the values passed to the setListValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListValueForArrayConstraintsFromSetListValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeListValueItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeListValueItem instanceof \TurkkepEFatura\StructType\ListValueType) {
                $invalidValues[] = is_object($itemPropertyTypeListValueItem) ? get_class($itemPropertyTypeListValueItem) : sprintf('%s(%s)', gettype($itemPropertyTypeListValueItem), var_export($itemPropertyTypeListValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListValue property can only contain items of type \TurkkepEFatura\StructType\ListValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListValue value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ListValueType[] $listValue
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setListValue(array $listValue = array())
    {
        // validation for constraint: array
        if ('' !== ($listValueArrayErrorMessage = self::validateListValueForArrayConstraintsFromSetListValue($listValue))) {
            throw new \InvalidArgumentException($listValueArrayErrorMessage, __LINE__);
        }
        $this->ListValue = $listValue;
        return $this;
    }
    /**
     * Add item to ListValue value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ListValueType $item
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function addToListValue(\TurkkepEFatura\StructType\ListValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ListValueType) {
            throw new \InvalidArgumentException(sprintf('The ListValue property can only contain items of type \TurkkepEFatura\StructType\ListValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListValue[] = $item;
        return $this;
    }
    /**
     * Get UsabilityPeriod value
     * @return \TurkkepEFatura\StructType\PeriodType|null
     */
    public function getUsabilityPeriod()
    {
        return $this->UsabilityPeriod;
    }
    /**
     * Set UsabilityPeriod value
     * @param \TurkkepEFatura\StructType\PeriodType $usabilityPeriod
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setUsabilityPeriod(\TurkkepEFatura\StructType\PeriodType $usabilityPeriod = null)
    {
        $this->UsabilityPeriod = $usabilityPeriod;
        return $this;
    }
    /**
     * Get ItemPropertyGroup value
     * @return \TurkkepEFatura\StructType\ItemPropertyGroupType[]|null
     */
    public function getItemPropertyGroup()
    {
        return $this->ItemPropertyGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setItemPropertyGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemPropertyGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeItemPropertyGroupItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeItemPropertyGroupItem instanceof \TurkkepEFatura\StructType\ItemPropertyGroupType) {
                $invalidValues[] = is_object($itemPropertyTypeItemPropertyGroupItem) ? get_class($itemPropertyTypeItemPropertyGroupItem) : sprintf('%s(%s)', gettype($itemPropertyTypeItemPropertyGroupItem), var_export($itemPropertyTypeItemPropertyGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemPropertyGroup property can only contain items of type \TurkkepEFatura\StructType\ItemPropertyGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setItemPropertyGroup(array $itemPropertyGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($itemPropertyGroupArrayErrorMessage = self::validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup($itemPropertyGroup))) {
            throw new \InvalidArgumentException($itemPropertyGroupArrayErrorMessage, __LINE__);
        }
        $this->ItemPropertyGroup = $itemPropertyGroup;
        return $this;
    }
    /**
     * Add item to ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemPropertyGroupType $item
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function addToItemPropertyGroup(\TurkkepEFatura\StructType\ItemPropertyGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ItemPropertyGroupType) {
            throw new \InvalidArgumentException(sprintf('The ItemPropertyGroup property can only contain items of type \TurkkepEFatura\StructType\ItemPropertyGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemPropertyGroup[] = $item;
        return $this;
    }
    /**
     * Get RangeDimension value
     * @return \TurkkepEFatura\StructType\DimensionType|null
     */
    public function getRangeDimension()
    {
        return $this->RangeDimension;
    }
    /**
     * Set RangeDimension value
     * @param \TurkkepEFatura\StructType\DimensionType $rangeDimension
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setRangeDimension(\TurkkepEFatura\StructType\DimensionType $rangeDimension = null)
    {
        $this->RangeDimension = $rangeDimension;
        return $this;
    }
    /**
     * Get ItemPropertyRange value
     * @return \TurkkepEFatura\StructType\ItemPropertyRangeType|null
     */
    public function getItemPropertyRange()
    {
        return $this->ItemPropertyRange;
    }
    /**
     * Set ItemPropertyRange value
     * @param \TurkkepEFatura\StructType\ItemPropertyRangeType $itemPropertyRange
     * @return \TurkkepEFatura\StructType\ItemPropertyType
     */
    public function setItemPropertyRange(\TurkkepEFatura\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this->ItemPropertyRange = $itemPropertyRange;
        return $this;
    }
}
