<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemLocationQuantityType StructType
 * @subpackage Structs
 */
class ItemLocationQuantityType extends AbstractStructBase
{
    /**
     * The LeadTimeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LeadTimeMeasure
     * @var \TurkkepEFatura\StructType\LeadTimeMeasureType
     */
    public $LeadTimeMeasure;
    /**
     * The MinimumQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:MinimumQuantity
     * @var \TurkkepEFatura\StructType\MinimumQuantityType
     */
    public $MinimumQuantity;
    /**
     * The MaximumQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:MaximumQuantity
     * @var \TurkkepEFatura\StructType\MaximumQuantityType
     */
    public $MaximumQuantity;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HazardousRiskIndicator
     * @var \TurkkepEFatura\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TradingRestrictions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:TradingRestrictions
     * @var \TurkkepEFatura\StructType\TradingRestrictionsType[]
     */
    public $TradingRestrictions;
    /**
     * The ApplicableTerritoryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AddressType[]
     */
    public $ApplicableTerritoryAddress;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PriceType
     */
    public $Price;
    /**
     * The DeliveryUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DeliveryUnitType[]
     */
    public $DeliveryUnit;
    /**
     * The ApplicableTaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxCategoryType[]
     */
    public $ApplicableTaxCategory;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PackageType
     */
    public $Package;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The DependentPriceReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DependentPriceReferenceType
     */
    public $DependentPriceReference;
    /**
     * Constructor method for ItemLocationQuantityType
     * @uses ItemLocationQuantityType::setLeadTimeMeasure()
     * @uses ItemLocationQuantityType::setMinimumQuantity()
     * @uses ItemLocationQuantityType::setMaximumQuantity()
     * @uses ItemLocationQuantityType::setHazardousRiskIndicator()
     * @uses ItemLocationQuantityType::setTradingRestrictions()
     * @uses ItemLocationQuantityType::setApplicableTerritoryAddress()
     * @uses ItemLocationQuantityType::setPrice()
     * @uses ItemLocationQuantityType::setDeliveryUnit()
     * @uses ItemLocationQuantityType::setApplicableTaxCategory()
     * @uses ItemLocationQuantityType::setPackage()
     * @uses ItemLocationQuantityType::setAllowanceCharge()
     * @uses ItemLocationQuantityType::setDependentPriceReference()
     * @param \TurkkepEFatura\StructType\LeadTimeMeasureType $leadTimeMeasure
     * @param \TurkkepEFatura\StructType\MinimumQuantityType $minimumQuantity
     * @param \TurkkepEFatura\StructType\MaximumQuantityType $maximumQuantity
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \TurkkepEFatura\StructType\TradingRestrictionsType[] $tradingRestrictions
     * @param \TurkkepEFatura\StructType\AddressType[] $applicableTerritoryAddress
     * @param \TurkkepEFatura\StructType\PriceType $price
     * @param \TurkkepEFatura\StructType\DeliveryUnitType[] $deliveryUnit
     * @param \TurkkepEFatura\StructType\TaxCategoryType[] $applicableTaxCategory
     * @param \TurkkepEFatura\StructType\PackageType $package
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \TurkkepEFatura\StructType\DependentPriceReferenceType $dependentPriceReference
     */
    public function __construct(\TurkkepEFatura\StructType\LeadTimeMeasureType $leadTimeMeasure = null, \TurkkepEFatura\StructType\MinimumQuantityType $minimumQuantity = null, \TurkkepEFatura\StructType\MaximumQuantityType $maximumQuantity = null, \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, array $tradingRestrictions = array(), array $applicableTerritoryAddress = array(), \TurkkepEFatura\StructType\PriceType $price = null, array $deliveryUnit = array(), array $applicableTaxCategory = array(), \TurkkepEFatura\StructType\PackageType $package = null, array $allowanceCharge = array(), \TurkkepEFatura\StructType\DependentPriceReferenceType $dependentPriceReference = null)
    {
        $this
            ->setLeadTimeMeasure($leadTimeMeasure)
            ->setMinimumQuantity($minimumQuantity)
            ->setMaximumQuantity($maximumQuantity)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTradingRestrictions($tradingRestrictions)
            ->setApplicableTerritoryAddress($applicableTerritoryAddress)
            ->setPrice($price)
            ->setDeliveryUnit($deliveryUnit)
            ->setApplicableTaxCategory($applicableTaxCategory)
            ->setPackage($package)
            ->setAllowanceCharge($allowanceCharge)
            ->setDependentPriceReference($dependentPriceReference);
    }
    /**
     * Get LeadTimeMeasure value
     * @return \TurkkepEFatura\StructType\LeadTimeMeasureType|null
     */
    public function getLeadTimeMeasure()
    {
        return $this->LeadTimeMeasure;
    }
    /**
     * Set LeadTimeMeasure value
     * @param \TurkkepEFatura\StructType\LeadTimeMeasureType $leadTimeMeasure
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setLeadTimeMeasure(\TurkkepEFatura\StructType\LeadTimeMeasureType $leadTimeMeasure = null)
    {
        $this->LeadTimeMeasure = $leadTimeMeasure;
        return $this;
    }
    /**
     * Get MinimumQuantity value
     * @return \TurkkepEFatura\StructType\MinimumQuantityType|null
     */
    public function getMinimumQuantity()
    {
        return $this->MinimumQuantity;
    }
    /**
     * Set MinimumQuantity value
     * @param \TurkkepEFatura\StructType\MinimumQuantityType $minimumQuantity
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setMinimumQuantity(\TurkkepEFatura\StructType\MinimumQuantityType $minimumQuantity = null)
    {
        $this->MinimumQuantity = $minimumQuantity;
        return $this;
    }
    /**
     * Get MaximumQuantity value
     * @return \TurkkepEFatura\StructType\MaximumQuantityType|null
     */
    public function getMaximumQuantity()
    {
        return $this->MaximumQuantity;
    }
    /**
     * Set MaximumQuantity value
     * @param \TurkkepEFatura\StructType\MaximumQuantityType $maximumQuantity
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setMaximumQuantity(\TurkkepEFatura\StructType\MaximumQuantityType $maximumQuantity = null)
    {
        $this->MaximumQuantity = $maximumQuantity;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \TurkkepEFatura\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setHazardousRiskIndicator(\TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get TradingRestrictions value
     * @return \TurkkepEFatura\StructType\TradingRestrictionsType[]|null
     */
    public function getTradingRestrictions()
    {
        return $this->TradingRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setTradingRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTradingRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTradingRestrictionsForArrayConstraintsFromSetTradingRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemLocationQuantityTypeTradingRestrictionsItem) {
            // validation for constraint: itemType
            if (!$itemLocationQuantityTypeTradingRestrictionsItem instanceof \TurkkepEFatura\StructType\TradingRestrictionsType) {
                $invalidValues[] = is_object($itemLocationQuantityTypeTradingRestrictionsItem) ? get_class($itemLocationQuantityTypeTradingRestrictionsItem) : sprintf('%s(%s)', gettype($itemLocationQuantityTypeTradingRestrictionsItem), var_export($itemLocationQuantityTypeTradingRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TradingRestrictions property can only contain items of type \TurkkepEFatura\StructType\TradingRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TradingRestrictions value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TradingRestrictionsType[] $tradingRestrictions
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setTradingRestrictions(array $tradingRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($tradingRestrictionsArrayErrorMessage = self::validateTradingRestrictionsForArrayConstraintsFromSetTradingRestrictions($tradingRestrictions))) {
            throw new \InvalidArgumentException($tradingRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->TradingRestrictions = $tradingRestrictions;
        return $this;
    }
    /**
     * Add item to TradingRestrictions value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TradingRestrictionsType $item
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function addToTradingRestrictions(\TurkkepEFatura\StructType\TradingRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TradingRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The TradingRestrictions property can only contain items of type \TurkkepEFatura\StructType\TradingRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TradingRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ApplicableTerritoryAddress value
     * @return \TurkkepEFatura\StructType\AddressType[]|null
     */
    public function getApplicableTerritoryAddress()
    {
        return $this->ApplicableTerritoryAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicableTerritoryAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicableTerritoryAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicableTerritoryAddressForArrayConstraintsFromSetApplicableTerritoryAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemLocationQuantityTypeApplicableTerritoryAddressItem) {
            // validation for constraint: itemType
            if (!$itemLocationQuantityTypeApplicableTerritoryAddressItem instanceof \TurkkepEFatura\StructType\AddressType) {
                $invalidValues[] = is_object($itemLocationQuantityTypeApplicableTerritoryAddressItem) ? get_class($itemLocationQuantityTypeApplicableTerritoryAddressItem) : sprintf('%s(%s)', gettype($itemLocationQuantityTypeApplicableTerritoryAddressItem), var_export($itemLocationQuantityTypeApplicableTerritoryAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ApplicableTerritoryAddress property can only contain items of type \TurkkepEFatura\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ApplicableTerritoryAddress value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AddressType[] $applicableTerritoryAddress
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setApplicableTerritoryAddress(array $applicableTerritoryAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($applicableTerritoryAddressArrayErrorMessage = self::validateApplicableTerritoryAddressForArrayConstraintsFromSetApplicableTerritoryAddress($applicableTerritoryAddress))) {
            throw new \InvalidArgumentException($applicableTerritoryAddressArrayErrorMessage, __LINE__);
        }
        $this->ApplicableTerritoryAddress = $applicableTerritoryAddress;
        return $this;
    }
    /**
     * Add item to ApplicableTerritoryAddress value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AddressType $item
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function addToApplicableTerritoryAddress(\TurkkepEFatura\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The ApplicableTerritoryAddress property can only contain items of type \TurkkepEFatura\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ApplicableTerritoryAddress[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \TurkkepEFatura\StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \TurkkepEFatura\StructType\PriceType $price
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setPrice(\TurkkepEFatura\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get DeliveryUnit value
     * @return \TurkkepEFatura\StructType\DeliveryUnitType[]|null
     */
    public function getDeliveryUnit()
    {
        return $this->DeliveryUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryUnitForArrayConstraintsFromSetDeliveryUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemLocationQuantityTypeDeliveryUnitItem) {
            // validation for constraint: itemType
            if (!$itemLocationQuantityTypeDeliveryUnitItem instanceof \TurkkepEFatura\StructType\DeliveryUnitType) {
                $invalidValues[] = is_object($itemLocationQuantityTypeDeliveryUnitItem) ? get_class($itemLocationQuantityTypeDeliveryUnitItem) : sprintf('%s(%s)', gettype($itemLocationQuantityTypeDeliveryUnitItem), var_export($itemLocationQuantityTypeDeliveryUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryUnit property can only contain items of type \TurkkepEFatura\StructType\DeliveryUnitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryUnit value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryUnitType[] $deliveryUnit
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setDeliveryUnit(array $deliveryUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryUnitArrayErrorMessage = self::validateDeliveryUnitForArrayConstraintsFromSetDeliveryUnit($deliveryUnit))) {
            throw new \InvalidArgumentException($deliveryUnitArrayErrorMessage, __LINE__);
        }
        $this->DeliveryUnit = $deliveryUnit;
        return $this;
    }
    /**
     * Add item to DeliveryUnit value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryUnitType $item
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function addToDeliveryUnit(\TurkkepEFatura\StructType\DeliveryUnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryUnitType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryUnit property can only contain items of type \TurkkepEFatura\StructType\DeliveryUnitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryUnit[] = $item;
        return $this;
    }
    /**
     * Get ApplicableTaxCategory value
     * @return \TurkkepEFatura\StructType\TaxCategoryType[]|null
     */
    public function getApplicableTaxCategory()
    {
        return $this->ApplicableTaxCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicableTaxCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicableTaxCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicableTaxCategoryForArrayConstraintsFromSetApplicableTaxCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemLocationQuantityTypeApplicableTaxCategoryItem) {
            // validation for constraint: itemType
            if (!$itemLocationQuantityTypeApplicableTaxCategoryItem instanceof \TurkkepEFatura\StructType\TaxCategoryType) {
                $invalidValues[] = is_object($itemLocationQuantityTypeApplicableTaxCategoryItem) ? get_class($itemLocationQuantityTypeApplicableTaxCategoryItem) : sprintf('%s(%s)', gettype($itemLocationQuantityTypeApplicableTaxCategoryItem), var_export($itemLocationQuantityTypeApplicableTaxCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ApplicableTaxCategory property can only contain items of type \TurkkepEFatura\StructType\TaxCategoryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ApplicableTaxCategory value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxCategoryType[] $applicableTaxCategory
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setApplicableTaxCategory(array $applicableTaxCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($applicableTaxCategoryArrayErrorMessage = self::validateApplicableTaxCategoryForArrayConstraintsFromSetApplicableTaxCategory($applicableTaxCategory))) {
            throw new \InvalidArgumentException($applicableTaxCategoryArrayErrorMessage, __LINE__);
        }
        $this->ApplicableTaxCategory = $applicableTaxCategory;
        return $this;
    }
    /**
     * Add item to ApplicableTaxCategory value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxCategoryType $item
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function addToApplicableTaxCategory(\TurkkepEFatura\StructType\TaxCategoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxCategoryType) {
            throw new \InvalidArgumentException(sprintf('The ApplicableTaxCategory property can only contain items of type \TurkkepEFatura\StructType\TaxCategoryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ApplicableTaxCategory[] = $item;
        return $this;
    }
    /**
     * Get Package value
     * @return \TurkkepEFatura\StructType\PackageType|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * Set Package value
     * @param \TurkkepEFatura\StructType\PackageType $package
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setPackage(\TurkkepEFatura\StructType\PackageType $package = null)
    {
        $this->Package = $package;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \TurkkepEFatura\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemLocationQuantityTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$itemLocationQuantityTypeAllowanceChargeItem instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($itemLocationQuantityTypeAllowanceChargeItem) ? get_class($itemLocationQuantityTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($itemLocationQuantityTypeAllowanceChargeItem), var_export($itemLocationQuantityTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType $item
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function addToAllowanceCharge(\TurkkepEFatura\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get DependentPriceReference value
     * @return \TurkkepEFatura\StructType\DependentPriceReferenceType|null
     */
    public function getDependentPriceReference()
    {
        return $this->DependentPriceReference;
    }
    /**
     * Set DependentPriceReference value
     * @param \TurkkepEFatura\StructType\DependentPriceReferenceType $dependentPriceReference
     * @return \TurkkepEFatura\StructType\ItemLocationQuantityType
     */
    public function setDependentPriceReference(\TurkkepEFatura\StructType\DependentPriceReferenceType $dependentPriceReference = null)
    {
        $this->DependentPriceReference = $dependentPriceReference;
        return $this;
    }
}
