<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLineType StructType
 * @subpackage Structs
 */
class InvoiceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Note
     * @var \TurkkepEFatura\StructType\NoteType[]
     */
    public $Note;
    /**
     * The InvoicedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:InvoicedQuantity
     * @var \TurkkepEFatura\StructType\InvoicedQuantityType
     */
    public $InvoicedQuantity;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:LineExtensionAmount
     * @var \TurkkepEFatura\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The OrderLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\OrderLineReferenceType[]
     */
    public $OrderLineReference;
    /**
     * The DespatchLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LineReferenceType[]
     */
    public $DespatchLineReference;
    /**
     * The ReceiptLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\LineReferenceType[]
     */
    public $ReceiptLineReference;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxTotalType
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemType
     */
    public $Item;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PriceType
     */
    public $Price;
    /**
     * The SubInvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\InvoiceLineType[]
     */
    public $SubInvoiceLine;
    /**
     * Constructor method for InvoiceLineType
     * @uses InvoiceLineType::setID()
     * @uses InvoiceLineType::setNote()
     * @uses InvoiceLineType::setInvoicedQuantity()
     * @uses InvoiceLineType::setLineExtensionAmount()
     * @uses InvoiceLineType::setOrderLineReference()
     * @uses InvoiceLineType::setDespatchLineReference()
     * @uses InvoiceLineType::setReceiptLineReference()
     * @uses InvoiceLineType::setDelivery()
     * @uses InvoiceLineType::setAllowanceCharge()
     * @uses InvoiceLineType::setTaxTotal()
     * @uses InvoiceLineType::setWithholdingTaxTotal()
     * @uses InvoiceLineType::setItem()
     * @uses InvoiceLineType::setPrice()
     * @uses InvoiceLineType::setSubInvoiceLine()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\NoteType[] $note
     * @param \TurkkepEFatura\StructType\InvoicedQuantityType $invoicedQuantity
     * @param \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \TurkkepEFatura\StructType\OrderLineReferenceType[] $orderLineReference
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $despatchLineReference
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $receiptLineReference
     * @param \TurkkepEFatura\StructType\DeliveryType[] $delivery
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \TurkkepEFatura\StructType\TaxTotalType $taxTotal
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $withholdingTaxTotal
     * @param \TurkkepEFatura\StructType\ItemType $item
     * @param \TurkkepEFatura\StructType\PriceType $price
     * @param \TurkkepEFatura\StructType\InvoiceLineType[] $subInvoiceLine
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, array $note = array(), \TurkkepEFatura\StructType\InvoicedQuantityType $invoicedQuantity = null, \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount = null, array $orderLineReference = array(), array $despatchLineReference = array(), array $receiptLineReference = array(), array $delivery = array(), array $allowanceCharge = array(), \TurkkepEFatura\StructType\TaxTotalType $taxTotal = null, array $withholdingTaxTotal = array(), \TurkkepEFatura\StructType\ItemType $item = null, \TurkkepEFatura\StructType\PriceType $price = null, array $subInvoiceLine = array())
    {
        $this
            ->setID($iD)
            ->setNote($note)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setOrderLineReference($orderLineReference)
            ->setDespatchLineReference($despatchLineReference)
            ->setReceiptLineReference($receiptLineReference)
            ->setDelivery($delivery)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setItem($item)
            ->setPrice($price)
            ->setSubInvoiceLine($subInvoiceLine);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Note value
     * @return \TurkkepEFatura\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeNoteItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeNoteItem instanceof \TurkkepEFatura\StructType\NoteType) {
                $invalidValues[] = is_object($invoiceLineTypeNoteItem) ? get_class($invoiceLineTypeNoteItem) : sprintf('%s(%s)', gettype($invoiceLineTypeNoteItem), var_export($invoiceLineTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \TurkkepEFatura\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\NoteType[] $note
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\NoteType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToNote(\TurkkepEFatura\StructType\NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\NoteType) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of type \TurkkepEFatura\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get InvoicedQuantity value
     * @return \TurkkepEFatura\StructType\InvoicedQuantityType|null
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }
    /**
     * Set InvoicedQuantity value
     * @param \TurkkepEFatura\StructType\InvoicedQuantityType $invoicedQuantity
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setInvoicedQuantity(\TurkkepEFatura\StructType\InvoicedQuantityType $invoicedQuantity = null)
    {
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * @return \TurkkepEFatura\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setLineExtensionAmount(\TurkkepEFatura\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get OrderLineReference value
     * @return \TurkkepEFatura\StructType\OrderLineReferenceType[]|null
     */
    public function getOrderLineReference()
    {
        return $this->OrderLineReference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderLineReferenceForArrayConstraintsFromSetOrderLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeOrderLineReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeOrderLineReferenceItem instanceof \TurkkepEFatura\StructType\OrderLineReferenceType) {
                $invalidValues[] = is_object($invoiceLineTypeOrderLineReferenceItem) ? get_class($invoiceLineTypeOrderLineReferenceItem) : sprintf('%s(%s)', gettype($invoiceLineTypeOrderLineReferenceItem), var_export($invoiceLineTypeOrderLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderLineReference property can only contain items of type \TurkkepEFatura\StructType\OrderLineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\OrderLineReferenceType[] $orderLineReference
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setOrderLineReference(array $orderLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($orderLineReferenceArrayErrorMessage = self::validateOrderLineReferenceForArrayConstraintsFromSetOrderLineReference($orderLineReference))) {
            throw new \InvalidArgumentException($orderLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->OrderLineReference = $orderLineReference;
        return $this;
    }
    /**
     * Add item to OrderLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\OrderLineReferenceType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToOrderLineReference(\TurkkepEFatura\StructType\OrderLineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\OrderLineReferenceType) {
            throw new \InvalidArgumentException(sprintf('The OrderLineReference property can only contain items of type \TurkkepEFatura\StructType\OrderLineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderLineReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchLineReference value
     * @return \TurkkepEFatura\StructType\LineReferenceType[]|null
     */
    public function getDespatchLineReference()
    {
        return $this->DespatchLineReference;
    }
    /**
     * This method is responsible for validating the values passed to the setDespatchLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchLineReferenceForArrayConstraintsFromSetDespatchLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeDespatchLineReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeDespatchLineReferenceItem instanceof \TurkkepEFatura\StructType\LineReferenceType) {
                $invalidValues[] = is_object($invoiceLineTypeDespatchLineReferenceItem) ? get_class($invoiceLineTypeDespatchLineReferenceItem) : sprintf('%s(%s)', gettype($invoiceLineTypeDespatchLineReferenceItem), var_export($invoiceLineTypeDespatchLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DespatchLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $despatchLineReference
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setDespatchLineReference(array $despatchLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchLineReferenceArrayErrorMessage = self::validateDespatchLineReferenceForArrayConstraintsFromSetDespatchLineReference($despatchLineReference))) {
            throw new \InvalidArgumentException($despatchLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchLineReference = $despatchLineReference;
        return $this;
    }
    /**
     * Add item to DespatchLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToDespatchLineReference(\TurkkepEFatura\StructType\LineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\LineReferenceType) {
            throw new \InvalidArgumentException(sprintf('The DespatchLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchLineReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptLineReference value
     * @return \TurkkepEFatura\StructType\LineReferenceType[]|null
     */
    public function getReceiptLineReference()
    {
        return $this->ReceiptLineReference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiptLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptLineReferenceForArrayConstraintsFromSetReceiptLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeReceiptLineReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeReceiptLineReferenceItem instanceof \TurkkepEFatura\StructType\LineReferenceType) {
                $invalidValues[] = is_object($invoiceLineTypeReceiptLineReferenceItem) ? get_class($invoiceLineTypeReceiptLineReferenceItem) : sprintf('%s(%s)', gettype($invoiceLineTypeReceiptLineReferenceItem), var_export($invoiceLineTypeReceiptLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiptLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType[] $receiptLineReference
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setReceiptLineReference(array $receiptLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptLineReferenceArrayErrorMessage = self::validateReceiptLineReferenceForArrayConstraintsFromSetReceiptLineReference($receiptLineReference))) {
            throw new \InvalidArgumentException($receiptLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptLineReference = $receiptLineReference;
        return $this;
    }
    /**
     * Add item to ReceiptLineReference value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\LineReferenceType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToReceiptLineReference(\TurkkepEFatura\StructType\LineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\LineReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ReceiptLineReference property can only contain items of type \TurkkepEFatura\StructType\LineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptLineReference[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \TurkkepEFatura\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeDeliveryItem instanceof \TurkkepEFatura\StructType\DeliveryType) {
                $invalidValues[] = is_object($invoiceLineTypeDeliveryItem) ? get_class($invoiceLineTypeDeliveryItem) : sprintf('%s(%s)', gettype($invoiceLineTypeDeliveryItem), var_export($invoiceLineTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \TurkkepEFatura\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivery value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryType[] $delivery
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new \InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DeliveryType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToDelivery(\TurkkepEFatura\StructType\DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DeliveryType) {
            throw new \InvalidArgumentException(sprintf('The Delivery property can only contain items of type \TurkkepEFatura\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \TurkkepEFatura\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeAllowanceChargeItem instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($invoiceLineTypeAllowanceChargeItem) ? get_class($invoiceLineTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($invoiceLineTypeAllowanceChargeItem), var_export($invoiceLineTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToAllowanceCharge(\TurkkepEFatura\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \TurkkepEFatura\StructType\TaxTotalType|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \TurkkepEFatura\StructType\TaxTotalType $taxTotal
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setTaxTotal(\TurkkepEFatura\StructType\TaxTotalType $taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \TurkkepEFatura\StructType\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholdingTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeWithholdingTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeWithholdingTaxTotalItem instanceof \TurkkepEFatura\StructType\TaxTotalType) {
                $invalidValues[] = is_object($invoiceLineTypeWithholdingTaxTotalItem) ? get_class($invoiceLineTypeWithholdingTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceLineTypeWithholdingTaxTotalItem), var_export($invoiceLineTypeWithholdingTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType[] $withholdingTaxTotal
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxTotalArrayErrorMessage = self::validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal($withholdingTaxTotal))) {
            throw new \InvalidArgumentException($withholdingTaxTotalArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxTotalType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToWithholdingTaxTotal(\TurkkepEFatura\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The WithholdingTaxTotal property can only contain items of type \TurkkepEFatura\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get Item value
     * @return \TurkkepEFatura\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \TurkkepEFatura\StructType\ItemType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setItem(\TurkkepEFatura\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \TurkkepEFatura\StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \TurkkepEFatura\StructType\PriceType $price
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setPrice(\TurkkepEFatura\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SubInvoiceLine value
     * @return \TurkkepEFatura\StructType\InvoiceLineType[]|null
     */
    public function getSubInvoiceLine()
    {
        return $this->SubInvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setSubInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubInvoiceLineForArrayConstraintsFromSetSubInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeSubInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeSubInvoiceLineItem instanceof \TurkkepEFatura\StructType\InvoiceLineType) {
                $invalidValues[] = is_object($invoiceLineTypeSubInvoiceLineItem) ? get_class($invoiceLineTypeSubInvoiceLineItem) : sprintf('%s(%s)', gettype($invoiceLineTypeSubInvoiceLineItem), var_export($invoiceLineTypeSubInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubInvoiceLine property can only contain items of type \TurkkepEFatura\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubInvoiceLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\InvoiceLineType[] $subInvoiceLine
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function setSubInvoiceLine(array $subInvoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($subInvoiceLineArrayErrorMessage = self::validateSubInvoiceLineForArrayConstraintsFromSetSubInvoiceLine($subInvoiceLine))) {
            throw new \InvalidArgumentException($subInvoiceLineArrayErrorMessage, __LINE__);
        }
        $this->SubInvoiceLine = $subInvoiceLine;
        return $this;
    }
    /**
     * Add item to SubInvoiceLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\InvoiceLineType $item
     * @return \TurkkepEFatura\StructType\InvoiceLineType
     */
    public function addToSubInvoiceLine(\TurkkepEFatura\StructType\InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\InvoiceLineType) {
            throw new \InvalidArgumentException(sprintf('The SubInvoiceLine property can only contain items of type \TurkkepEFatura\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubInvoiceLine[] = $item;
        return $this;
    }
}
