<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternetDetail StructType
 * @subpackage Structs
 */
class InternetDetail extends AbstractStructBase
{
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentMethod;
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The SendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SendDate;
    /**
     * The DeliveryTaxNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DeliveryTaxNo;
    /**
     * The WebAdress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAdress;
    /**
     * The OtherPaymentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherPaymentDescription;
    /**
     * The PaymentSupplierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentSupplierName;
    /**
     * The DeliveryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryName;
    /**
     * Constructor method for InternetDetail
     * @uses InternetDetail::setPaymentMethod()
     * @uses InternetDetail::setPaymentDate()
     * @uses InternetDetail::setSendDate()
     * @uses InternetDetail::setDeliveryTaxNo()
     * @uses InternetDetail::setWebAdress()
     * @uses InternetDetail::setOtherPaymentDescription()
     * @uses InternetDetail::setPaymentSupplierName()
     * @uses InternetDetail::setDeliveryName()
     * @param int $paymentMethod
     * @param string $paymentDate
     * @param string $sendDate
     * @param int $deliveryTaxNo
     * @param string $webAdress
     * @param string $otherPaymentDescription
     * @param string $paymentSupplierName
     * @param string $deliveryName
     */
    public function __construct($paymentMethod = null, $paymentDate = null, $sendDate = null, $deliveryTaxNo = null, $webAdress = null, $otherPaymentDescription = null, $paymentSupplierName = null, $deliveryName = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setPaymentDate($paymentDate)
            ->setSendDate($sendDate)
            ->setDeliveryTaxNo($deliveryTaxNo)
            ->setWebAdress($webAdress)
            ->setOtherPaymentDescription($otherPaymentDescription)
            ->setPaymentSupplierName($paymentSupplierName)
            ->setDeliveryName($deliveryName);
    }
    /**
     * Get PaymentMethod value
     * @return int
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param int $paymentMethod
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMethod) && !(is_int($paymentMethod) || ctype_digit($paymentMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get SendDate value
     * @return string
     */
    public function getSendDate()
    {
        return $this->SendDate;
    }
    /**
     * Set SendDate value
     * @param string $sendDate
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setSendDate($sendDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendDate) && !is_string($sendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendDate, true), gettype($sendDate)), __LINE__);
        }
        $this->SendDate = $sendDate;
        return $this;
    }
    /**
     * Get DeliveryTaxNo value
     * @return int
     */
    public function getDeliveryTaxNo()
    {
        return $this->DeliveryTaxNo;
    }
    /**
     * Set DeliveryTaxNo value
     * @param int $deliveryTaxNo
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setDeliveryTaxNo($deliveryTaxNo = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryTaxNo) && !(is_int($deliveryTaxNo) || ctype_digit($deliveryTaxNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryTaxNo, true), gettype($deliveryTaxNo)), __LINE__);
        }
        $this->DeliveryTaxNo = $deliveryTaxNo;
        return $this;
    }
    /**
     * Get WebAdress value
     * @return string|null
     */
    public function getWebAdress()
    {
        return $this->WebAdress;
    }
    /**
     * Set WebAdress value
     * @param string $webAdress
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setWebAdress($webAdress = null)
    {
        // validation for constraint: string
        if (!is_null($webAdress) && !is_string($webAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAdress, true), gettype($webAdress)), __LINE__);
        }
        $this->WebAdress = $webAdress;
        return $this;
    }
    /**
     * Get OtherPaymentDescription value
     * @return string|null
     */
    public function getOtherPaymentDescription()
    {
        return $this->OtherPaymentDescription;
    }
    /**
     * Set OtherPaymentDescription value
     * @param string $otherPaymentDescription
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setOtherPaymentDescription($otherPaymentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($otherPaymentDescription) && !is_string($otherPaymentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherPaymentDescription, true), gettype($otherPaymentDescription)), __LINE__);
        }
        $this->OtherPaymentDescription = $otherPaymentDescription;
        return $this;
    }
    /**
     * Get PaymentSupplierName value
     * @return string|null
     */
    public function getPaymentSupplierName()
    {
        return $this->PaymentSupplierName;
    }
    /**
     * Set PaymentSupplierName value
     * @param string $paymentSupplierName
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setPaymentSupplierName($paymentSupplierName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSupplierName) && !is_string($paymentSupplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSupplierName, true), gettype($paymentSupplierName)), __LINE__);
        }
        $this->PaymentSupplierName = $paymentSupplierName;
        return $this;
    }
    /**
     * Get DeliveryName value
     * @return string|null
     */
    public function getDeliveryName()
    {
        return $this->DeliveryName;
    }
    /**
     * Set DeliveryName value
     * @param string $deliveryName
     * @return \TurkkepEFatura\StructType\InternetDetail
     */
    public function setDeliveryName($deliveryName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryName) && !is_string($deliveryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryName, true), gettype($deliveryName)), __LINE__);
        }
        $this->DeliveryName = $deliveryName;
        return $this;
    }
}
