<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemType StructType
 * @subpackage Structs
 */
class GoodsItemType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:Description
     * @var \TurkkepEFatura\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:HazardousRiskIndicator
     * @var \TurkkepEFatura\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DeclaredCustomsValueAmount
     * @var \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DeclaredForCarriageValueAmount
     * @var \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DeclaredStatisticsValueAmount
     * @var \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:FreeOnBoardValueAmount
     * @var \TurkkepEFatura\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:InsuranceValueAmount
     * @var \TurkkepEFatura\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ValueAmount
     * @var \TurkkepEFatura\StructType\ValueAmountType
     */
    public $ValueAmount;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:GrossWeightMeasure
     * @var \TurkkepEFatura\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:NetWeightMeasure
     * @var \TurkkepEFatura\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The ChargeableWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ChargeableWeightMeasure
     * @var \TurkkepEFatura\StructType\ChargeableWeightMeasureType
     */
    public $ChargeableWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:GrossVolumeMeasure
     * @var \TurkkepEFatura\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:NetVolumeMeasure
     * @var \TurkkepEFatura\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:Quantity
     * @var \TurkkepEFatura\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:RequiredCustomsID
     * @var \TurkkepEFatura\StructType\RequiredCustomsIDType
     */
    public $RequiredCustomsID;
    /**
     * The CustomsStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CustomsStatusCode
     * @var \TurkkepEFatura\StructType\CustomsStatusCodeType
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CustomsTariffQuantity
     * @var \TurkkepEFatura\StructType\CustomsTariffQuantityType
     */
    public $CustomsTariffQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:CustomsImportClassifiedIndicator
     * @var \TurkkepEFatura\StructType\CustomsImportClassifiedIndicatorType
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The ChargeableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ChargeableQuantity
     * @var \TurkkepEFatura\StructType\ChargeableQuantityType
     */
    public $ChargeableQuantity;
    /**
     * The ReturnableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ReturnableQuantity
     * @var \TurkkepEFatura\StructType\ReturnableQuantityType
     */
    public $ReturnableQuantity;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:TraceID
     * @var \TurkkepEFatura\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\ItemType[]
     */
    public $Item;
    /**
     * The FreightAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AllowanceChargeType[]
     */
    public $FreightAllowanceCharge;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\TemperatureType[]
     */
    public $Temperature;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AddressType
     */
    public $OriginAddress;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for GoodsItemType
     * @uses GoodsItemType::setID()
     * @uses GoodsItemType::setDescription()
     * @uses GoodsItemType::setHazardousRiskIndicator()
     * @uses GoodsItemType::setDeclaredCustomsValueAmount()
     * @uses GoodsItemType::setDeclaredForCarriageValueAmount()
     * @uses GoodsItemType::setDeclaredStatisticsValueAmount()
     * @uses GoodsItemType::setFreeOnBoardValueAmount()
     * @uses GoodsItemType::setInsuranceValueAmount()
     * @uses GoodsItemType::setValueAmount()
     * @uses GoodsItemType::setGrossWeightMeasure()
     * @uses GoodsItemType::setNetWeightMeasure()
     * @uses GoodsItemType::setChargeableWeightMeasure()
     * @uses GoodsItemType::setGrossVolumeMeasure()
     * @uses GoodsItemType::setNetVolumeMeasure()
     * @uses GoodsItemType::setQuantity()
     * @uses GoodsItemType::setRequiredCustomsID()
     * @uses GoodsItemType::setCustomsStatusCode()
     * @uses GoodsItemType::setCustomsTariffQuantity()
     * @uses GoodsItemType::setCustomsImportClassifiedIndicator()
     * @uses GoodsItemType::setChargeableQuantity()
     * @uses GoodsItemType::setReturnableQuantity()
     * @uses GoodsItemType::setTraceID()
     * @uses GoodsItemType::setItem()
     * @uses GoodsItemType::setFreightAllowanceCharge()
     * @uses GoodsItemType::setInvoiceLine()
     * @uses GoodsItemType::setTemperature()
     * @uses GoodsItemType::setOriginAddress()
     * @uses GoodsItemType::setMeasurementDimension()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\DescriptionType[] $description
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \TurkkepEFatura\StructType\ValueAmountType $valueAmount
     * @param \TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \TurkkepEFatura\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @param \TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \TurkkepEFatura\StructType\QuantityType $quantity
     * @param \TurkkepEFatura\StructType\RequiredCustomsIDType $requiredCustomsID
     * @param \TurkkepEFatura\StructType\CustomsStatusCodeType $customsStatusCode
     * @param \TurkkepEFatura\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @param \TurkkepEFatura\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @param \TurkkepEFatura\StructType\ChargeableQuantityType $chargeableQuantity
     * @param \TurkkepEFatura\StructType\ReturnableQuantityType $returnableQuantity
     * @param \TurkkepEFatura\StructType\TraceIDType $traceID
     * @param \TurkkepEFatura\StructType\ItemType[] $item
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @param \TurkkepEFatura\StructType\InvoiceLineType[] $invoiceLine
     * @param \TurkkepEFatura\StructType\TemperatureType[] $temperature
     * @param \TurkkepEFatura\StructType\AddressType $originAddress
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, array $description = array(), \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, \TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \TurkkepEFatura\StructType\ValueAmountType $valueAmount = null, \TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure = null, \TurkkepEFatura\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null, \TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \TurkkepEFatura\StructType\QuantityType $quantity = null, \TurkkepEFatura\StructType\RequiredCustomsIDType $requiredCustomsID = null, \TurkkepEFatura\StructType\CustomsStatusCodeType $customsStatusCode = null, \TurkkepEFatura\StructType\CustomsTariffQuantityType $customsTariffQuantity = null, \TurkkepEFatura\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null, \TurkkepEFatura\StructType\ChargeableQuantityType $chargeableQuantity = null, \TurkkepEFatura\StructType\ReturnableQuantityType $returnableQuantity = null, \TurkkepEFatura\StructType\TraceIDType $traceID = null, array $item = array(), array $freightAllowanceCharge = array(), array $invoiceLine = array(), array $temperature = array(), \TurkkepEFatura\StructType\AddressType $originAddress = null, array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setValueAmount($valueAmount)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setChargeableWeightMeasure($chargeableWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setChargeableQuantity($chargeableQuantity)
            ->setReturnableQuantity($returnableQuantity)
            ->setTraceID($traceID)
            ->setItem($item)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setInvoiceLine($invoiceLine)
            ->setTemperature($temperature)
            ->setOriginAddress($originAddress)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Description value
     * @return \TurkkepEFatura\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeDescriptionItem instanceof \TurkkepEFatura\StructType\DescriptionType) {
                $invalidValues[] = is_object($goodsItemTypeDescriptionItem) ? get_class($goodsItemTypeDescriptionItem) : sprintf('%s(%s)', gettype($goodsItemTypeDescriptionItem), var_export($goodsItemTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \TurkkepEFatura\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DescriptionType[] $description
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DescriptionType $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function addToDescription(\TurkkepEFatura\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \TurkkepEFatura\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \TurkkepEFatura\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setHazardousRiskIndicator(\TurkkepEFatura\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setDeclaredCustomsValueAmount(\TurkkepEFatura\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setDeclaredForCarriageValueAmount(\TurkkepEFatura\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setDeclaredStatisticsValueAmount(\TurkkepEFatura\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \TurkkepEFatura\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setFreeOnBoardValueAmount(\TurkkepEFatura\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \TurkkepEFatura\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setInsuranceValueAmount(\TurkkepEFatura\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get ValueAmount value
     * @return \TurkkepEFatura\StructType\ValueAmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }
    /**
     * Set ValueAmount value
     * @param \TurkkepEFatura\StructType\ValueAmountType $valueAmount
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setValueAmount(\TurkkepEFatura\StructType\ValueAmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \TurkkepEFatura\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setGrossWeightMeasure(\TurkkepEFatura\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \TurkkepEFatura\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setNetWeightMeasure(\TurkkepEFatura\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get ChargeableWeightMeasure value
     * @return \TurkkepEFatura\StructType\ChargeableWeightMeasureType|null
     */
    public function getChargeableWeightMeasure()
    {
        return $this->ChargeableWeightMeasure;
    }
    /**
     * Set ChargeableWeightMeasure value
     * @param \TurkkepEFatura\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setChargeableWeightMeasure(\TurkkepEFatura\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null)
    {
        $this->ChargeableWeightMeasure = $chargeableWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \TurkkepEFatura\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setGrossVolumeMeasure(\TurkkepEFatura\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \TurkkepEFatura\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setNetVolumeMeasure(\TurkkepEFatura\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \TurkkepEFatura\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \TurkkepEFatura\StructType\QuantityType $quantity
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setQuantity(\TurkkepEFatura\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequiredCustomsID value
     * @return \TurkkepEFatura\StructType\RequiredCustomsIDType|null
     */
    public function getRequiredCustomsID()
    {
        return $this->RequiredCustomsID;
    }
    /**
     * Set RequiredCustomsID value
     * @param \TurkkepEFatura\StructType\RequiredCustomsIDType $requiredCustomsID
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setRequiredCustomsID(\TurkkepEFatura\StructType\RequiredCustomsIDType $requiredCustomsID = null)
    {
        $this->RequiredCustomsID = $requiredCustomsID;
        return $this;
    }
    /**
     * Get CustomsStatusCode value
     * @return \TurkkepEFatura\StructType\CustomsStatusCodeType|null
     */
    public function getCustomsStatusCode()
    {
        return $this->CustomsStatusCode;
    }
    /**
     * Set CustomsStatusCode value
     * @param \TurkkepEFatura\StructType\CustomsStatusCodeType $customsStatusCode
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setCustomsStatusCode(\TurkkepEFatura\StructType\CustomsStatusCodeType $customsStatusCode = null)
    {
        $this->CustomsStatusCode = $customsStatusCode;
        return $this;
    }
    /**
     * Get CustomsTariffQuantity value
     * @return \TurkkepEFatura\StructType\CustomsTariffQuantityType|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }
    /**
     * Set CustomsTariffQuantity value
     * @param \TurkkepEFatura\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setCustomsTariffQuantity(\TurkkepEFatura\StructType\CustomsTariffQuantityType $customsTariffQuantity = null)
    {
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }
    /**
     * Get CustomsImportClassifiedIndicator value
     * @return \TurkkepEFatura\StructType\CustomsImportClassifiedIndicatorType|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }
    /**
     * Set CustomsImportClassifiedIndicator value
     * @param \TurkkepEFatura\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setCustomsImportClassifiedIndicator(\TurkkepEFatura\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null)
    {
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }
    /**
     * Get ChargeableQuantity value
     * @return \TurkkepEFatura\StructType\ChargeableQuantityType|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }
    /**
     * Set ChargeableQuantity value
     * @param \TurkkepEFatura\StructType\ChargeableQuantityType $chargeableQuantity
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setChargeableQuantity(\TurkkepEFatura\StructType\ChargeableQuantityType $chargeableQuantity = null)
    {
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }
    /**
     * Get ReturnableQuantity value
     * @return \TurkkepEFatura\StructType\ReturnableQuantityType|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }
    /**
     * Set ReturnableQuantity value
     * @param \TurkkepEFatura\StructType\ReturnableQuantityType $returnableQuantity
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setReturnableQuantity(\TurkkepEFatura\StructType\ReturnableQuantityType $returnableQuantity = null)
    {
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \TurkkepEFatura\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \TurkkepEFatura\StructType\TraceIDType $traceID
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setTraceID(\TurkkepEFatura\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get Item value
     * @return \TurkkepEFatura\StructType\ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeItemItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeItemItem instanceof \TurkkepEFatura\StructType\ItemType) {
                $invalidValues[] = is_object($goodsItemTypeItemItem) ? get_class($goodsItemTypeItemItem) : sprintf('%s(%s)', gettype($goodsItemTypeItemItem), var_export($goodsItemTypeItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \TurkkepEFatura\StructType\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemType[] $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\ItemType $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function addToItem(\TurkkepEFatura\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \TurkkepEFatura\StructType\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get FreightAllowanceCharge value
     * @return \TurkkepEFatura\StructType\AllowanceChargeType[]|null
     */
    public function getFreightAllowanceCharge()
    {
        return $this->FreightAllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setFreightAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFreightAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeFreightAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeFreightAllowanceChargeItem instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($goodsItemTypeFreightAllowanceChargeItem) ? get_class($goodsItemTypeFreightAllowanceChargeItem) : sprintf('%s(%s)', gettype($goodsItemTypeFreightAllowanceChargeItem), var_export($goodsItemTypeFreightAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FreightAllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setFreightAllowanceCharge(array $freightAllowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($freightAllowanceChargeArrayErrorMessage = self::validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge($freightAllowanceCharge))) {
            throw new \InvalidArgumentException($freightAllowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->FreightAllowanceCharge = $freightAllowanceCharge;
        return $this;
    }
    /**
     * Add item to FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\AllowanceChargeType $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function addToFreightAllowanceCharge(\TurkkepEFatura\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The FreightAllowanceCharge property can only contain items of type \TurkkepEFatura\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FreightAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \TurkkepEFatura\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeInvoiceLineItem instanceof \TurkkepEFatura\StructType\InvoiceLineType) {
                $invalidValues[] = is_object($goodsItemTypeInvoiceLineItem) ? get_class($goodsItemTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($goodsItemTypeInvoiceLineItem), var_export($goodsItemTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \TurkkepEFatura\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\InvoiceLineType[] $invoiceLine
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new \InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\InvoiceLineType $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function addToInvoiceLine(\TurkkepEFatura\StructType\InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\InvoiceLineType) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \TurkkepEFatura\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get Temperature value
     * @return \TurkkepEFatura\StructType\TemperatureType[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureForArrayConstraintsFromSetTemperature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeTemperatureItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeTemperatureItem instanceof \TurkkepEFatura\StructType\TemperatureType) {
                $invalidValues[] = is_object($goodsItemTypeTemperatureItem) ? get_class($goodsItemTypeTemperatureItem) : sprintf('%s(%s)', gettype($goodsItemTypeTemperatureItem), var_export($goodsItemTypeTemperatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Temperature property can only contain items of type \TurkkepEFatura\StructType\TemperatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Temperature value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TemperatureType[] $temperature
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setTemperature(array $temperature = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureArrayErrorMessage = self::validateTemperatureForArrayConstraintsFromSetTemperature($temperature))) {
            throw new \InvalidArgumentException($temperatureArrayErrorMessage, __LINE__);
        }
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TemperatureType $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function addToTemperature(\TurkkepEFatura\StructType\TemperatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TemperatureType) {
            throw new \InvalidArgumentException(sprintf('The Temperature property can only contain items of type \TurkkepEFatura\StructType\TemperatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Get OriginAddress value
     * @return \TurkkepEFatura\StructType\AddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }
    /**
     * Set OriginAddress value
     * @param \TurkkepEFatura\StructType\AddressType $originAddress
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setOriginAddress(\TurkkepEFatura\StructType\AddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \TurkkepEFatura\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeMeasurementDimensionItem instanceof \TurkkepEFatura\StructType\DimensionType) {
                $invalidValues[] = is_object($goodsItemTypeMeasurementDimensionItem) ? get_class($goodsItemTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($goodsItemTypeMeasurementDimensionItem), var_export($goodsItemTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType[] $measurementDimension
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DimensionType $item
     * @return \TurkkepEFatura\StructType\GoodsItemType
     */
    public function addToMeasurementDimension(\TurkkepEFatura\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \TurkkepEFatura\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
