<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GelenFaturaYanitla StructType
 * @subpackage Structs
 */
class GelenFaturaYanitla extends AbstractStructBase
{
    /**
     * The faturaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $faturaNo;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * The faturaYaniti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $faturaYaniti;
    /**
     * The yanitAciklamasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $yanitAciklamasi;
    /**
     * Constructor method for GelenFaturaYanitla
     * @uses GelenFaturaYanitla::setFaturaNo()
     * @uses GelenFaturaYanitla::setToken()
     * @uses GelenFaturaYanitla::setFaturaYaniti()
     * @uses GelenFaturaYanitla::setYanitAciklamasi()
     * @param int $faturaNo
     * @param string $token
     * @param string $faturaYaniti
     * @param string $yanitAciklamasi
     */
    public function __construct($faturaNo = null, $token = null, $faturaYaniti = null, $yanitAciklamasi = null)
    {
        $this
            ->setFaturaNo($faturaNo)
            ->setToken($token)
            ->setFaturaYaniti($faturaYaniti)
            ->setYanitAciklamasi($yanitAciklamasi);
    }
    /**
     * Get faturaNo value
     * @return int
     */
    public function getFaturaNo()
    {
        return $this->faturaNo;
    }
    /**
     * Set faturaNo value
     * @param int $faturaNo
     * @return \TurkkepEFatura\StructType\GelenFaturaYanitla
     */
    public function setFaturaNo($faturaNo = null)
    {
        // validation for constraint: int
        if (!is_null($faturaNo) && !(is_int($faturaNo) || ctype_digit($faturaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faturaNo, true), gettype($faturaNo)), __LINE__);
        }
        $this->faturaNo = $faturaNo;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \TurkkepEFatura\StructType\GelenFaturaYanitla
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get faturaYaniti value
     * @return string|null
     */
    public function getFaturaYaniti()
    {
        return $this->faturaYaniti;
    }
    /**
     * Set faturaYaniti value
     * @param string $faturaYaniti
     * @return \TurkkepEFatura\StructType\GelenFaturaYanitla
     */
    public function setFaturaYaniti($faturaYaniti = null)
    {
        // validation for constraint: string
        if (!is_null($faturaYaniti) && !is_string($faturaYaniti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaYaniti, true), gettype($faturaYaniti)), __LINE__);
        }
        $this->faturaYaniti = $faturaYaniti;
        return $this;
    }
    /**
     * Get yanitAciklamasi value
     * @return string|null
     */
    public function getYanitAciklamasi()
    {
        return $this->yanitAciklamasi;
    }
    /**
     * Set yanitAciklamasi value
     * @param string $yanitAciklamasi
     * @return \TurkkepEFatura\StructType\GelenFaturaYanitla
     */
    public function setYanitAciklamasi($yanitAciklamasi = null)
    {
        // validation for constraint: string
        if (!is_null($yanitAciklamasi) && !is_string($yanitAciklamasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yanitAciklamasi, true), gettype($yanitAciklamasi)), __LINE__);
        }
        $this->yanitAciklamasi = $yanitAciklamasi;
        return $this;
    }
}
