<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaturaNumarasiSorgula StructType
 * @subpackage Structs
 */
class FaturaNumarasiSorgula extends AbstractStructBase
{
    /**
     * The invoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $invoiceId;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for FaturaNumarasiSorgula
     * @uses FaturaNumarasiSorgula::setInvoiceId()
     * @uses FaturaNumarasiSorgula::setToken()
     * @param int $invoiceId
     * @param string $token
     */
    public function __construct($invoiceId = null, $token = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setToken($token);
    }
    /**
     * Get invoiceId value
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param int $invoiceId
     * @return \TurkkepEFatura\StructType\FaturaNumarasiSorgula
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceId) && !(is_int($invoiceId) || ctype_digit($invoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \TurkkepEFatura\StructType\FaturaNumarasiSorgula
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
}
