<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentReferenceType StructType
 * @subpackage Structs
 */
class DocumentReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:ID
     * @var \TurkkepEFatura\StructType\IDType
     */
    public $ID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:IssueDate
     * @var \TurkkepEFatura\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DocumentTypeCode
     * @var \TurkkepEFatura\StructType\DocumentTypeCodeType
     */
    public $DocumentTypeCode;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s3:DocumentType
     * @var \TurkkepEFatura\StructType\DocumentTypeType
     */
    public $DocumentType;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s3:DocumentDescription
     * @var \TurkkepEFatura\StructType\DocumentDescriptionType[]
     */
    public $DocumentDescription;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\AttachmentType
     */
    public $Attachment;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurkkepEFatura\StructType\PartyType
     */
    public $IssuerParty;
    /**
     * Constructor method for DocumentReferenceType
     * @uses DocumentReferenceType::setID()
     * @uses DocumentReferenceType::setIssueDate()
     * @uses DocumentReferenceType::setDocumentTypeCode()
     * @uses DocumentReferenceType::setDocumentType()
     * @uses DocumentReferenceType::setDocumentDescription()
     * @uses DocumentReferenceType::setAttachment()
     * @uses DocumentReferenceType::setValidityPeriod()
     * @uses DocumentReferenceType::setIssuerParty()
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @param \TurkkepEFatura\StructType\IssueDateType $issueDate
     * @param \TurkkepEFatura\StructType\DocumentTypeCodeType $documentTypeCode
     * @param \TurkkepEFatura\StructType\DocumentTypeType $documentType
     * @param \TurkkepEFatura\StructType\DocumentDescriptionType[] $documentDescription
     * @param \TurkkepEFatura\StructType\AttachmentType $attachment
     * @param \TurkkepEFatura\StructType\PeriodType $validityPeriod
     * @param \TurkkepEFatura\StructType\PartyType $issuerParty
     */
    public function __construct(\TurkkepEFatura\StructType\IDType $iD = null, \TurkkepEFatura\StructType\IssueDateType $issueDate = null, \TurkkepEFatura\StructType\DocumentTypeCodeType $documentTypeCode = null, \TurkkepEFatura\StructType\DocumentTypeType $documentType = null, array $documentDescription = array(), \TurkkepEFatura\StructType\AttachmentType $attachment = null, \TurkkepEFatura\StructType\PeriodType $validityPeriod = null, \TurkkepEFatura\StructType\PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setDocumentTypeCode($documentTypeCode)
            ->setDocumentType($documentType)
            ->setDocumentDescription($documentDescription)
            ->setAttachment($attachment)
            ->setValidityPeriod($validityPeriod)
            ->setIssuerParty($issuerParty);
    }
    /**
     * Get ID value
     * @return \TurkkepEFatura\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \TurkkepEFatura\StructType\IDType $iD
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setID(\TurkkepEFatura\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \TurkkepEFatura\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \TurkkepEFatura\StructType\IssueDateType $issueDate
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setIssueDate(\TurkkepEFatura\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * @return \TurkkepEFatura\StructType\DocumentTypeCodeType|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }
    /**
     * Set DocumentTypeCode value
     * @param \TurkkepEFatura\StructType\DocumentTypeCodeType $documentTypeCode
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setDocumentTypeCode(\TurkkepEFatura\StructType\DocumentTypeCodeType $documentTypeCode = null)
    {
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return \TurkkepEFatura\StructType\DocumentTypeType|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param \TurkkepEFatura\StructType\DocumentTypeType $documentType
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setDocumentType(\TurkkepEFatura\StructType\DocumentTypeType $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentDescription value
     * @return \TurkkepEFatura\StructType\DocumentDescriptionType[]|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentReferenceTypeDocumentDescriptionItem) {
            // validation for constraint: itemType
            if (!$documentReferenceTypeDocumentDescriptionItem instanceof \TurkkepEFatura\StructType\DocumentDescriptionType) {
                $invalidValues[] = is_object($documentReferenceTypeDocumentDescriptionItem) ? get_class($documentReferenceTypeDocumentDescriptionItem) : sprintf('%s(%s)', gettype($documentReferenceTypeDocumentDescriptionItem), var_export($documentReferenceTypeDocumentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDescription property can only contain items of type \TurkkepEFatura\StructType\DocumentDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentDescriptionType[] $documentDescription
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setDocumentDescription(array $documentDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDescriptionArrayErrorMessage = self::validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription($documentDescription))) {
            throw new \InvalidArgumentException($documentDescriptionArrayErrorMessage, __LINE__);
        }
        $this->DocumentDescription = $documentDescription;
        return $this;
    }
    /**
     * Add item to DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\DocumentDescriptionType $item
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function addToDocumentDescription(\TurkkepEFatura\StructType\DocumentDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\DocumentDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The DocumentDescription property can only contain items of type \TurkkepEFatura\StructType\DocumentDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDescription[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \TurkkepEFatura\StructType\AttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \TurkkepEFatura\StructType\AttachmentType $attachment
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setAttachment(\TurkkepEFatura\StructType\AttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \TurkkepEFatura\StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \TurkkepEFatura\StructType\PeriodType $validityPeriod
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setValidityPeriod(\TurkkepEFatura\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get IssuerParty value
     * @return \TurkkepEFatura\StructType\PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }
    /**
     * Set IssuerParty value
     * @param \TurkkepEFatura\StructType\PartyType $issuerParty
     * @return \TurkkepEFatura\StructType\DocumentReferenceType
     */
    public function setIssuerParty(\TurkkepEFatura\StructType\PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
}
