<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatchDeliveryParty StructType
 * @subpackage Structs
 */
class DispatchDeliveryParty extends AbstractStructBase
{
    /**
     * The Dispatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Dispatch;
    /**
     * The District
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $District;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The BuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingNo;
    /**
     * The FlatNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlatNo;
    /**
     * The CitySubDivision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CitySubDivision;
    /**
     * Constructor method for DispatchDeliveryParty
     * @uses DispatchDeliveryParty::setDispatch()
     * @uses DispatchDeliveryParty::setDistrict()
     * @uses DispatchDeliveryParty::setCity()
     * @uses DispatchDeliveryParty::setPostalCode()
     * @uses DispatchDeliveryParty::setCountry()
     * @uses DispatchDeliveryParty::setStreet()
     * @uses DispatchDeliveryParty::setBuildingName()
     * @uses DispatchDeliveryParty::setBuildingNo()
     * @uses DispatchDeliveryParty::setFlatNo()
     * @uses DispatchDeliveryParty::setCitySubDivision()
     * @param int $dispatch
     * @param string $district
     * @param string $city
     * @param string $postalCode
     * @param string $country
     * @param string $street
     * @param string $buildingName
     * @param string $buildingNo
     * @param string $flatNo
     * @param string $citySubDivision
     */
    public function __construct($dispatch = null, $district = null, $city = null, $postalCode = null, $country = null, $street = null, $buildingName = null, $buildingNo = null, $flatNo = null, $citySubDivision = null)
    {
        $this
            ->setDispatch($dispatch)
            ->setDistrict($district)
            ->setCity($city)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setStreet($street)
            ->setBuildingName($buildingName)
            ->setBuildingNo($buildingNo)
            ->setFlatNo($flatNo)
            ->setCitySubDivision($citySubDivision);
    }
    /**
     * Get Dispatch value
     * @return int
     */
    public function getDispatch()
    {
        return $this->Dispatch;
    }
    /**
     * Set Dispatch value
     * @param int $dispatch
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setDispatch($dispatch = null)
    {
        // validation for constraint: int
        if (!is_null($dispatch) && !(is_int($dispatch) || ctype_digit($dispatch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dispatch, true), gettype($dispatch)), __LINE__);
        }
        $this->Dispatch = $dispatch;
        return $this;
    }
    /**
     * Get District value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->District;
    }
    /**
     * Set District value
     * @param string $district
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->District = $district;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get BuildingName value
     * @return string|null
     */
    public function getBuildingName()
    {
        return $this->BuildingName;
    }
    /**
     * Set BuildingName value
     * @param string $buildingName
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        $this->BuildingName = $buildingName;
        return $this;
    }
    /**
     * Get BuildingNo value
     * @return string|null
     */
    public function getBuildingNo()
    {
        return $this->BuildingNo;
    }
    /**
     * Set BuildingNo value
     * @param string $buildingNo
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setBuildingNo($buildingNo = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNo) && !is_string($buildingNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNo, true), gettype($buildingNo)), __LINE__);
        }
        $this->BuildingNo = $buildingNo;
        return $this;
    }
    /**
     * Get FlatNo value
     * @return string|null
     */
    public function getFlatNo()
    {
        return $this->FlatNo;
    }
    /**
     * Set FlatNo value
     * @param string $flatNo
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setFlatNo($flatNo = null)
    {
        // validation for constraint: string
        if (!is_null($flatNo) && !is_string($flatNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flatNo, true), gettype($flatNo)), __LINE__);
        }
        $this->FlatNo = $flatNo;
        return $this;
    }
    /**
     * Get CitySubDivision value
     * @return string|null
     */
    public function getCitySubDivision()
    {
        return $this->CitySubDivision;
    }
    /**
     * Set CitySubDivision value
     * @param string $citySubDivision
     * @return \TurkkepEFatura\StructType\DispatchDeliveryParty
     */
    public function setCitySubDivision($citySubDivision = null)
    {
        // validation for constraint: string
        if (!is_null($citySubDivision) && !is_string($citySubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citySubDivision, true), gettype($citySubDivision)), __LINE__);
        }
        $this->CitySubDivision = $citySubDivision;
        return $this;
    }
}
