<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchNote StructType
 * @subpackage Structs
 */
class DespatchNote extends AbstractStructBase
{
    /**
     * The DespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DespatchDate;
    /**
     * The DespatchNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DespatchNumber;
    /**
     * Constructor method for DespatchNote
     * @uses DespatchNote::setDespatchDate()
     * @uses DespatchNote::setDespatchNumber()
     * @param string $despatchDate
     * @param string $despatchNumber
     */
    public function __construct($despatchDate = null, $despatchNumber = null)
    {
        $this
            ->setDespatchDate($despatchDate)
            ->setDespatchNumber($despatchNumber);
    }
    /**
     * Get DespatchDate value
     * @return string
     */
    public function getDespatchDate()
    {
        return $this->DespatchDate;
    }
    /**
     * Set DespatchDate value
     * @param string $despatchDate
     * @return \TurkkepEFatura\StructType\DespatchNote
     */
    public function setDespatchDate($despatchDate = null)
    {
        // validation for constraint: string
        if (!is_null($despatchDate) && !is_string($despatchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchDate, true), gettype($despatchDate)), __LINE__);
        }
        $this->DespatchDate = $despatchDate;
        return $this;
    }
    /**
     * Get DespatchNumber value
     * @return string|null
     */
    public function getDespatchNumber()
    {
        return $this->DespatchNumber;
    }
    /**
     * Set DespatchNumber value
     * @param string $despatchNumber
     * @return \TurkkepEFatura\StructType\DespatchNote
     */
    public function setDespatchNumber($despatchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($despatchNumber) && !is_string($despatchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchNumber, true), gettype($despatchNumber)), __LINE__);
        }
        $this->DespatchNumber = $despatchNumber;
        return $this;
    }
}
