<?php

namespace TurkkepEFatura\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInfo StructType
 * @subpackage Structs
 */
class AdditionalInfo extends AbstractStructBase
{
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssueDate;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeCode;
    /**
     * Constructor method for AdditionalInfo
     * @uses AdditionalInfo::setIssueDate()
     * @uses AdditionalInfo::setID()
     * @uses AdditionalInfo::setDocumentType()
     * @uses AdditionalInfo::setDocumentTypeCode()
     * @param string $issueDate
     * @param string $iD
     * @param string $documentType
     * @param string $documentTypeCode
     */
    public function __construct($issueDate = null, $iD = null, $documentType = null, $documentTypeCode = null)
    {
        $this
            ->setIssueDate($issueDate)
            ->setID($iD)
            ->setDocumentType($documentType)
            ->setDocumentTypeCode($documentTypeCode);
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \TurkkepEFatura\StructType\AdditionalInfo
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \TurkkepEFatura\StructType\AdditionalInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \TurkkepEFatura\StructType\AdditionalInfo
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * @return string|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }
    /**
     * Set DocumentTypeCode value
     * @param string $documentTypeCode
     * @return \TurkkepEFatura\StructType\AdditionalInfo
     */
    public function setDocumentTypeCode($documentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeCode) && !is_string($documentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeCode, true), gettype($documentTypeCode)), __LINE__);
        }
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }
}
