<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Yeni ServiceType
 * @subpackage Services
 */
class Yeni extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named YeniGelenFaturalariListele
     * Meta information extracted from the WSDL
     * - documentation: Yeni Gelen Faturaların Listesini gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenFaturalariListele $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenFaturalariListeleResponse|bool
     */
    public function YeniGelenFaturalariListele(\TurkkepEFatura\StructType\YeniGelenFaturalariListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenFaturalariListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named YeniGelenFaturaAlindiByUUID
     * Meta information extracted from the WSDL
     * - documentation: Yeni Gelen Faturaların alındığını belirtmek için kullanılır.Fatura Numarası ve kimlik numarasını parametre olarak alır
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenFaturaAlindiByUUID $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenFaturaAlindiByUUIDResponse|bool
     */
    public function YeniGelenFaturaAlindiByUUID(\TurkkepEFatura\StructType\YeniGelenFaturaAlindiByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenFaturaAlindiByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named YeniGelenFaturaAlindiByFaturaNoVkn
     * Meta information extracted from the WSDL
     * - documentation: Yeni Gelen Faturaların alındığını belirtmek için kullanılır.Fatura Numarası ve kimlik numarasını parametre olarak alır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenFaturaAlindiByFaturaNoVkn $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenFaturaAlindiByFaturaNoVknResponse|bool
     */
    public function YeniGelenFaturaAlindiByFaturaNoVkn(\TurkkepEFatura\StructType\YeniGelenFaturaAlindiByFaturaNoVkn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenFaturaAlindiByFaturaNoVkn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named YeniGelenIrsaliyeleriListele
     * Meta information extracted from the WSDL
     * - documentation: Yeni Gelen Irsaliyeleri listeler.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenIrsaliyeleriListele $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenIrsaliyeleriListeleResponse|bool
     */
    public function YeniGelenIrsaliyeleriListele(\TurkkepEFatura\StructType\YeniGelenIrsaliyeleriListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenIrsaliyeleriListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named YeniGelenIrsaliyeAlindiByUUID
     * Meta information extracted from the WSDL
     * - documentation: Yeni Gelen Irsaliyelerin alındığını belirtmek için kullanılır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenIrsaliyeAlindiByUUID $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenIrsaliyeAlindiByUUIDResponse|bool
     */
    public function YeniGelenIrsaliyeAlindiByUUID(\TurkkepEFatura\StructType\YeniGelenIrsaliyeAlindiByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenIrsaliyeAlindiByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named YeniGelenFaturaYanitlariListele
     * Meta information extracted from the WSDL
     * - documentation: Fatura Yanıtları yeni gelen faturaları listeler.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenFaturaYanitlariListele $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenFaturaYanitlariListeleResponse|bool
     */
    public function YeniGelenFaturaYanitlariListele(\TurkkepEFatura\StructType\YeniGelenFaturaYanitlariListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenFaturaYanitlariListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * YeniGelenFaturaYanitlariAlindiByUUID
     * Meta information extracted from the WSDL
     * - documentation: Yeni Gelen Fatura yanıtlarının alındığını belirtmek için kullanılır. Fatura UUID'sini parametre olarak alır.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\YeniGelenFaturaYanitlariAlindiByUUID $parameters
     * @return \TurkkepEFatura\StructType\YeniGelenFaturaYanitlariAlindiByUUIDResponse|bool
     */
    public function YeniGelenFaturaYanitlariAlindiByUUID(\TurkkepEFatura\StructType\YeniGelenFaturaYanitlariAlindiByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->YeniGelenFaturaYanitlariAlindiByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\YeniGelenFaturaAlindiByFaturaNoVknResponse|\TurkkepEFatura\StructType\YeniGelenFaturaAlindiByUUIDResponse|\TurkkepEFatura\StructType\YeniGelenFaturalariListeleResponse|\TurkkepEFatura\StructType\YeniGelenFaturaYanitlariAlindiByUUIDResponse|\TurkkepEFatura\StructType\YeniGelenFaturaYanitlariListeleResponse|\TurkkepEFatura\StructType\YeniGelenIrsaliyeAlindiByUUIDResponse|\TurkkepEFatura\StructType\YeniGelenIrsaliyeleriListeleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
