<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendMail
     * Meta information extracted from the WSDL
     * - documentation: Tanımlı kullanıcı ve parola bilgisini alıp turkkep üzer mail gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\SendMail $parameters
     * @return \TurkkepEFatura\StructType\SendMailResponse|bool
     */
    public function SendMail(\TurkkepEFatura\StructType\SendMail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\SendMailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
