<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Manuel ServiceType
 * @subpackage Services
 */
class Manuel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ManuelFaturalariListele
     * Meta information extracted from the WSDL
     * - documentation: Portalden kesilen faturaların listesini gönderir verilen tarih aralığındaki.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\ManuelFaturalariListele $parameters
     * @return \TurkkepEFatura\StructType\ManuelFaturalariListeleResponse|bool
     */
    public function ManuelFaturalariListele(\TurkkepEFatura\StructType\ManuelFaturalariListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ManuelFaturalariListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\ManuelFaturalariListeleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
