<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kayitli ServiceType
 * @subpackage Services
 */
class Kayitli extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KayitliMukellefListele
     * Meta information extracted from the WSDL
     * - documentation: GİB tarafından yayınlanan e-fatura kullanıcı listesini getirir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\KayitliMukellefListele $parameters
     * @return \TurkkepEFatura\StructType\KayitliMukellefListeleResponse|bool
     */
    public function KayitliMukellefListele(\TurkkepEFatura\StructType\KayitliMukellefListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->KayitliMukellefListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named KayitliMukellefListeleDokumanTipi
     * Meta information extracted from the WSDL
     * - documentation: GİB tarafından yayınlanan tipe göre e-fatura veya e-irsaliye kullanıcı listesini getirir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\KayitliMukellefListeleDokumanTipi $parameters
     * @return \TurkkepEFatura\StructType\KayitliMukellefListeleDokumanTipiResponse|bool
     */
    public function KayitliMukellefListeleDokumanTipi(\TurkkepEFatura\StructType\KayitliMukellefListeleDokumanTipi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->KayitliMukellefListeleDokumanTipi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\KayitliMukellefListeleDokumanTipiResponse|\TurkkepEFatura\StructType\KayitliMukellefListeleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
