<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gelen ServiceType
 * @subpackage Services
 */
class Gelen extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * GelenIrsaliyeninYanitiniGetirByIrsaliyeUuid
     * Meta information extracted from the WSDL
     * - documentation: Verilen Irsaliye Uuid değeri ile gelen irsaliyeye verilen yanıtın detayını okur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeninYanitiniGetirByIrsaliyeUuid $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeninYanitiniGetirByIrsaliyeUuidResponse|bool
     */
    public function GelenIrsaliyeninYanitiniGetirByIrsaliyeUuid(\TurkkepEFatura\StructType\GelenIrsaliyeninYanitiniGetirByIrsaliyeUuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeninYanitiniGetirByIrsaliyeUuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaOku
     * Meta information extracted from the WSDL
     * - documentation: Gelen fatura detayını okur. GelenFaturaListele veya GelenFaturaAra metodlarının sonucunda gelen elemanları doğrudan göndermek mümkündür.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaOku $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaOkuResponse|bool
     */
    public function GelenFaturaOku(\TurkkepEFatura\StructType\GelenFaturaOku $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaOku($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeUblGetirByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturanın Ubl değerini verir XmlContent alanında.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeUblGetirByUUID $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeUblGetirByUUIDResponse|bool
     */
    public function GelenIrsaliyeUblGetirByUUID(\TurkkepEFatura\StructType\GelenIrsaliyeUblGetirByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeUblGetirByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaUblGetirByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturanın Ubl değerini verir XmlContent alanında.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaUblGetirByUUID $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaUblGetirByUUIDResponse|bool
     */
    public function GelenFaturaUblGetirByUUID(\TurkkepEFatura\StructType\GelenFaturaUblGetirByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaUblGetirByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaOkuByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gelen fatura detayını okur verilen UUID değerine göre.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaOkuByUUID $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaOkuByUUIDResponse|bool
     */
    public function GelenFaturaOkuByUUID(\TurkkepEFatura\StructType\GelenFaturaOkuByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaOkuByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaYanitla
     * Meta information extracted from the WSDL
     * - documentation: Gelen bir faturaya KABUL veya RET yanıtı döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaYanitla $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaYanitlaResponse|bool
     */
    public function GelenFaturaYanitla(\TurkkepEFatura\StructType\GelenFaturaYanitla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaYanitla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaAra
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse tarih
     * aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaAra $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaAraResponse|bool
     */
    public function GelenFaturaAra(\TurkkepEFatura\StructType\GelenFaturaAra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaAra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaAraAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse tarih
     * aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaAraAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaAraAnaOrganizasyonResponse|bool
     */
    public function GelenFaturaAraAnaOrganizasyon(\TurkkepEFatura\StructType\GelenFaturaAraAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaAraAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaAra2
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse tarih
     * aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaAra2 $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaAra2Response|bool
     */
    public function GelenFaturaAra2(\TurkkepEFatura\StructType\GelenFaturaAra2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaAra2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaAra3
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse tarih
     * aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaAra3 $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaAra3Response|bool
     */
    public function GelenFaturaAra3(\TurkkepEFatura\StructType\GelenFaturaAra3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaAra3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaPdfAl
     * Meta information extracted from the WSDL
     * - documentation: Gelen Faturanın Pdf'ini döner. FaturaGonder metodlarından dönen InvoiceId gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaPdfAl $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaPdfAlResponse|bool
     */
    public function GelenFaturaPdfAl(\TurkkepEFatura\StructType\GelenFaturaPdfAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaPdfAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaHtmlAl
     * Meta information extracted from the WSDL
     * - documentation: Gelen Faturanın Html'ini döner. FaturaGonder metodlarından dönen InvoiceId gönderilmelidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaHtmlAl $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaHtmlAlResponse|bool
     */
    public function GelenFaturaHtmlAl(\TurkkepEFatura\StructType\GelenFaturaHtmlAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaHtmlAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaTumZarflar
     * Meta information extracted from the WSDL
     * - documentation: Gelen Fatura Tüm Zarflar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaTumZarflar $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaTumZarflarResponse|bool
     */
    public function GelenFaturaTumZarflar(\TurkkepEFatura\StructType\GelenFaturaTumZarflar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaTumZarflar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaArsiveGonder
     * Meta information extracted from the WSDL
     * - documentation: Gelen Faturaları Arşive Gönderir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaArsiveGonder $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaArsiveGonderResponse|bool
     */
    public function GelenFaturaArsiveGonder(\TurkkepEFatura\StructType\GelenFaturaArsiveGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaArsiveGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaArsivdenGeriAl
     * Meta information extracted from the WSDL
     * - documentation: Gelen Faturaları Arşivden Geri Al
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaArsivdenGeriAl $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaArsivdenGeriAlResponse|bool
     */
    public function GelenFaturaArsivdenGeriAl(\TurkkepEFatura\StructType\GelenFaturaArsivdenGeriAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaArsivdenGeriAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenFaturaAraByIssueDate
     * Meta information extracted from the WSDL
     * - documentation: Gelen faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo' verilmezse tarih
     * aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenFaturaAraByIssueDate $parameters
     * @return \TurkkepEFatura\StructType\GelenFaturaAraByIssueDateResponse|bool
     */
    public function GelenFaturaAraByIssueDate(\TurkkepEFatura\StructType\GelenFaturaAraByIssueDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenFaturaAraByIssueDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GelenIrsaliyeFaturaAraAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Gelen Irsaliye faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo'
     * verilmezse tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeFaturaAraAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeFaturaAraAnaOrganizasyonResponse|bool
     */
    public function GelenIrsaliyeFaturaAraAnaOrganizasyon(\TurkkepEFatura\StructType\GelenIrsaliyeFaturaAraAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeFaturaAraAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeFaturaOku
     * Meta information extracted from the WSDL
     * - documentation: Gelen Faturanın detayını okur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeFaturaOku $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeFaturaOkuResponse|bool
     */
    public function GelenIrsaliyeFaturaOku(\TurkkepEFatura\StructType\GelenIrsaliyeFaturaOku $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeFaturaOku($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeFaturaAra
     * Meta information extracted from the WSDL
     * - documentation: Gelen Irsaliye faturalar içerisinde arama yapar. Gelen listedeki faturalarda fatura kalemleri bulunmaz. Fatura detayları için GelenFaturaOku kullanılmalıdır. 'kimlikNo' olarak VKN veya TCKN kullanılabilir. 'kimlikNo'
     * verilmezse tarih aralığı en fazla 3 ay olabilir. Her durumda bulunan fatura sayısı 1000'i geçerse hata döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeFaturaAra $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeFaturaAraResponse|bool
     */
    public function GelenIrsaliyeFaturaAra(\TurkkepEFatura\StructType\GelenIrsaliyeFaturaAra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeFaturaAra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyePdfHtmlAl
     * Meta information extracted from the WSDL
     * - documentation: Giden Irsaliye faturanın pdf'ini ve html'ini döner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyePdfHtmlAl $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyePdfHtmlAlResponse|bool
     */
    public function GelenIrsaliyePdfHtmlAl(\TurkkepEFatura\StructType\GelenIrsaliyePdfHtmlAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyePdfHtmlAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeArsivdenGeriAl
     * Meta information extracted from the WSDL
     * - documentation: Gelen Faturaları Arşivden Geri Al
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeArsivdenGeriAl $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeArsivdenGeriAlResponse|bool
     */
    public function GelenIrsaliyeArsivdenGeriAl(\TurkkepEFatura\StructType\GelenIrsaliyeArsivdenGeriAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeArsivdenGeriAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeArsiveGonder
     * Meta information extracted from the WSDL
     * - documentation: Gelen Irsaliye Arşive Gönderir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeArsiveGonder $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeArsiveGonderResponse|bool
     */
    public function GelenIrsaliyeArsiveGonder(\TurkkepEFatura\StructType\GelenIrsaliyeArsiveGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeArsiveGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyePdfAl
     * Meta information extracted from the WSDL
     * - documentation: Gelen Irsaliye faturanın pdf'ini ve html'ini döner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyePdfAl $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyePdfAlResponse|bool
     */
    public function GelenIrsaliyePdfAl(\TurkkepEFatura\StructType\GelenIrsaliyePdfAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyePdfAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeYanitla
     * Meta information extracted from the WSDL
     * - documentation: Gelen bir irsaliyeye KABUL veya RET yanıtı döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeYanitla $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeYanitlaResponse|bool
     */
    public function GelenIrsaliyeYanitla(\TurkkepEFatura\StructType\GelenIrsaliyeYanitla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeYanitla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GelenIrsaliyeManuelYanitla
     * Meta information extracted from the WSDL
     * - documentation: Gelen bir irsaliyeye MANUEL yanıt döner.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\GelenIrsaliyeManuelYanitla $parameters
     * @return \TurkkepEFatura\StructType\GelenIrsaliyeManuelYanitlaResponse|bool
     */
    public function GelenIrsaliyeManuelYanitla(\TurkkepEFatura\StructType\GelenIrsaliyeManuelYanitla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GelenIrsaliyeManuelYanitla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\GelenFaturaAra2Response|\TurkkepEFatura\StructType\GelenFaturaAra3Response|\TurkkepEFatura\StructType\GelenFaturaAraAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GelenFaturaAraByIssueDateResponse|\TurkkepEFatura\StructType\GelenFaturaAraResponse|\TurkkepEFatura\StructType\GelenFaturaArsivdenGeriAlResponse|\TurkkepEFatura\StructType\GelenFaturaArsiveGonderResponse|\TurkkepEFatura\StructType\GelenFaturaHtmlAlResponse|\TurkkepEFatura\StructType\GelenFaturaOkuByUUIDResponse|\TurkkepEFatura\StructType\GelenFaturaOkuResponse|\TurkkepEFatura\StructType\GelenFaturaPdfAlResponse|\TurkkepEFatura\StructType\GelenFaturaTumZarflarResponse|\TurkkepEFatura\StructType\GelenFaturaUblGetirByUUIDResponse|\TurkkepEFatura\StructType\GelenFaturaYanitlaResponse|\TurkkepEFatura\StructType\GelenIrsaliyeArsivdenGeriAlResponse|\TurkkepEFatura\StructType\GelenIrsaliyeArsiveGonderResponse|\TurkkepEFatura\StructType\GelenIrsaliyeFaturaAraAnaOrganizasyonResponse|\TurkkepEFatura\StructType\GelenIrsaliyeFaturaAraResponse|\TurkkepEFatura\StructType\GelenIrsaliyeFaturaOkuResponse|\TurkkepEFatura\StructType\GelenIrsaliyeManuelYanitlaResponse|\TurkkepEFatura\StructType\GelenIrsaliyeninYanitiniGetirByIrsaliyeUuidResponse|\TurkkepEFatura\StructType\GelenIrsaliyePdfAlResponse|\TurkkepEFatura\StructType\GelenIrsaliyePdfHtmlAlResponse|\TurkkepEFatura\StructType\GelenIrsaliyeUblGetirByUUIDResponse|\TurkkepEFatura\StructType\GelenIrsaliyeYanitlaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
