<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Earsiv ServiceType
 * @subpackage Services
 */
class Earsiv extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EarsivImzaliPdfAl
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen e-Arşiv Faturanın Imzalı pdf dosyasını sıkışıtırılımış olarak verir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EarsivImzaliPdfAl $parameters
     * @return \TurkkepEFatura\StructType\EarsivImzaliPdfAlResponse|bool
     */
    public function EarsivImzaliPdfAl(\TurkkepEFatura\StructType\EarsivImzaliPdfAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EarsivImzaliPdfAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EarsivImzaliPdfAlByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen e-Arşiv Faturanın Imzalı pdf dosyasını sıkışıtırılımış olarak verir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EarsivImzaliPdfAlByUUID $parameters
     * @return \TurkkepEFatura\StructType\EarsivImzaliPdfAlByUUIDResponse|bool
     */
    public function EarsivImzaliPdfAlByUUID(\TurkkepEFatura\StructType\EarsivImzaliPdfAlByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EarsivImzaliPdfAlByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EarsivFaturaIptalEt
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen e-Arşiv Faturanın iptal edilmesini sağlar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EarsivFaturaIptalEt $parameters
     * @return \TurkkepEFatura\StructType\EarsivFaturaIptalEtResponse|bool
     */
    public function EarsivFaturaIptalEt(\TurkkepEFatura\StructType\EarsivFaturaIptalEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EarsivFaturaIptalEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EarsivFaturaIptalEtByUUID
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen e-Arşiv Faturanın iptal edilmesini sağlar verilen UUID değeri ile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUID $parameters
     * @return \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDResponse|bool
     */
    public function EarsivFaturaIptalEtByUUID(\TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EarsivFaturaIptalEtByUUID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EarsivFaturaIptalEtByUUIDAnaOrganizasyon
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen e-Arşiv Faturanın iptal edilmesini sağlar verilen UUID değeri ile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDAnaOrganizasyon $parameters
     * @return \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDAnaOrganizasyonResponse|bool
     */
    public function EarsivFaturaIptalEtByUUIDAnaOrganizasyon(\TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDAnaOrganizasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EarsivFaturaIptalEtByUUIDAnaOrganizasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EarsivFaturaIptalEtByUUIDIptalTarihi
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen e-Arşiv Faturanın iptal edilmesini sağlar verilen UUID değeri ile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDIptalTarihi $parameters
     * @return \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDIptalTarihiResponse|bool
     */
    public function EarsivFaturaIptalEtByUUIDIptalTarihi(\TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDIptalTarihi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EarsivFaturaIptalEtByUUIDIptalTarihi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDAnaOrganizasyonResponse|\TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDIptalTarihiResponse|\TurkkepEFatura\StructType\EarsivFaturaIptalEtByUUIDResponse|\TurkkepEFatura\StructType\EarsivFaturaIptalEtResponse|\TurkkepEFatura\StructType\EarsivImzaliPdfAlByUUIDResponse|\TurkkepEFatura\StructType\EarsivImzaliPdfAlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
