<?php

namespace TurkkepEFatura\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bayi ServiceType
 * @subpackage Services
 */
class Bayi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BayiKontorSorgula
     * Meta information extracted from the WSDL
     * - documentation: Bayilerin kontor sorgulaması için kontor bilgilerini gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \TurkkepEFatura\StructType\BayiKontorSorgula $parameters
     * @return \TurkkepEFatura\StructType\BayiKontorSorgulaResponse|bool
     */
    public function BayiKontorSorgula(\TurkkepEFatura\StructType\BayiKontorSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BayiKontorSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \TurkkepEFatura\StructType\BayiKontorSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
