<?php

namespace TurkkepEFatura\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTaxSubtotal ArrayType
 * @subpackage Arrays
 */
class ArrayOfTaxSubtotal extends AbstractStructArrayBase
{
    /**
     * The TaxSubtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurkkepEFatura\StructType\TaxSubtotal[]
     */
    public $TaxSubtotal;
    /**
     * Constructor method for ArrayOfTaxSubtotal
     * @uses ArrayOfTaxSubtotal::setTaxSubtotal()
     * @param \TurkkepEFatura\StructType\TaxSubtotal[] $taxSubtotal
     */
    public function __construct(array $taxSubtotal = array())
    {
        $this
            ->setTaxSubtotal($taxSubtotal);
    }
    /**
     * Get TaxSubtotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurkkepEFatura\StructType\TaxSubtotal[]|null
     */
    public function getTaxSubtotal()
    {
        return isset($this->TaxSubtotal) ? $this->TaxSubtotal : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSubtotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSubtotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSubtotalForArrayConstraintsFromSetTaxSubtotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTaxSubtotalTaxSubtotalItem) {
            // validation for constraint: itemType
            if (!$arrayOfTaxSubtotalTaxSubtotalItem instanceof \TurkkepEFatura\StructType\TaxSubtotal) {
                $invalidValues[] = is_object($arrayOfTaxSubtotalTaxSubtotalItem) ? get_class($arrayOfTaxSubtotalTaxSubtotalItem) : sprintf('%s(%s)', gettype($arrayOfTaxSubtotalTaxSubtotalItem), var_export($arrayOfTaxSubtotalTaxSubtotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSubtotal property can only contain items of type \TurkkepEFatura\StructType\TaxSubtotal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSubtotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxSubtotal[] $taxSubtotal
     * @return \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal
     */
    public function setTaxSubtotal(array $taxSubtotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSubtotalArrayErrorMessage = self::validateTaxSubtotalForArrayConstraintsFromSetTaxSubtotal($taxSubtotal))) {
            throw new \InvalidArgumentException($taxSubtotalArrayErrorMessage, __LINE__);
        }
        if (is_null($taxSubtotal) || (is_array($taxSubtotal) && empty($taxSubtotal))) {
            unset($this->TaxSubtotal);
        } else {
            $this->TaxSubtotal = $taxSubtotal;
        }
        return $this;
    }
    /**
     * Add item to TaxSubtotal value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\TaxSubtotal $item
     * @return \TurkkepEFatura\ArrayType\ArrayOfTaxSubtotal
     */
    public function addToTaxSubtotal(\TurkkepEFatura\StructType\TaxSubtotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\TaxSubtotal) {
            throw new \InvalidArgumentException(sprintf('The TaxSubtotal property can only contain items of type \TurkkepEFatura\StructType\TaxSubtotal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSubtotal[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurkkepEFatura\StructType\TaxSubtotal|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurkkepEFatura\StructType\TaxSubtotal|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurkkepEFatura\StructType\TaxSubtotal|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurkkepEFatura\StructType\TaxSubtotal|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurkkepEFatura\StructType\TaxSubtotal|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TaxSubtotal
     */
    public function getAttributeName()
    {
        return 'TaxSubtotal';
    }
}
