<?php

namespace TurkkepEFatura\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKontorList ArrayType
 * @subpackage Arrays
 */
class ArrayOfKontorList extends AbstractStructArrayBase
{
    /**
     * The KontorList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurkkepEFatura\StructType\KontorList[]
     */
    public $KontorList;
    /**
     * Constructor method for ArrayOfKontorList
     * @uses ArrayOfKontorList::setKontorList()
     * @param \TurkkepEFatura\StructType\KontorList[] $kontorList
     */
    public function __construct(array $kontorList = array())
    {
        $this
            ->setKontorList($kontorList);
    }
    /**
     * Get KontorList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurkkepEFatura\StructType\KontorList[]|null
     */
    public function getKontorList()
    {
        return isset($this->KontorList) ? $this->KontorList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKontorList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKontorList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKontorListForArrayConstraintsFromSetKontorList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfKontorListKontorListItem) {
            // validation for constraint: itemType
            if (!$arrayOfKontorListKontorListItem instanceof \TurkkepEFatura\StructType\KontorList) {
                $invalidValues[] = is_object($arrayOfKontorListKontorListItem) ? get_class($arrayOfKontorListKontorListItem) : sprintf('%s(%s)', gettype($arrayOfKontorListKontorListItem), var_export($arrayOfKontorListKontorListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KontorList property can only contain items of type \TurkkepEFatura\StructType\KontorList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KontorList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\KontorList[] $kontorList
     * @return \TurkkepEFatura\ArrayType\ArrayOfKontorList
     */
    public function setKontorList(array $kontorList = array())
    {
        // validation for constraint: array
        if ('' !== ($kontorListArrayErrorMessage = self::validateKontorListForArrayConstraintsFromSetKontorList($kontorList))) {
            throw new \InvalidArgumentException($kontorListArrayErrorMessage, __LINE__);
        }
        if (is_null($kontorList) || (is_array($kontorList) && empty($kontorList))) {
            unset($this->KontorList);
        } else {
            $this->KontorList = $kontorList;
        }
        return $this;
    }
    /**
     * Add item to KontorList value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\KontorList $item
     * @return \TurkkepEFatura\ArrayType\ArrayOfKontorList
     */
    public function addToKontorList(\TurkkepEFatura\StructType\KontorList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\KontorList) {
            throw new \InvalidArgumentException(sprintf('The KontorList property can only contain items of type \TurkkepEFatura\StructType\KontorList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KontorList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurkkepEFatura\StructType\KontorList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurkkepEFatura\StructType\KontorList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurkkepEFatura\StructType\KontorList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurkkepEFatura\StructType\KontorList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurkkepEFatura\StructType\KontorList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string KontorList
     */
    public function getAttributeName()
    {
        return 'KontorList';
    }
}
