<?php

namespace TurkkepEFatura\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoice ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoice extends AbstractStructArrayBase
{
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurkkepEFatura\StructType\Invoice[]
     */
    public $Invoice;
    /**
     * Constructor method for ArrayOfInvoice
     * @uses ArrayOfInvoice::setInvoice()
     * @param \TurkkepEFatura\StructType\Invoice[] $invoice
     */
    public function __construct(array $invoice = array())
    {
        $this
            ->setInvoice($invoice);
    }
    /**
     * Get Invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurkkepEFatura\StructType\Invoice[]|null
     */
    public function getInvoice()
    {
        return isset($this->Invoice) ? $this->Invoice : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceForArrayConstraintsFromSetInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceInvoiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceInvoiceItem instanceof \TurkkepEFatura\StructType\Invoice) {
                $invalidValues[] = is_object($arrayOfInvoiceInvoiceItem) ? get_class($arrayOfInvoiceInvoiceItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceInvoiceItem), var_export($arrayOfInvoiceInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice property can only contain items of type \TurkkepEFatura\StructType\Invoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\Invoice[] $invoice
     * @return \TurkkepEFatura\ArrayType\ArrayOfInvoice
     */
    public function setInvoice(array $invoice = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceArrayErrorMessage = self::validateInvoiceForArrayConstraintsFromSetInvoice($invoice))) {
            throw new \InvalidArgumentException($invoiceArrayErrorMessage, __LINE__);
        }
        if (is_null($invoice) || (is_array($invoice) && empty($invoice))) {
            unset($this->Invoice);
        } else {
            $this->Invoice = $invoice;
        }
        return $this;
    }
    /**
     * Add item to Invoice value
     * @throws \InvalidArgumentException
     * @param \TurkkepEFatura\StructType\Invoice $item
     * @return \TurkkepEFatura\ArrayType\ArrayOfInvoice
     */
    public function addToInvoice(\TurkkepEFatura\StructType\Invoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurkkepEFatura\StructType\Invoice) {
            throw new \InvalidArgumentException(sprintf('The Invoice property can only contain items of type \TurkkepEFatura\StructType\Invoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TurkkepEFatura\StructType\Invoice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TurkkepEFatura\StructType\Invoice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TurkkepEFatura\StructType\Invoice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TurkkepEFatura\StructType\Invoice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TurkkepEFatura\StructType\Invoice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Invoice
     */
    public function getAttributeName()
    {
        return 'Invoice';
    }
}
